/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email.live;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.mail.Session;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.mail.CompositeMailListener;
import org.xwiki.mail.MailListener;
import org.xwiki.mail.MailSender;
import org.xwiki.mail.SessionFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.notifications.notifiers.internal.email.live.PrefilteringMimeMessageIterator;

@Component(roles={PrefilteringLiveNotificationEmailSender.class})
@Singleton
public class PrefilteringLiveNotificationEmailSender {
    public static final LocalDocumentReference TEMPLATE = new LocalDocumentReference(Arrays.asList("XWiki", "Notifications"), "MailTemplate");
    @Inject
    private SessionFactory sessionFactory;
    @Inject
    @Named(value="database")
    private Provider<MailListener> mailListenerProvider;
    @Inject
    private MailSender mailSender;
    @Inject
    private Provider<PrefilteringMimeMessageIterator> liveMimeMessageIteratorProvider;

    public void sendMails(Map<DocumentReference, List<Event>> eventsToSend) {
        PrefilteringMimeMessageIterator liveNotificationMessageIterator = (PrefilteringMimeMessageIterator)this.liveMimeMessageIteratorProvider.get();
        liveNotificationMessageIterator.initialize(eventsToSend, new HashMap<String, Object>(), (EntityReference)TEMPLATE);
        Session session = this.sessionFactory.create(Collections.emptyMap());
        MailListener mailListener = (MailListener)this.mailListenerProvider.get();
        this.mailSender.sendAsynchronously((Iterable)liveNotificationMessageIterator, session, (MailListener)new CompositeMailListener(mailListener, new MailListener[]{liveNotificationMessageIterator.getMailListener()}));
    }
}

