/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email.live;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.concurrent.ExecutionContextRunnable;
import org.xwiki.eventstream.EntityEvent;
import org.xwiki.eventstream.internal.DefaultEntityEvent;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.notifications.notifiers.internal.email.IntervalUsersManager;
import org.xwiki.notifications.notifiers.internal.email.live.MissingLiveNotificationMailsRequest;
import org.xwiki.notifications.notifiers.internal.email.live.PrefilteringLiveNotificationEmailDispatcher;
import org.xwiki.notifications.preferences.NotificationEmailInterval;

@Component(roles={PrefilteringLiveNotificationEmailManager.class})
@Singleton
public class PrefilteringLiveNotificationEmailManager
implements Initializable,
Disposable {
    private static final EntityEvent STOP = new DefaultEntityEvent(null, null);
    @Inject
    private PrefilteringLiveNotificationEmailDispatcher dispatcher;
    @Inject
    private JobExecutor executor;
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private IntervalUsersManager intervals;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    private final BlockingQueue<EntityEvent> preQueue = new LinkedBlockingQueue<EntityEvent>();
    private boolean disposed;

    public void initialize() throws InitializationException {
        Thread optimizeThreadthread = new Thread((Runnable)new ExecutionContextRunnable(this::prepare, this.componentManager));
        optimizeThreadthread.setName("Pre filtering Live mail notification optimizer");
        optimizeThreadthread.setPriority(4);
        optimizeThreadthread.setDaemon(true);
        optimizeThreadthread.start();
    }

    public void dispose() throws ComponentLifecycleException {
        this.disposed = true;
        this.preQueue.clear();
        this.preQueue.add(STOP);
    }

    private void prepare() {
        while (!this.disposed) {
            DocumentReference userDocumentReference;
            NotificationEmailInterval interval;
            EntityEvent event;
            try {
                event = this.preQueue.take();
            }
            catch (InterruptedException e) {
                this.logger.warn("The thread handling live event optimization has been interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
                break;
            }
            if (event == STOP || (interval = this.intervals.getInterval(userDocumentReference = this.resolver.resolve((Object)event.getEntityId(), new Object[]{event.getEvent().getWiki()}))) != NotificationEmailInterval.LIVE) continue;
            this.dispatcher.addEvent(event.getEvent(), userDocumentReference);
        }
    }

    public void addEvent(EntityEvent entityEvent) {
        if (!this.preQueue.add(entityEvent)) {
            this.logger.warn("The event [{}] could not be added to the queue of live notification mails. It generally means the queue was already full because more event are produced than sent.", (Object)entityEvent);
        }
    }

    public void addEvents(String wikiId) {
        try {
            this.executor.execute("notification.livemails.resume", (Request)new MissingLiveNotificationMailsRequest(wikiId));
        }
        catch (JobException e) {
            this.logger.error("Failed to start the processing of missed live notification events", (Throwable)e);
        }
    }
}

