/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email.live;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventQuery;
import org.xwiki.eventstream.EventSearchResult;
import org.xwiki.eventstream.EventStore;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.query.SimpleEventQuery;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.notifiers.internal.email.IntervalUsersManager;
import org.xwiki.notifications.notifiers.internal.email.live.MissingLiveNotificationMailsRequest;
import org.xwiki.notifications.notifiers.internal.email.live.PrefilteringLiveNotificationEmailDispatcher;
import org.xwiki.notifications.preferences.NotificationEmailInterval;

@Component
@Named(value="notification.livemails.resume")
public class MissingLiveNotificationMailsJob
extends AbstractJob<MissingLiveNotificationMailsRequest, DefaultJobStatus<MissingLiveNotificationMailsRequest>> {
    public static final String JOBTYPE = "notification.livemails.resume";
    @Inject
    private PrefilteringLiveNotificationEmailDispatcher dispatcher;
    @Inject
    private EventStore eventStore;
    @Inject
    private EntityReferenceSerializer<String> referenceSerializer;
    @Inject
    private IntervalUsersManager intervals;

    public String getType() {
        return JOBTYPE;
    }

    protected void runInternal() throws Exception {
        List<DocumentReference> users = this.intervals.getUsers(NotificationEmailInterval.LIVE, ((MissingLiveNotificationMailsRequest)this.getRequest()).getWiki());
        for (DocumentReference user : users) {
            SimpleEventQuery query = new SimpleEventQuery();
            query.withMail((String)this.referenceSerializer.serialize((EntityReference)user, new Object[0]));
            try {
                EventSearchResult result = this.eventStore.search((EventQuery)query);
                result.stream().forEach(event -> this.dispatcher.addEvent((Event)event, user));
            }
            catch (EventStreamException e) {
                this.logger.error("Failed to get events to send bby mail to the user [{}]", (Object)user, (Object)e);
            }
        }
    }
}

