/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import java.util.Collections;
import java.util.Iterator;
import javax.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.notifiers.internal.email.IntervalUsersManager;
import org.xwiki.notifications.preferences.NotificationEmailInterval;
import org.xwiki.query.QueryException;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component(roles={NotificationUserIterator.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class NotificationUserIterator
implements Iterator<DocumentReference> {
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private IntervalUsersManager usersManager;
    @Inject
    private Logger logger;
    private Iterator<DocumentReference> iterator;
    private NotificationEmailInterval interval;

    public void initialize(NotificationEmailInterval interval) {
        this.interval = interval;
        try {
            this.iterator = this.usersManager.getUsers(interval, this.wikiDescriptorManager.getCurrentWikiId()).iterator();
        }
        catch (QueryException e) {
            this.logger.warn("Failed to retrieve the notification users. Root error [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            this.iterator = Collections.emptyIterator();
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public DocumentReference next() {
        return this.iterator.next();
    }

    public NotificationEmailInterval getInterval() {
        return this.interval;
    }
}

