/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.internal.reference.EntityReferenceFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.preferences.NotificationEmailInterval;
import org.xwiki.notifications.preferences.email.NotificationEmailUserPreferenceManager;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component(roles={IntervalUsersManager.class})
@Singleton
public class IntervalUsersManager {
    private static final int BATCH_SIZE = 100;
    private static final String XWQL_QUERY = "select distinct doc.fullName from Document doc, doc.object(XWiki.XWikiUsers) objUser where objUser.active = 1 and length(objUser.email) > 0 order by doc.fullName";
    @Inject
    private QueryManager queryManager;
    @Inject
    private DocumentReferenceResolver<String> referenceResolver;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> userReferenceResolver;
    @Inject
    private EntityReferenceFactory referenceFactory;
    @Inject
    private NotificationEmailUserPreferenceManager emailUserPreferenceManager;
    private final Map<String, WikiEntry> usersCache = new ConcurrentHashMap<String, WikiEntry>();

    public List<DocumentReference> getUsers(NotificationEmailInterval interval, String wiki) throws QueryException {
        WikiEntry wikiEntry = this.getWikiEntry(wiki);
        wikiEntry.usersPerIntervalLock.readLock().lock();
        try {
            if (wikiEntry.reloadUsers) {
                wikiEntry.usersPerInterval.clear();
            } else {
                List<DocumentReference> users = wikiEntry.usersPerInterval.get(interval);
                if (users != null) {
                    List<DocumentReference> list = users;
                    return list;
                }
            }
        }
        catch (RuntimeException e) {
            throw (QueryException)e.getCause();
        }
        finally {
            wikiEntry.usersPerIntervalLock.readLock().unlock();
        }
        wikiEntry.usersPerIntervalLock.writeLock().lock();
        try {
            List e = wikiEntry.usersPerInterval.computeIfAbsent(interval, i -> this.loadUsers((NotificationEmailInterval)i, wikiEntry));
            return e;
        }
        catch (RuntimeException e) {
            throw (QueryException)e.getCause();
        }
        finally {
            wikiEntry.usersPerIntervalLock.writeLock().unlock();
        }
    }

    private WikiEntry getWikiEntry(String wiki) {
        return this.usersCache.computeIfAbsent(wiki, k -> new WikiEntry(wiki));
    }

    public NotificationEmailInterval getInterval(DocumentReference userDocumentReference) {
        return this.getWikiEntry((String)userDocumentReference.getWikiReference().getName()).intervalPerUser.computeIfAbsent((DocumentReference)this.referenceFactory.getReference((EntityReference)userDocumentReference), this::loadInterval);
    }

    private NotificationEmailInterval loadInterval(DocumentReference userDocumentReference) {
        UserReference userReference = this.userReferenceResolver.resolve((Object)userDocumentReference, new Object[0]);
        return this.emailUserPreferenceManager.getInterval(userReference);
    }

    private List<DocumentReference> loadUsers(NotificationEmailInterval targetInterval, WikiEntry wikiEntry) {
        ArrayList<DocumentReference> userReferences = null;
        while (userReferences == null || wikiEntry.reloadUsers) {
            wikiEntry.reloadUsers = false;
            userReferences = new ArrayList<DocumentReference>();
            int batchSize = 100;
            int offset = 0;
            while (batchSize == 100) {
                try {
                    batchSize = this.loadUsers(targetInterval, wikiEntry, offset, userReferences);
                }
                catch (QueryException e) {
                    throw new RuntimeException(e);
                }
                offset += 100;
            }
        }
        return userReferences;
    }

    private int loadUsers(NotificationEmailInterval targetInterval, WikiEntry wikiEntry, int offset, List<DocumentReference> userReferences) throws QueryException {
        if (wikiEntry.reloadUsers) {
            return -1;
        }
        Query query = this.queryManager.createQuery(XWQL_QUERY, "xwql");
        query.setWiki(wikiEntry.wiki);
        query.setLimit(100);
        query.setOffset(offset);
        List users = query.execute();
        if (!users.isEmpty()) {
            WikiReference wikiReference = new WikiReference(wikiEntry.wiki);
            for (String user : users) {
                if (wikiEntry.reloadUsers) {
                    return -1;
                }
                DocumentReference userDocumentReference = this.referenceResolver.resolve((Object)user, new Object[]{wikiReference});
                NotificationEmailInterval userInterval = this.getInterval(userDocumentReference);
                if (userInterval != targetInterval) continue;
                userReferences.add((DocumentReference)this.referenceFactory.getReference((EntityReference)userDocumentReference));
            }
        }
        return users.size();
    }

    public void invalidateWiki(String wikiId) {
        this.usersCache.remove(wikiId);
    }

    public void invalidateUser(DocumentReference userReference) {
        WikiEntry wikiEntry = this.usersCache.get(userReference.getWikiReference().getName());
        if (wikiEntry != null) {
            wikiEntry.intervalPerUser.remove(userReference);
            wikiEntry.reloadUsers = true;
        }
    }

    private static final class WikiEntry {
        private final String wiki;
        private final Map<DocumentReference, NotificationEmailInterval> intervalPerUser = new ConcurrentHashMap<DocumentReference, NotificationEmailInterval>();
        private ReentrantReadWriteLock usersPerIntervalLock = new ReentrantReadWriteLock();
        private final Map<NotificationEmailInterval, List<DocumentReference>> usersPerInterval = new EnumMap<NotificationEmailInterval, List<DocumentReference>>(NotificationEmailInterval.class);
        private volatile boolean reloadUsers = true;

        WikiEntry(String wiki) {
            this.wiki = wiki;
        }
    }
}

