/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.localization.Translation;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.CompositeEventStatus;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.NotificationRenderer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.util.ErrorBlockGenerator;

@Component(roles={InternalHtmlNotificationRenderer.class})
@Singleton
public class InternalHtmlNotificationRenderer {
    private static final String TM_FAILEDRENDER = "notification.error.failedRender";
    private static final String CLASS_PARAMETER = "class";
    @Inject
    private NotificationRenderer notificationRenderer;
    @Inject
    private ErrorBlockGenerator errorBlockGenerator;
    @Inject
    private ContextualLocalizationManager localizationManager;
    @Inject
    @Named(value="html/5.0")
    private BlockRenderer htmlRenderer;

    public String render(int count) {
        String displayCount = String.valueOf(count);
        FormatBlock formatBlock = new FormatBlock();
        WordBlock wordBlock = new WordBlock(displayCount);
        formatBlock.addChild((Block)wordBlock);
        formatBlock.setParameter(CLASS_PARAMETER, "notifications-count badge");
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.htmlRenderer.render((Block)formatBlock, (WikiPrinter)printer);
        return printer.toString();
    }

    public String render(CompositeEvent compositeEvent, CompositeEventStatus status) throws Exception {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.htmlRenderer.render(this.renderCompositeEvent(compositeEvent, status), (WikiPrinter)printer);
        return printer.toString();
    }

    private Block renderCompositeEvent(CompositeEvent compositeEvent, CompositeEventStatus status) throws NotificationException {
        Block renderedEvent = this.notificationRenderer.render(compositeEvent);
        GroupBlock parentDiv = new GroupBlock();
        StringBuilder parentDivClass = new StringBuilder().append("notification-event");
        parentDiv.setParameter("data-eventtype", compositeEvent.getType());
        parentDiv.setParameter("data-ids", StringUtils.join((Iterable)compositeEvent.getEventIds(), (String)","));
        parentDiv.setParameter("data-eventdate", String.valueOf(this.getLastCompositeEventDate(compositeEvent).getTime()));
        if (status != null && !status.getStatus()) {
            parentDivClass.append(" notification-event-unread");
        }
        parentDiv.setParameter(CLASS_PARAMETER, parentDivClass.toString());
        parentDiv.addChild(renderedEvent);
        return parentDiv;
    }

    private Date getLastCompositeEventDate(CompositeEvent compositeEvent) {
        return (Date)compositeEvent.getDates().get(compositeEvent.getDates().size() - 1);
    }

    private Block renderNoEvent() {
        Translation translation = this.localizationManager.getTranslation("notifications.menu.nothing");
        ParagraphBlock paragraphBlock = new ParagraphBlock(Collections.singletonList(translation.render(new Object[0])));
        paragraphBlock.setParameter(CLASS_PARAMETER, "text-center noitems");
        return paragraphBlock;
    }

    private Block renderLoadMore() {
        GroupBlock groupBlock = new GroupBlock();
        groupBlock.setParameter(CLASS_PARAMETER, "notifications-macro-load-more");
        return groupBlock;
    }

    public String render(List<CompositeEvent> compositeEvents, List<CompositeEventStatus> compositeEventStatuses, boolean loadMore) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean useStatus = compositeEventStatuses != null && compositeEventStatuses.size() == compositeEvents.size();
        for (int i = 0; i < compositeEvents.size(); ++i) {
            CompositeEvent compositeEvent = compositeEvents.get(i);
            CompositeEventStatus compositeEventStatus = null;
            if (useStatus) {
                compositeEventStatus = compositeEventStatuses.get(i);
            }
            try {
                stringBuilder.append(this.render(compositeEvent, compositeEventStatus));
                continue;
            }
            catch (Exception e) {
                DefaultWikiPrinter printer = new DefaultWikiPrinter();
                this.htmlRenderer.render((Collection)this.errorBlockGenerator.generateErrorBlocks(false, TM_FAILEDRENDER, "Error while rendering notification", null, new Object[]{e}), (WikiPrinter)printer);
                stringBuilder.append(printer.toString());
            }
        }
        if (compositeEvents.isEmpty()) {
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.htmlRenderer.render(this.renderNoEvent(), (WikiPrinter)printer);
            stringBuilder.append(printer.toString());
        }
        if (loadMore) {
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.htmlRenderer.render(this.renderLoadMore(), (WikiPrinter)printer);
            stringBuilder.append(printer.toString());
        }
        return stringBuilder.toString();
    }
}

