/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.watch.script;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.watch.AutomaticWatchMode;
import org.xwiki.notifications.filters.watch.WatchedEntitiesConfiguration;
import org.xwiki.notifications.filters.watch.WatchedEntitiesManager;
import org.xwiki.notifications.filters.watch.WatchedEntityFactory;
import org.xwiki.notifications.filters.watch.WatchedEntityReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.internal.document.DocumentUserReference;

@Component
@Singleton
@Named(value="notification.watch")
public class NotificationWatchScriptService
implements ScriptService {
    public static final String ROLE_HINT = "notification.watch";
    @Inject
    private WatchedEntitiesManager watchedEntitiesManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private WatchedEntityFactory watchedEntityFactory;
    @Inject
    private WatchedEntitiesConfiguration configuration;

    public boolean isEnabled() {
        return this.configuration.isEnabled();
    }

    public void watchLocation(EntityReference location) throws NotificationException {
        this.watchedEntitiesManager.watchEntity(this.watchedEntityFactory.createWatchedLocationReference(location), this.documentAccessBridge.getCurrentUserReference());
    }

    public void unwatchLocation(EntityReference location) throws NotificationException {
        this.watchedEntitiesManager.unwatchEntity(this.watchedEntityFactory.createWatchedLocationReference(location), this.documentAccessBridge.getCurrentUserReference());
    }

    public WatchedEntityReference.WatchedStatus getLocationWatchedStatus(EntityReference location) throws NotificationException {
        return this.watchedEntityFactory.createWatchedLocationReference(location).getWatchedStatus((UserReference)CurrentUserReference.INSTANCE);
    }

    @Unstable
    public Pair<EntityReference, WatchedEntityReference.WatchedStatus> getFirstFilteredAncestor(EntityReference location) throws NotificationException {
        return this.watchedEntityFactory.createWatchedLocationReference(location).getFirstFilteredAncestor((UserReference)CurrentUserReference.INSTANCE).orElse(null);
    }

    public boolean isLocationWatched(EntityReference location) throws NotificationException {
        return this.watchedEntityFactory.createWatchedLocationReference(location).isWatched(this.documentAccessBridge.getCurrentUserReference());
    }

    public boolean isLocationWatchedWithAllEventTypes(EntityReference location) throws NotificationException {
        return this.watchedEntityFactory.createWatchedLocationReference(location).isWatchedWithAllEventTypes(this.documentAccessBridge.getCurrentUserReference());
    }

    public boolean isUserWatched(String userId) throws NotificationException {
        return this.watchedEntityFactory.createWatchedUserReference(userId).isWatched(this.documentAccessBridge.getCurrentUserReference());
    }

    public void watchUser(String userId) throws NotificationException {
        this.watchedEntitiesManager.watchEntity(this.watchedEntityFactory.createWatchedUserReference(userId), this.documentAccessBridge.getCurrentUserReference());
    }

    public void unwatchUser(String userId) throws NotificationException {
        this.watchedEntitiesManager.unwatchEntity(this.watchedEntityFactory.createWatchedUserReference(userId), this.documentAccessBridge.getCurrentUserReference());
    }

    @Deprecated
    private DocumentReference convertReference(UserReference userReference) throws NotificationException {
        DocumentReference result;
        if (userReference == null || userReference == CurrentUserReference.INSTANCE) {
            result = this.documentAccessBridge.getCurrentUserReference();
        } else if (userReference instanceof DocumentUserReference) {
            result = ((DocumentUserReference)userReference).getReference();
        } else {
            throw new NotificationException(String.format("This should only be used with DocumentUserReference, the given reference was a [%s]", userReference.getClass().getSimpleName()));
        }
        return result;
    }

    public AutomaticWatchMode getAutomaticWatchMode() {
        return this.configuration.getAutomaticWatchMode(this.documentAccessBridge.getCurrentUserReference());
    }

    public AutomaticWatchMode getAutomaticWatchMode(UserReference userReference) throws NotificationException {
        return this.configuration.getAutomaticWatchMode(this.convertReference(userReference));
    }

    public AutomaticWatchMode getDefaultAutomaticWatchMode() {
        return this.configuration.getDefaultAutomaticWatchMode(this.documentAccessBridge.getCurrentDocumentReference().getWikiReference());
    }

    public Collection<String> getWatchedUsers() throws NotificationException {
        return this.watchedEntitiesManager.getWatchedUsers(this.documentAccessBridge.getCurrentUserReference());
    }
}

