/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.watch.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.watch.WatchedEntityFactory;
import org.xwiki.notifications.filters.watch.WatchedLocationReference;
import org.xwiki.notifications.filters.watch.WatchedUserReference;

@Component
@Singleton
public class DefaultWatchedEntityFactory
implements WatchedEntityFactory {
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;

    @Override
    public WatchedLocationReference createWatchedLocationReference(EntityReference location) throws NotificationException {
        try {
            return new WatchedLocationReference(location, this.componentManager);
        }
        catch (ComponentLookupException e) {
            throw new NotificationException("Error when instantiating a new WatchedLocationReference", (Throwable)e);
        }
    }

    @Override
    public WatchedUserReference createWatchedUserReference(String userId) throws NotificationException {
        try {
            return new WatchedUserReference(userId, this.componentManager);
        }
        catch (ComponentLookupException e) {
            throw new NotificationException("Error when instantiating a new WatchedUserReference", (Throwable)e);
        }
    }
}

