/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.watch.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.compress.utils.Sets;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterPreferenceManager;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.watch.WatchedEntitiesManager;
import org.xwiki.notifications.filters.watch.WatchedEntityReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.user.UserReferenceSerializer;

@Component
@Singleton
public class DefaultWatchedEntitiesManager
implements WatchedEntitiesManager {
    @Inject
    private NotificationFilterPreferenceManager notificationFilterPreferenceManager;
    @Inject
    @Named(value="document")
    private UserReferenceSerializer<DocumentReference> userReferenceSerializer;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> userReferenceResolver;

    @Override
    public void watchEntity(WatchedEntityReference entity, DocumentReference user) throws NotificationException {
        UserReference userReference = this.userReferenceResolver.resolve((Object)user, new Object[0]);
        this.handleEntity(entity, userReference, true);
    }

    @Override
    public boolean watch(WatchedEntityReference entity, UserReference user) throws NotificationException {
        return this.handleEntity(entity, user, true);
    }

    @Override
    public boolean removeWatchFilter(WatchedEntityReference entity, UserReference user) throws NotificationException {
        DocumentReference userDocRef = (DocumentReference)this.userReferenceSerializer.serialize(user);
        HashSet<String> filterPreferencesIds = new HashSet<String>();
        for (NotificationFilterPreference filterPreference : this.notificationFilterPreferenceManager.getFilterPreferences(userDocRef)) {
            if (!entity.matchExactly(filterPreference)) continue;
            filterPreferencesIds.add(filterPreference.getId());
        }
        boolean result = false;
        if (!filterPreferencesIds.isEmpty()) {
            this.notificationFilterPreferenceManager.deleteFilterPreferences(userDocRef, filterPreferencesIds);
            result = true;
        }
        return result;
    }

    @Override
    public boolean block(WatchedEntityReference entity, UserReference user) throws NotificationException {
        return this.handleEntity(entity, user, false);
    }

    @Override
    public void unwatchEntity(WatchedEntityReference entity, DocumentReference user) throws NotificationException {
        UserReference userReference = this.userReferenceResolver.resolve((Object)user, new Object[0]);
        this.handleEntity(entity, userReference, false);
    }

    @Override
    public Collection<String> getWatchedUsers(DocumentReference user) throws NotificationException {
        Collection filterPreferences = this.notificationFilterPreferenceManager.getFilterPreferences(user);
        HashSet<String> results = new HashSet<String>();
        Iterator iterator = filterPreferences.stream().filter(pref -> pref.isEnabled() && pref.getFilterName().equals("eventUserNotificationFilter") && pref.getFilterType() == NotificationFilterType.INCLUSIVE).iterator();
        while (iterator.hasNext()) {
            NotificationFilterPreference preference = (NotificationFilterPreference)iterator.next();
            results.add(preference.getUser());
        }
        return results;
    }

    private boolean handleEntity(WatchedEntityReference entity, UserReference user, boolean shouldBeWatched) throws NotificationException {
        boolean result = false;
        if (this.entityIsAlreadyInDesiredState(entity, user, shouldBeWatched)) {
            return result;
        }
        DocumentReference userDocRef = (DocumentReference)this.userReferenceSerializer.serialize(user);
        Iterator filterPreferences = this.notificationFilterPreferenceManager.getFilterPreferences(userDocRef).iterator();
        boolean matchFound = false;
        while (filterPreferences.hasNext()) {
            NotificationFilterPreference notificationFilterPreference = (NotificationFilterPreference)filterPreferences.next();
            if (entity.matchExactly(notificationFilterPreference)) {
                matchFound = true;
                if (notificationFilterPreference.getFilterType() == NotificationFilterType.INCLUSIVE && notificationFilterPreference.isEnabled() != shouldBeWatched) {
                    this.enableOrDeleteFilter(shouldBeWatched, notificationFilterPreference, userDocRef);
                    continue;
                }
                if (notificationFilterPreference.getFilterType() != NotificationFilterType.EXCLUSIVE || notificationFilterPreference.isEnabled() != shouldBeWatched) continue;
                this.enableOrDeleteFilter(!shouldBeWatched, notificationFilterPreference, userDocRef);
                continue;
            }
            if (!this.shouldDisableFilter(entity, notificationFilterPreference, shouldBeWatched)) continue;
            this.notificationFilterPreferenceManager.setFilterPreferenceEnabled(userDocRef, notificationFilterPreference.getId(), false);
        }
        if (!matchFound || !this.entityIsAlreadyInDesiredState(entity, user, shouldBeWatched)) {
            this.notificationFilterPreferenceManager.saveFilterPreferences(userDocRef, (Set)Sets.newHashSet((Object[])new NotificationFilterPreference[]{this.createFilterPreference(entity, shouldBeWatched)}));
            result = true;
        }
        return result;
    }

    private boolean shouldDisableFilter(WatchedEntityReference entity, NotificationFilterPreference filterPreference, boolean shouldBeWatched) {
        if (entity.match(filterPreference) && filterPreference.isEnabled()) {
            if (shouldBeWatched) {
                return filterPreference.getFilterType() == NotificationFilterType.EXCLUSIVE;
            }
            return filterPreference.getFilterType() == NotificationFilterType.INCLUSIVE;
        }
        return false;
    }

    private boolean entityIsAlreadyInDesiredState(WatchedEntityReference entity, UserReference user, boolean desiredState) throws NotificationException {
        WatchedEntityReference.WatchedStatus watchedStatus = entity.getWatchedStatus(user);
        return desiredState && watchedStatus.isWatched() || !desiredState && watchedStatus.isBlocked();
    }

    private void enableOrDeleteFilter(boolean enable, NotificationFilterPreference notificationFilterPreference, DocumentReference user) throws NotificationException {
        if (enable) {
            this.notificationFilterPreferenceManager.setFilterPreferenceEnabled(user, notificationFilterPreference.getId(), true);
        } else {
            this.notificationFilterPreferenceManager.deleteFilterPreference(user, notificationFilterPreference.getId());
        }
    }

    private NotificationFilterPreference createFilterPreference(WatchedEntityReference entity, boolean shouldBeWatched) {
        return shouldBeWatched ? entity.createInclusiveFilterPreference() : entity.createExclusiveFilterPreference();
    }
}

