/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.watch.internal;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.filters.watch.AutomaticWatchMode;
import org.xwiki.notifications.filters.watch.WatchedEntitiesConfiguration;
import org.xwiki.text.StringUtils;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultWatchedEntitiesConfiguration
implements WatchedEntitiesConfiguration {
    private static final String XWIKI_SPACE = "XWiki";
    private static final List<String> CODE_SPACE = Arrays.asList("XWiki", "Notifications", "Code");
    private static final LocalDocumentReference CLASS_REFERENCE = new LocalDocumentReference(CODE_SPACE, "AutomaticWatchModeClass");
    private static final LocalDocumentReference CONFIGURATION_REFERENCE = new LocalDocumentReference(CODE_SPACE, "NotificationAdministration");
    private static final String AUTOMATIC_WATCH_MODE = "automaticWatchMode";
    private static final String WATCHLIST_AUTOWATCH_PROPERTY = "xwiki.plugin.watchlist.automaticwatch";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private ConfigurationSource configurationSource;
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource xwikiCfgConfigurationSource;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    @Override
    public boolean isEnabled() {
        return (Boolean)this.configurationSource.getProperty("notifications.watchedEntities.enabled", (Object)true);
    }

    @Override
    public AutomaticWatchMode getAutomaticWatchMode(DocumentReference user) {
        Object value = this.documentAccessBridge.getProperty(user, this.getAbsoluteClassReference(user), AUTOMATIC_WATCH_MODE);
        if (value != null && StringUtils.isNotBlank((CharSequence)((String)value))) {
            return AutomaticWatchMode.valueOf((String)value);
        }
        return this.getDefaultAutomaticWatchMode(user.getWikiReference());
    }

    @Override
    public AutomaticWatchMode getDefaultAutomaticWatchMode(WikiReference wikiReference) {
        Object value = this.documentAccessBridge.getProperty(this.getAbsoluteConfigurationReference(wikiReference), this.getAbsoluteClassReference(wikiReference), AUTOMATIC_WATCH_MODE);
        if (value != null && StringUtils.isNotBlank((CharSequence)((String)value))) {
            return AutomaticWatchMode.valueOf((String)value);
        }
        WikiReference mainWiki = new WikiReference(this.wikiDescriptorManager.getMainWikiId());
        if (!wikiReference.equals((Object)mainWiki) && (value = this.documentAccessBridge.getProperty(this.getAbsoluteConfigurationReference(mainWiki), this.getAbsoluteClassReference(mainWiki), AUTOMATIC_WATCH_MODE)) != null && StringUtils.isNotBlank((CharSequence)((String)value))) {
            return AutomaticWatchMode.valueOf((String)value);
        }
        return this.getAutomaticWatchMode();
    }

    private AutomaticWatchMode getAutomaticWatchMode() {
        Object value = this.configurationSource.getProperty("notifications.watchedEntities.autoWatch");
        if (value != null) {
            return AutomaticWatchMode.valueOf(((String)value).toUpperCase());
        }
        value = this.configurationSource.getProperty(WATCHLIST_AUTOWATCH_PROPERTY);
        if (value != null) {
            return AutomaticWatchMode.valueOf(((String)value).toUpperCase());
        }
        value = this.xwikiCfgConfigurationSource.getProperty(WATCHLIST_AUTOWATCH_PROPERTY);
        if (value != null) {
            return AutomaticWatchMode.valueOf(((String)value).toUpperCase());
        }
        return AutomaticWatchMode.MAJOR;
    }

    private DocumentReference getAbsoluteClassReference(DocumentReference user) {
        return new DocumentReference(CLASS_REFERENCE, user.getWikiReference());
    }

    private DocumentReference getAbsoluteClassReference(WikiReference wikiReference) {
        return new DocumentReference(CLASS_REFERENCE, wikiReference);
    }

    private DocumentReference getAbsoluteConfigurationReference(WikiReference wikiReference) {
        return new DocumentReference(CONFIGURATION_REFERENCE, wikiReference);
    }
}

