/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.watch.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.watch.WatchedEntitiesConfiguration;
import org.xwiki.notifications.filters.watch.WatchedEntitiesManager;
import org.xwiki.notifications.filters.watch.WatchedEntityFactory;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationContext;
import org.xwiki.observation.event.BeginEvent;
import org.xwiki.observation.event.BeginFoldEvent;
import org.xwiki.observation.event.Event;

@Component
@Named(value="AutomaticNotificationsWatchModeListener")
@Singleton
public class AutomaticWatchModeListener
extends AbstractEventListener {
    public static final String LISTENER_NAME = "AutomaticNotificationsWatchModeListener";
    private static final BeginEvent SKIPPED_EVENTS = event -> event instanceof BeginFoldEvent;
    private static final List<Event> LISTENER_EVENTS = Arrays.asList(new DocumentCreatedEvent(), new DocumentUpdatedEvent());
    @Inject
    private ObservationContext observationContext;
    @Inject
    private WatchedEntitiesManager watchedEntitiesManager;
    @Inject
    private WatchedEntityFactory factory;
    @Inject
    private WatchedEntitiesConfiguration configuration;
    @Inject
    private Logger logger;

    public AutomaticWatchModeListener() {
        super(LISTENER_NAME, LISTENER_EVENTS);
    }

    public void onEvent(Event event, Object source, Object data) {
        if (this.configuration.isEnabled() && !this.observationContext.isIn(SKIPPED_EVENTS)) {
            this.documentModifiedHandler(event, (XWikiDocument)source, (XWikiContext)data);
        }
    }

    private void documentModifiedHandler(Event event, XWikiDocument currentDoc, XWikiContext context) {
        DocumentReference userReference = currentDoc.getAuthorReference();
        try {
            if (userReference == null || !context.getWiki().exists(userReference, context) || userReference.equals((Object)currentDoc.getDocumentReference())) {
                return;
            }
        }
        catch (XWikiException e) {
            this.logger.error("Failed to check if user with reference [{}] exists", (Object)userReference, (Object)e);
            return;
        }
        boolean register = this.shouldRegister(event, currentDoc, userReference);
        if (register) {
            try {
                this.watchedEntitiesManager.watchEntity(this.factory.createWatchedLocationReference((EntityReference)currentDoc.getDocumentReference()), userReference);
            }
            catch (NotificationException e) {
                this.logger.warn("Failed to watch document [{}] for user [{}]", new Object[]{currentDoc.getDocumentReference(), userReference, e});
            }
        }
    }

    private boolean shouldRegister(Event event, XWikiDocument currentDoc, DocumentReference userReference) {
        switch (this.configuration.getAutomaticWatchMode(userReference)) {
            case NONE: {
                return false;
            }
            case ALL: {
                return true;
            }
            case MAJOR: {
                return !currentDoc.isMinorEdit();
            }
            case NEW: {
                return event instanceof DocumentCreatedEvent;
            }
        }
        return false;
    }
}

