/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.watch;

import java.lang.reflect.Type;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.compress.utils.Sets;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterPreferenceManager;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.user.EventUserFilterPreferencesGetter;
import org.xwiki.notifications.filters.watch.WatchedEntityReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceSerializer;

public class WatchedUserReference
implements WatchedEntityReference {
    private final String userId;
    private final ComponentManager componentManager;
    private final NotificationFilterPreferenceManager notificationFilterPreferenceManager;
    private final EventUserFilterPreferencesGetter preferencesGetter;
    private final UserReferenceSerializer<DocumentReference> userReferenceSerializer;

    public WatchedUserReference(String userId, ComponentManager componentManager) throws ComponentLookupException {
        this.userId = userId;
        this.componentManager = componentManager;
        this.preferencesGetter = (EventUserFilterPreferencesGetter)this.componentManager.getInstance(EventUserFilterPreferencesGetter.class);
        this.notificationFilterPreferenceManager = (NotificationFilterPreferenceManager)this.componentManager.getInstance(NotificationFilterPreferenceManager.class);
        this.userReferenceSerializer = (UserReferenceSerializer)componentManager.getInstance((Type)new DefaultParameterizedType(null, UserReferenceSerializer.class, new Type[]{DocumentReference.class}), "document");
    }

    @Override
    public boolean isWatched(DocumentReference userReference) throws NotificationException {
        return this.preferencesGetter.isUserFollowed(this.userId, this.notificationFilterPreferenceManager.getFilterPreferences(userReference), null);
    }

    @Override
    public WatchedEntityReference.WatchedStatus getWatchedStatus(UserReference userReference) throws NotificationException {
        DocumentReference userDocReference = (DocumentReference)this.userReferenceSerializer.serialize(userReference);
        WatchedEntityReference.WatchedStatus watchedStatus = WatchedEntityReference.WatchedStatus.NOT_SET;
        if (this.isWatched(userDocReference)) {
            watchedStatus = WatchedEntityReference.WatchedStatus.WATCHED_FOR_ALL_EVENTS_AND_FORMATS;
        } else if (this.preferencesGetter.isUserExcluded(this.userId, this.notificationFilterPreferenceManager.getFilterPreferences(userDocReference), null)) {
            watchedStatus = WatchedEntityReference.WatchedStatus.BLOCKED_FOR_ALL_EVENTS_AND_FORMATS;
        }
        return watchedStatus;
    }

    @Override
    public Optional<Pair<EntityReference, WatchedEntityReference.WatchedStatus>> getFirstFilteredAncestor(UserReference userReference) throws NotificationException {
        return Optional.empty();
    }

    @Override
    public boolean matchExactly(NotificationFilterPreference notificationFilterPreference) {
        return "eventUserNotificationFilter".equals(notificationFilterPreference.getFilterName()) && this.userId.equals(notificationFilterPreference.getUser()) && notificationFilterPreference.getNotificationFormats().containsAll(Sets.newHashSet((Object[])NotificationFormat.values())) && notificationFilterPreference.getEventTypes().isEmpty();
    }

    @Override
    public boolean match(NotificationFilterPreference notificationFilterPreference) {
        return "eventUserNotificationFilter".equals(notificationFilterPreference.getFilterName()) && this.userId.equals(notificationFilterPreference.getUser());
    }

    @Override
    public NotificationFilterPreference createInclusiveFilterPreference() {
        DefaultNotificationFilterPreference filterPreference = new DefaultNotificationFilterPreference();
        filterPreference.setEnabled(true);
        filterPreference.setFilterType(NotificationFilterType.INCLUSIVE);
        filterPreference.setFilterName("eventUserNotificationFilter");
        filterPreference.setNotificationFormats((Set)Sets.newHashSet((Object[])NotificationFormat.values()));
        filterPreference.setStartingDate(new Date());
        filterPreference.setUser(this.userId);
        return filterPreference;
    }

    @Override
    public NotificationFilterPreference createExclusiveFilterPreference() {
        DefaultNotificationFilterPreference filterPreference = new DefaultNotificationFilterPreference();
        filterPreference.setEnabled(true);
        filterPreference.setFilterType(NotificationFilterType.EXCLUSIVE);
        filterPreference.setFilterName("eventUserNotificationFilter");
        filterPreference.setNotificationFormats((Set)Sets.newHashSet((Object[])NotificationFormat.values()));
        filterPreference.setStartingDate(new Date());
        filterPreference.setUser(this.userId);
        return filterPreference;
    }
}

