/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.migration;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.XWikiUsersDocumentInitializer;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.index.IndexException;
import org.xwiki.index.TaskConsumer;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;

@Component
@Named(value="watchlist-xobject-removal")
@Singleton
public class WatchListObjectsRemovalTaskConsumer
implements TaskConsumer {
    static final String TASK_NAME = "watchlist-xobject-removal";
    private static final String XWIKI_SPACE = "XWiki";
    private static final List<String> NOTIFICATIONS_CODE_SPACE = Arrays.asList("XWiki", "Notifications", "Code");
    private static final LocalDocumentReference CLASS_REFERENCE = new LocalDocumentReference("XWiki", "WatchListClass");
    private static final LocalDocumentReference AUTOMATIC_WATCH_CLASS_REFERENCE = new LocalDocumentReference(NOTIFICATIONS_CODE_SPACE, "AutomaticWatchModeClass");
    @Inject
    private Provider<XWikiContext> contextProvider;

    public void consume(DocumentReference documentReference, String version) throws IndexException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        EntityReference classReference = CLASS_REFERENCE.appendParent((EntityReference)documentReference.getWikiReference());
        EntityReference autoWatchClassReference = AUTOMATIC_WATCH_CLASS_REFERENCE.appendParent((EntityReference)documentReference.getWikiReference());
        try {
            String automaticwatch;
            XWikiDocument document = context.getWiki().getDocument(documentReference, context);
            document = document.clone();
            BaseObject watchXObject = document.getXObject(classReference);
            if (watchXObject != null && document.getXObject((EntityReference)XWikiUsersDocumentInitializer.XWIKI_USERS_DOCUMENT_REFERENCE) != null && document.getXObject(autoWatchClassReference) == null && !StringUtils.isBlank((CharSequence)(automaticwatch = watchXObject.getStringValue("automaticwatch"))) && !"default".equals(automaticwatch)) {
                BaseObject autowatchXObject = document.newXObject(autoWatchClassReference, context);
                autowatchXObject.setStringValue("automaticWatchMode", automaticwatch);
            }
            if (document.removeXObjects(classReference)) {
                context.getWiki().saveDocument(document, "Migration of watchlist preferences", context);
            }
        }
        catch (XWikiException e) {
            throw new IndexException(String.format("Error when trying to clean up watchlist object preferences in [%s]", documentReference), (Throwable)e);
        }
    }
}

