/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.migration;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.XWikiUsersDocumentInitializer;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.ListProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.index.TaskManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterProperty;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.NotificationFilterPreferenceStore;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.stability.Unstable;

@Component
@Named(value="R160300000XWIKI17243")
@Singleton
@Unstable
public class R160300000XWIKI17243DataMigration
extends AbstractHibernateDataMigration {
    private static final String WATCHLIST_CLASSNAME = "WatchListClass";
    private static final LocalDocumentReference CLASS_REFERENCE = new LocalDocumentReference("XWiki", "WatchListClass");
    private static final String FIELD_WIKIS = "wikis";
    private static final String FIELD_SPACES = "spaces";
    private static final String FIELD_DOCUMENTS = "documents";
    private static final String WATCHLIST_FILTER_PREFERENCES_NAME = "watchlist_%s_%s";
    private static final int BATCH_SIZE = 100;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="unique")
    private QueryFilter uniqueFilter;
    @Inject
    @Named(value="count")
    private QueryFilter countFilter;
    @Inject
    private NotificationFilterPreferenceStore notificationFilterPreferenceStore;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private TaskManager taskManager;
    @Inject
    private Logger logger;

    public String getDescription() {
        return "Migrate old WatchListClass xobjects to proper filters.";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(160300000);
    }

    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        long numberOfEntries;
        String statement = "from doc.object(XWiki.WatchListClass) as watchListDoc";
        try {
            List countResult = this.queryManager.createQuery(statement, "xwql").addFilter(this.countFilter).execute();
            numberOfEntries = (Long)countResult.get(0);
        }
        catch (QueryException e) {
            throw new DataMigrationException("Error while performing query to count users with WatchList objects", (Throwable)e);
        }
        if (numberOfEntries > 0L) {
            List results;
            WikiReference currentWiki = this.getXWikiContext().getWikiReference();
            long loops = numberOfEntries / 100L;
            if (numberOfEntries % 100L > 0L) {
                ++loops;
            }
            this.logger.info("Found a total number of [{}] users with WatchListClass objects. Migration will operate [{}] loops of [{}] entries.", new Object[]{numberOfEntries, loops, 100});
            int loopIndex = 1;
            int offset = 0;
            do {
                try {
                    results = this.queryManager.createQuery(statement, "xwql").addFilter(this.uniqueFilter).setOffset(offset).setLimit(100).execute();
                    this.logger.info("(loop [{}] on [{}]) Migrating [{}] users with WatchListClass objects...", new Object[]{loopIndex, loops, results.size()});
                    for (String result : results) {
                        DocumentReference watchListDoc = this.documentReferenceResolver.resolve((Object)result, new Object[]{currentWiki});
                        this.migrateWatchListDoc(watchListDoc);
                    }
                    offset += 100;
                }
                catch (QueryException e) {
                    throw new DataMigrationException("Error while performing query to find users with WatchList objects", (Throwable)e);
                }
                ++loopIndex;
            } while (results.size() == 100);
        } else {
            this.logger.info("No users have been found with WatchListClass object. Migration skipped.");
        }
    }

    private void migrateWatchListDoc(DocumentReference watchListDocReference) throws DataMigrationException, XWikiException {
        XWikiContext context = this.getXWikiContext();
        WikiReference wikiReference = watchListDocReference.getWikiReference();
        XWikiDocument document = context.getWiki().getDocument(watchListDocReference, context);
        if (document.getXObject((EntityReference)XWikiUsersDocumentInitializer.XWIKI_USERS_DOCUMENT_REFERENCE) != null) {
            EntityReference classReference = CLASS_REFERENCE.appendParent((EntityReference)wikiReference);
            List objects = document.getXObjects(classReference);
            HashSet<NotificationFilterPreference> results = new HashSet<NotificationFilterPreference>();
            for (BaseObject obj : objects) {
                if (obj == null) continue;
                this.getValues(obj, FIELD_WIKIS, NotificationFilterProperty.WIKI, results);
                this.getValues(obj, FIELD_SPACES, NotificationFilterProperty.SPACE, results);
                this.getValues(obj, FIELD_DOCUMENTS, NotificationFilterProperty.PAGE, results);
            }
            try {
                this.notificationFilterPreferenceStore.saveFilterPreferences(watchListDocReference, results);
            }
            catch (NotificationException e) {
                throw new DataMigrationException(String.format("Error while trying to save [%s] filter preferences", results.size()), (Throwable)e);
            }
        } else {
            this.logger.info("[{}] contained a watchlist object but is not a user profile, the object will be removed without migration", (Object)watchListDocReference);
        }
        this.taskManager.addTask(wikiReference.getName(), document.getId(), "watchlist-xobject-removal");
    }

    private void getValues(BaseObject obj, String fieldName, NotificationFilterProperty property, Set<NotificationFilterPreference> results) {
        PropertyInterface objProperty = obj.safeget(fieldName);
        List values = objProperty instanceof ListProperty ? ((ListProperty)objProperty).getList() : (objProperty instanceof LargeStringProperty ? ListClass.getListFromString((String)((LargeStringProperty)objProperty).getValue(), (String)",", (boolean)false) : Collections.emptyList());
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                if (value == null) continue;
                DefaultNotificationFilterPreference pref = this.createNotificationFilterPreference(String.format(WATCHLIST_FILTER_PREFERENCES_NAME, property.name(), DigestUtils.sha256Hex((String)value)));
                switch (property) {
                    case PAGE: {
                        pref.setPageOnly(value);
                        break;
                    }
                    case SPACE: {
                        pref.setPage(value);
                        break;
                    }
                    case WIKI: {
                        pref.setWiki(value);
                        break;
                    }
                }
                results.add(pref);
            }
        }
    }

    private DefaultNotificationFilterPreference createNotificationFilterPreference(String id) {
        DefaultNotificationFilterPreference pref = new DefaultNotificationFilterPreference();
        pref.setId(id);
        pref.setEnabled(true);
        pref.setNotificationFormats(Set.of(NotificationFormat.values()));
        pref.setFilterName("scopeNotificationFilter");
        pref.setFilterType(NotificationFilterType.INCLUSIVE);
        return pref;
    }
}

