/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.migrators;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterProperty;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.FilterPreferencesModelBridge;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Named(value="NotificationFilterPreferencesMigrator")
@Singleton
public class NotificationFilterPreferencesMigrator
extends AbstractEventListener {
    private static final SpaceReference NOTIFICATION_CODE_SPACE = new SpaceReference("Code", new SpaceReference("Notifications", new SpaceReference("XWiki", new WikiReference("xwiki"))));
    private static final DocumentReference NOTIFICATION_FILTER_PREFERENCE_CLASS = new DocumentReference("NotificationFilterPreferenceClass", NOTIFICATION_CODE_SPACE);
    private static final String FIELD_FILTER_NAME = "filterName";
    private static final String FIELD_IS_ENABLED = "isEnabled";
    private static final String FIELD_IS_ACTIVE = "isActive";
    private static final String FIELD_APPLICATIONS = "applications";
    private static final String FIELD_EVENT_TYPES = "eventTypes";
    private static final String FIELD_PAGES = "pages";
    private static final String FIELD_SPACES = "spaces";
    private static final String FIELD_WIKIS = "wikis";
    private static final String FIELD_USERS = "users";
    private static final String FIELD_FILTER_TYPE = "filterType";
    private static final String FIELD_FILTER_FORMATS = "filterFormats";
    private static final String FIELD_STARTING_DATE = "startingDate";
    @Inject
    private FilterPreferencesModelBridge filterPreferencesModelBridge;
    @Inject
    private QueryManager queryManager;
    @Inject
    private DocumentReferenceResolver<String> referenceResolver;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;

    public NotificationFilterPreferencesMigrator() {
        super("NotificationFilterPreferencesMigrator", Collections.singletonList(new ApplicationReadyEvent()));
    }

    private void migrateUser(DocumentReference user) throws NotificationException {
        this.logger.info("Migrating the notification filter preferences of user [{}].", (Object)user);
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWiki xwiki = context.getWiki();
        DocumentReference notificationFilterPreferenceClass = NOTIFICATION_FILTER_PREFERENCE_CLASS.setWikiReference(user.getWikiReference());
        try {
            this.logger.info("Loading the current notification filter preferences of user [{}].", (Object)user);
            XWikiDocument doc = xwiki.getDocument(user, context);
            List<NotificationFilterPreference> preferencesToSave = this.convertXObjectsToPreferences(doc, notificationFilterPreferenceClass);
            Set preferencesInTheNewStore = this.filterPreferencesModelBridge.getFilterPreferences(user);
            if (!this.filterPreferencesModelBridge.getFilterPreferences(user).isEmpty() && preferencesInTheNewStore.size() == preferencesToSave.size()) {
                this.logger.info("It seems the notification filter preferences of user [{}] has already been migrated, but the old ones have not been removed from the user's page yet. Probably a previous migration has been run but stopped in the middle of the process.", (Object)user);
            } else {
                this.logger.info("Saving the migrated notification filter preferences of user [{}] in the new store.", (Object)user);
                this.filterPreferencesModelBridge.saveFilterPreferences(user, preferencesToSave);
            }
            this.logger.info("Removing the old notification filter preferences in the page of the user [{}] (please wait, it could be long).", (Object)user);
            doc.removeXObjects(notificationFilterPreferenceClass);
            xwiki.saveDocument(doc, "Migrate notification filter preferences to the new store.", context);
        }
        catch (Exception e) {
            throw new NotificationException(String.format("Failed to migrate the notification preferences for the user [%s].", user), (Throwable)e);
        }
    }

    private List<NotificationFilterPreference> convertXObjectsToPreferences(XWikiDocument document, DocumentReference notificationFilterPreferenceClass) {
        ArrayList<NotificationFilterPreference> preferencesToConvert = new ArrayList<NotificationFilterPreference>();
        List preferencesObj = document.getXObjects(notificationFilterPreferenceClass);
        if (preferencesObj != null) {
            for (BaseObject obj : preferencesObj) {
                if (obj == null) continue;
                this.handleObject(preferencesToConvert, obj);
            }
        }
        return preferencesToConvert;
    }

    private void handleObject(List<NotificationFilterPreference> preferencesToConvert, BaseObject obj) {
        DefaultNotificationFilterPreference preference = new DefaultNotificationFilterPreference();
        NotificationFilterType filterType = NotificationFilterType.valueOf((String)obj.getStringValue(FIELD_FILTER_TYPE).toUpperCase());
        HashSet<NotificationFormat> filterFormats = new HashSet<NotificationFormat>();
        for (String format : obj.getListValue(FIELD_FILTER_FORMATS)) {
            filterFormats.add(NotificationFormat.valueOf((String)format.toUpperCase()));
        }
        preference.setFilterName(obj.getStringValue(FIELD_FILTER_NAME));
        preference.setEnabled(obj.getIntValue(FIELD_IS_ENABLED, 1) == 1);
        preference.setFilterType(filterType);
        preference.setNotificationFormats(filterFormats);
        preference.setStartingDate(obj.getDateValue(FIELD_STARTING_DATE));
        this.handleProperties(preferencesToConvert, obj, preference);
    }

    private void handleProperties(List<NotificationFilterPreference> preferencesToConvert, BaseObject obj, DefaultNotificationFilterPreference preference) {
        DefaultNotificationFilterPreference pref;
        Map<NotificationFilterProperty, List<String>> filterPreferenceProperties = this.createNotificationFilterPropertiesMap(obj);
        if (!filterPreferenceProperties.get(NotificationFilterProperty.EVENT_TYPE).isEmpty()) {
            preference.setEventTypes(new HashSet<String>((Collection)filterPreferenceProperties.get(NotificationFilterProperty.EVENT_TYPE)));
        }
        for (String page : filterPreferenceProperties.get(NotificationFilterProperty.PAGE)) {
            pref = new DefaultNotificationFilterPreference(preference);
            pref.setPageOnly(page);
            preferencesToConvert.add(pref);
        }
        for (String space : filterPreferenceProperties.get(NotificationFilterProperty.SPACE)) {
            pref = new DefaultNotificationFilterPreference(preference);
            pref.setPage(space);
            preferencesToConvert.add(pref);
        }
        for (String wiki : filterPreferenceProperties.get(NotificationFilterProperty.WIKI)) {
            pref = new DefaultNotificationFilterPreference(preference);
            pref.setWiki(wiki);
            preferencesToConvert.add(pref);
        }
        for (String user : filterPreferenceProperties.get(NotificationFilterProperty.USER)) {
            pref = new DefaultNotificationFilterPreference(preference);
            pref.setUser(user);
            preferencesToConvert.add(pref);
        }
    }

    private Map<NotificationFilterProperty, List<String>> createNotificationFilterPropertiesMap(BaseObject obj) {
        HashMap<NotificationFilterProperty, List<String>> filterPreferenceProperties = new HashMap<NotificationFilterProperty, List<String>>();
        filterPreferenceProperties.put(NotificationFilterProperty.APPLICATION, obj.getListValue(FIELD_APPLICATIONS));
        filterPreferenceProperties.put(NotificationFilterProperty.EVENT_TYPE, obj.getListValue(FIELD_EVENT_TYPES));
        filterPreferenceProperties.put(NotificationFilterProperty.PAGE, obj.getListValue(FIELD_PAGES));
        filterPreferenceProperties.put(NotificationFilterProperty.SPACE, obj.getListValue(FIELD_SPACES));
        filterPreferenceProperties.put(NotificationFilterProperty.WIKI, obj.getListValue(FIELD_WIKIS));
        filterPreferenceProperties.put(NotificationFilterProperty.USER, obj.getListValue(FIELD_USERS));
        return filterPreferenceProperties;
    }

    public void onEvent(Event event, Object source, Object data) {
        try {
            for (String wikiId : this.wikiDescriptorManager.getAllIds()) {
                this.migrateWiki(wikiId);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to migrate notification filter preferences.", (Throwable)e);
        }
    }

    private void migrateWiki(String wikiId) throws XWikiException {
        WikiReference wikiReference = new WikiReference(wikiId);
        DocumentReference notificationFilterPreferenceClass = NOTIFICATION_FILTER_PREFERENCE_CLASS.setWikiReference(wikiReference);
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWiki xwiki = context.getWiki();
        if (!xwiki.exists(notificationFilterPreferenceClass, context)) {
            this.logger.debug("Wiki [{}] has already been migrated.", (Object)wikiId);
            return;
        }
        try {
            this.logger.info("Getting the list of the users having notification filter preferences to migrate on wiki [{}].", (Object)wikiId);
            Query query = this.queryManager.createQuery("select distinct doc.fullName from Document doc, doc.object(XWiki.Notifications.Code.NotificationFilterPreferenceClass) obj", "xwql").setWiki(wikiId);
            for (String fullName : query.execute()) {
                this.migrateUser(this.referenceResolver.resolve((Object)fullName, new Object[]{wikiReference}));
            }
            XWikiDocument oldClassDoc = xwiki.getDocument(notificationFilterPreferenceClass, context);
            if (!oldClassDoc.isNew()) {
                this.logger.info("Removing the old notification filter preference class on wiki [{}].", (Object)wikiId);
                xwiki.deleteDocument(oldClassDoc, false, context);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to migrate notification filter preferences on wiki [{}].", (Object)wikiReference.getName(), (Object)e);
        }
    }
}

