/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.livedata.custom;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.internal.livedata.custom.NotificationCustomFiltersLiveDataConfigurationProvider;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.query.internal.DefaultQueryParameter;

@Component(roles={NotificationCustomFiltersQueryHelper.class})
@Singleton
public class NotificationCustomFiltersQueryHelper {
    private static final String BASE_QUERY = "select nfp from DefaultNotificationFilterPreference nfp where owner = :owner";
    private static final String OWNER_BINDING = "owner";
    private static final String STARTS_WITH_OPERATOR = "startsWith";
    private static final String CONTAINS_OPERATOR = "contains";
    private static final String EQUALS_OPERATOR = "equals";
    private static final String AND = " and ";
    @Inject
    private QueryManager queryManager;

    private Optional<FiltersHQLQuery> handleFilter(List<LiveDataQuery.Filter> queryFilters) {
        FiltersHQLQuery result = new FiltersHQLQuery();
        ArrayList<String> queryWhereClauses = new ArrayList<String>();
        for (LiveDataQuery.Filter queryFilter : queryFilters) {
            switch (queryFilter.getProperty()) {
                case "isEnabled": {
                    this.handleIsEnabledFilter(queryFilter, queryWhereClauses);
                    break;
                }
                case "notificationFormats": {
                    this.handleNotificationFormatsFilter(queryFilter, queryWhereClauses);
                    break;
                }
                case "scope": {
                    this.handleScopeFilter(queryFilter, queryWhereClauses);
                    break;
                }
                case "filterType": {
                    this.handleFilterTypeFilter(queryFilter, queryWhereClauses, result);
                    break;
                }
                case "location": {
                    this.handleLocationFilter(queryFilter, queryWhereClauses, result);
                    break;
                }
                case "eventTypes": {
                    this.handleEventTypeFilter(queryFilter, queryWhereClauses, result);
                    break;
                }
            }
        }
        if (!queryWhereClauses.isEmpty()) {
            result.whereClause = queryWhereClauses.stream().collect(Collectors.joining(AND, AND, ""));
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private void handleFilterTypeFilter(LiveDataQuery.Filter queryFilter, List<String> queryWhereClauses, FiltersHQLQuery result) {
        LiveDataQuery.Constraint constraint = (LiveDataQuery.Constraint)queryFilter.getConstraints().get(0);
        if (EQUALS_OPERATOR.equals(constraint.getOperator())) {
            queryWhereClauses.add("nfp.filterType = :filterType");
            result.bindings.put("filterType", NotificationFilterType.valueOf((String)String.valueOf(constraint.getValue())));
        }
    }

    private void handleScopeFilter(LiveDataQuery.Filter queryFilter, List<String> queryWhereClauses) {
        LiveDataQuery.Constraint constraint = (LiveDataQuery.Constraint)queryFilter.getConstraints().get(0);
        if (EQUALS_OPERATOR.equals(constraint.getOperator()) && !StringUtils.isBlank((CharSequence)String.valueOf(constraint.getValue()))) {
            NotificationCustomFiltersLiveDataConfigurationProvider.Scope scope = NotificationCustomFiltersLiveDataConfigurationProvider.Scope.valueOf(String.valueOf(constraint.getValue()));
            queryWhereClauses.add(String.format("length(nfp.%s) > 0", scope.getFieldName()));
        }
    }

    private void handleNotificationFormatsFilter(LiveDataQuery.Filter queryFilter, List<String> queryWhereClauses) {
        LiveDataQuery.Constraint constraint = (LiveDataQuery.Constraint)queryFilter.getConstraints().get(0);
        String constraintValue = String.valueOf(constraint.getValue());
        if (EQUALS_OPERATOR.equals(constraint.getOperator()) && !StringUtils.isEmpty((CharSequence)constraintValue)) {
            if (NotificationFormat.ALERT.name().equals(constraintValue)) {
                queryWhereClauses.add("nfp.alertEnabled = true");
            }
            if (NotificationFormat.EMAIL.name().equals(constraintValue)) {
                queryWhereClauses.add("nfp.emailEnabled = true");
            }
        }
    }

    private void handleIsEnabledFilter(LiveDataQuery.Filter queryFilter, List<String> queryWhereClauses) {
        LiveDataQuery.Constraint constraint = (LiveDataQuery.Constraint)queryFilter.getConstraints().get(0);
        if (Boolean.parseBoolean(String.valueOf(constraint.getValue()))) {
            queryWhereClauses.add("nfp.enabled = true");
        } else {
            queryWhereClauses.add("nfp.enabled = false");
        }
    }

    private void handleEventTypeFilter(LiveDataQuery.Filter queryFilter, List<String> queryWhereClauses, FiltersHQLQuery result) {
        LiveDataQuery.Constraint constraint = (LiveDataQuery.Constraint)queryFilter.getConstraints().get(0);
        if (EQUALS_OPERATOR.equals(constraint.getOperator())) {
            if ("__ALL_EVENTS__".equals(constraint.getValue())) {
                queryWhereClauses.add("length(nfp.allEventTypes) = 0");
            } else {
                queryWhereClauses.add("nfp.allEventTypes like :eventTypes");
                DefaultQueryParameter queryParameter = new DefaultQueryParameter(null);
                queryParameter.anyChars().literal(String.valueOf(constraint.getValue())).anyChars();
                result.bindings.put("eventTypes", queryParameter);
            }
        }
    }

    private void handleLocationFilter(LiveDataQuery.Filter locationFilter, List<String> queryWhereClauses, FiltersHQLQuery result) {
        ArrayList<String> clauses = new ArrayList<String>();
        int clauseCounter = 0;
        String clauseValue = "(nfp.pageOnly like :constraint_%1$s or nfp.page like :constraint_%1$s or nfp.wiki like :constraint_%1$s or nfp.user like :constraint_%1$s)";
        String constraintName = "constraint_%s";
        for (LiveDataQuery.Constraint constraint : locationFilter.getConstraints()) {
            if (EQUALS_OPERATOR.equals(constraint.getOperator())) {
                clauses.add(String.format("(nfp.pageOnly = :constraint_%1$s or nfp.page = :constraint_%1$s or nfp.wiki = :constraint_%1$s or nfp.user = :constraint_%1$s)", clauseCounter));
                queryParameter = new DefaultQueryParameter(null);
                queryParameter.literal(String.valueOf(constraint.getValue()));
                result.bindings.put(String.format(constraintName, clauseCounter), queryParameter);
            } else if (STARTS_WITH_OPERATOR.equals(constraint.getOperator())) {
                clauses.add(String.format(clauseValue, clauseCounter));
                queryParameter = new DefaultQueryParameter(null);
                queryParameter.literal(String.valueOf(constraint.getValue())).anyChars();
                result.bindings.put(String.format(constraintName, clauseCounter), queryParameter);
            } else if (CONTAINS_OPERATOR.equals(constraint.getOperator())) {
                clauses.add(String.format(clauseValue, clauseCounter));
                queryParameter = new DefaultQueryParameter(null);
                queryParameter.anyChars().literal(String.valueOf(constraint.getValue())).anyChars();
                result.bindings.put(String.format(constraintName, clauseCounter), queryParameter);
            }
            ++clauseCounter;
        }
        if (!clauses.isEmpty()) {
            queryWhereClauses.add(this.buildQueryClause(locationFilter, clauses));
        }
    }

    private String buildQueryClause(LiveDataQuery.Filter filter, List<String> clauses) {
        String operatorAppender = filter.isMatchAll() ? AND : " or ";
        return clauses.stream().collect(Collectors.joining(operatorAppender, "(", ")"));
    }

    private Query getHQLQuery(LiveDataQuery query, boolean isCount, String owner, WikiReference wikiReference) throws QueryException, LiveDataException {
        Object baseQuery = isCount ? "select count(nfp.id) from DefaultNotificationFilterPreference nfp where owner = :owner" : BASE_QUERY;
        Optional<FiltersHQLQuery> optionalFiltersHQLQuery = this.handleFilter(query.getFilters());
        if (optionalFiltersHQLQuery.isPresent()) {
            baseQuery = (String)baseQuery + optionalFiltersHQLQuery.get().whereClause;
        }
        if (!isCount) {
            baseQuery = (String)baseQuery + this.handleSortEntries(query.getSort());
        }
        Query hqlQuery = this.queryManager.createQuery((String)baseQuery, "hql").bindValue(OWNER_BINDING, (Object)owner).setWiki(wikiReference.getName());
        if (optionalFiltersHQLQuery.isPresent()) {
            for (Map.Entry<String, Object> binding : optionalFiltersHQLQuery.get().bindings.entrySet()) {
                hqlQuery = hqlQuery.bindValue(binding.getKey(), binding.getValue());
            }
        }
        return hqlQuery;
    }

    public long countTotalFilters(LiveDataQuery query, String owner, WikiReference wikiReference) throws QueryException, LiveDataException {
        return (Long)this.getHQLQuery(query, true, owner, wikiReference).execute().get(0);
    }

    private String handleSortEntries(List<LiveDataQuery.SortEntry> sortEntries) throws LiveDataException {
        ArrayList<String> clauses = new ArrayList<String>();
        for (LiveDataQuery.SortEntry sortEntry : sortEntries) {
            String sortOperator = sortEntry.isDescending() ? "desc" : "asc";
            String clause = switch (sortEntry.getProperty()) {
                case "isEnabled" -> String.format("nfp.enabled %s", sortOperator);
                case "notificationFormats" -> this.handleNotificationFormatSort(sortEntry);
                case "location", "scope" -> this.handleLocationSort(sortEntry);
                case "filterType" -> String.format("nfp.filterType %s", sortOperator);
                case "eventTypes" -> String.format("nfp.allEventTypes %s", sortOperator);
                case "filterPreferenceId" -> String.format("nfp.internalId %s", sortOperator);
                default -> throw new LiveDataException("Unexpected sort value: " + sortEntry.getProperty());
            };
            clauses.add(clause);
        }
        if (!clauses.isEmpty()) {
            return clauses.stream().collect(Collectors.joining(", ", " order by ", ""));
        }
        return "";
    }

    private String handleLocationSort(LiveDataQuery.SortEntry sortEntry) {
        if (sortEntry.isDescending()) {
            return "nfp.user desc, nfp.wiki desc, nfp.page desc, nfp.pageOnly desc";
        }
        return "nfp.pageOnly asc, nfp.page asc, nfp.wiki asc, nfp.user asc";
    }

    private String handleNotificationFormatSort(LiveDataQuery.SortEntry sortEntry) {
        if (sortEntry.isDescending()) {
            return "nfp.emailEnabled asc, nfp.alertEnabled desc";
        }
        return "nfp.alertEnabled asc, nfp.emailEnabled desc";
    }

    public List<NotificationFilterPreference> getFilterPreferences(LiveDataQuery query, String owner, WikiReference wikiReference) throws QueryException, LiveDataException {
        return this.getHQLQuery(query, false, owner, wikiReference).setLimit(query.getLimit().intValue()).setOffset(query.getOffset().intValue()).execute();
    }

    private static final class FiltersHQLQuery {
        private String whereClause;
        private final Map<String, Object> bindings = new LinkedHashMap<String, Object>();

        private FiltersHQLQuery() {
        }
    }
}

