/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.livedata.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveDataActionDescriptor;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataEntryDescriptor;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataMeta;
import org.xwiki.livedata.LiveDataPaginationConfiguration;
import org.xwiki.livedata.LiveDataPropertyDescriptor;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.internal.livedata.NotificationFilterLiveDataTranslationHelper;

@Component
@Singleton
@Named(value="notificationCustomFilters")
public class NotificationCustomFiltersLiveDataConfigurationProvider
implements Provider<LiveDataConfiguration> {
    static final String ALL_EVENTS_OPTION_VALUE = "__ALL_EVENTS__";
    static final String ID_FIELD = "filterPreferenceId";
    static final String SCOPE_FIELD = "scope";
    static final String LOCATION_FIELD = "location";
    static final String DISPLAY_FIELD = "display";
    static final String FILTER_TYPE_FIELD = "filterType";
    static final String EVENT_TYPES_FIELD = "eventTypes";
    static final String NOTIFICATION_FORMATS_FIELD = "notificationFormats";
    static final String IS_ENABLED_FIELD = "isEnabled";
    static final String ACTIONS_FIELD = "actions";
    static final String DOC_HAS_DELETE_FIELD = "doc_hasdelete";
    private static final String TRANSLATION_PREFIX = "notifications.settings.filters.preferences.custom.table.";
    private static final String DELETE = "delete";
    private static final String STRING_TYPE = "String";
    private static final String HTML_DISPLAYER = "html";
    private static final String BOOLEAN = "boolean";
    private static final String STATIC_LIST_DISPLAYER = "staticList";
    private static final String VALUE_KEY = "value";
    private static final String LABEL_KEY = "label";
    @Inject
    private ContextualLocalizationManager l10n;
    @Inject
    private NotificationFilterLiveDataTranslationHelper translationHelper;
    @Inject
    private Logger logger;

    public LiveDataConfiguration get() {
        LiveDataConfiguration input = new LiveDataConfiguration();
        LiveDataMeta meta = new LiveDataMeta();
        input.setMeta(meta);
        LiveDataPaginationConfiguration pagination = new LiveDataPaginationConfiguration();
        pagination.setShowPageSizeDropdown(Boolean.valueOf(true));
        meta.setPagination(pagination);
        LiveDataEntryDescriptor entryDescriptor = new LiveDataEntryDescriptor();
        entryDescriptor.setIdProperty(ID_FIELD);
        meta.setEntryDescriptor(entryDescriptor);
        LiveDataActionDescriptor deleteAction = new LiveDataActionDescriptor();
        deleteAction.setId(DELETE);
        deleteAction.setAllowProperty(DOC_HAS_DELETE_FIELD);
        meta.setActions(List.of(deleteAction));
        meta.setPropertyDescriptors(List.of(this.getIDDescriptor(), this.getDisplayDescriptor(), this.getScopeDescriptor(), this.getLocationDescriptor(), this.getFilterTypeDescriptor(), this.getNotificationFormatsDescriptor(), this.getEventTypesDescriptor(), this.getIsEnabledDescriptor(), this.getActionDescriptor()));
        return input;
    }

    private LiveDataPropertyDescriptor getIDDescriptor() {
        LiveDataPropertyDescriptor descriptor = new LiveDataPropertyDescriptor();
        descriptor.setName(this.l10n.getTranslationPlain("notifications.settings.filters.preferences.custom.table.filterPreferenceId", new Object[0]));
        descriptor.setId(ID_FIELD);
        descriptor.setType(STRING_TYPE);
        descriptor.setVisible(Boolean.valueOf(false));
        descriptor.setEditable(Boolean.valueOf(false));
        descriptor.setSortable(Boolean.valueOf(true));
        descriptor.setFilterable(Boolean.valueOf(false));
        return descriptor;
    }

    private LiveDataPropertyDescriptor getDisplayDescriptor() {
        LiveDataPropertyDescriptor descriptor = new LiveDataPropertyDescriptor();
        descriptor.setName(this.l10n.getTranslationPlain("notifications.settings.filters.preferences.custom.table.name", new Object[0]));
        descriptor.setId(DISPLAY_FIELD);
        descriptor.setType(STRING_TYPE);
        descriptor.setDisplayer(new LiveDataPropertyDescriptor.DisplayerDescriptor(HTML_DISPLAYER));
        descriptor.setVisible(Boolean.valueOf(false));
        descriptor.setEditable(Boolean.valueOf(false));
        descriptor.setSortable(Boolean.valueOf(false));
        descriptor.setFilterable(Boolean.valueOf(false));
        return descriptor;
    }

    private LiveDataPropertyDescriptor.FilterDescriptor createFilterList(List<Map<String, String>> options) {
        LiveDataPropertyDescriptor.FilterDescriptor filterList = new LiveDataPropertyDescriptor.FilterDescriptor("list");
        filterList.setParameter("options", options);
        String equalsOperator = "equals";
        filterList.addOperator(equalsOperator, null);
        filterList.setDefaultOperator(equalsOperator);
        return filterList;
    }

    private LiveDataPropertyDescriptor getScopeDescriptor() {
        LiveDataPropertyDescriptor descriptor = new LiveDataPropertyDescriptor();
        descriptor.setName(this.l10n.getTranslationPlain("notifications.settings.filters.preferences.custom.table.scope", new Object[0]));
        descriptor.setId(SCOPE_FIELD);
        descriptor.setType(STRING_TYPE);
        descriptor.setDisplayer(new LiveDataPropertyDescriptor.DisplayerDescriptor(SCOPE_FIELD));
        descriptor.setFilter(this.createFilterList(Stream.of(Scope.values()).map(item -> Map.of(VALUE_KEY, item.name(), LABEL_KEY, this.translationHelper.getScopeTranslation((Scope)((Object)item)))).toList()));
        descriptor.setVisible(Boolean.valueOf(true));
        descriptor.setEditable(Boolean.valueOf(false));
        descriptor.setSortable(Boolean.valueOf(true));
        descriptor.setFilterable(Boolean.valueOf(true));
        return descriptor;
    }

    private LiveDataPropertyDescriptor getLocationDescriptor() {
        LiveDataPropertyDescriptor descriptor = new LiveDataPropertyDescriptor();
        descriptor.setName(this.l10n.getTranslationPlain("notifications.settings.filters.preferences.custom.table.location", new Object[0]));
        descriptor.setId(LOCATION_FIELD);
        descriptor.setType(STRING_TYPE);
        descriptor.setDisplayer(new LiveDataPropertyDescriptor.DisplayerDescriptor(HTML_DISPLAYER));
        descriptor.setVisible(Boolean.valueOf(true));
        descriptor.setEditable(Boolean.valueOf(false));
        descriptor.setSortable(Boolean.valueOf(true));
        descriptor.setFilterable(Boolean.valueOf(true));
        return descriptor;
    }

    private LiveDataPropertyDescriptor getFilterTypeDescriptor() {
        LiveDataPropertyDescriptor descriptor = new LiveDataPropertyDescriptor();
        descriptor.setName(this.l10n.getTranslationPlain("notifications.settings.filters.preferences.custom.table.filterType", new Object[0]));
        descriptor.setId(FILTER_TYPE_FIELD);
        descriptor.setType(STRING_TYPE);
        descriptor.setFilter(this.createFilterList(Stream.of(NotificationFilterType.values()).map(item -> Map.of(VALUE_KEY, item.name(), LABEL_KEY, this.translationHelper.getFilterTypeTranslation((NotificationFilterType)item))).toList()));
        descriptor.setVisible(Boolean.valueOf(true));
        descriptor.setEditable(Boolean.valueOf(false));
        descriptor.setSortable(Boolean.valueOf(true));
        descriptor.setFilterable(Boolean.valueOf(true));
        return descriptor;
    }

    private LiveDataPropertyDescriptor getNotificationFormatsDescriptor() {
        LiveDataPropertyDescriptor descriptor = new LiveDataPropertyDescriptor();
        descriptor.setName(this.l10n.getTranslationPlain("notifications.settings.filters.preferences.custom.table.notificationFormats", new Object[0]));
        descriptor.setId(NOTIFICATION_FORMATS_FIELD);
        descriptor.setType(STRING_TYPE);
        descriptor.setFilter(this.createFilterList(Stream.of(NotificationFormat.values()).map(item -> Map.of(VALUE_KEY, item.name(), LABEL_KEY, this.translationHelper.getFormatTranslation((NotificationFormat)item))).toList()));
        descriptor.setDisplayer(new LiveDataPropertyDescriptor.DisplayerDescriptor(STATIC_LIST_DISPLAYER));
        descriptor.setVisible(Boolean.valueOf(true));
        descriptor.setEditable(Boolean.valueOf(false));
        descriptor.setSortable(Boolean.valueOf(true));
        descriptor.setFilterable(Boolean.valueOf(true));
        return descriptor;
    }

    private LiveDataPropertyDescriptor getEventTypesDescriptor() {
        LiveDataPropertyDescriptor descriptor = new LiveDataPropertyDescriptor();
        descriptor.setName(this.l10n.getTranslationPlain("notifications.settings.filters.preferences.custom.table.eventTypes", new Object[0]));
        descriptor.setId(EVENT_TYPES_FIELD);
        descriptor.setType(STRING_TYPE);
        descriptor.setDisplayer(new LiveDataPropertyDescriptor.DisplayerDescriptor(STATIC_LIST_DISPLAYER));
        ArrayList<Map<String, String>> options = new ArrayList<Map<String, String>>();
        options.add(Map.of(VALUE_KEY, ALL_EVENTS_OPTION_VALUE, LABEL_KEY, this.translationHelper.getAllEventTypesTranslation()));
        try {
            options.addAll(this.translationHelper.getAllEventTypesOptions());
        }
        catch (LiveDataException e) {
            this.logger.error("Cannot provide event filter options", (Throwable)e);
        }
        descriptor.setFilter(this.createFilterList(options));
        descriptor.setVisible(Boolean.valueOf(true));
        descriptor.setEditable(Boolean.valueOf(false));
        descriptor.setSortable(Boolean.valueOf(true));
        descriptor.setFilterable(Boolean.valueOf(true));
        return descriptor;
    }

    private LiveDataPropertyDescriptor getIsEnabledDescriptor() {
        LiveDataPropertyDescriptor descriptor = new LiveDataPropertyDescriptor();
        descriptor.setName(this.l10n.getTranslationPlain("notifications.settings.filters.preferences.custom.table.isEnabled", new Object[0]));
        descriptor.setId(IS_ENABLED_FIELD);
        descriptor.setType(BOOLEAN);
        descriptor.setFilter(new LiveDataPropertyDescriptor.FilterDescriptor(BOOLEAN));
        descriptor.setDisplayer(new LiveDataPropertyDescriptor.DisplayerDescriptor("toggle"));
        descriptor.setVisible(Boolean.valueOf(true));
        descriptor.setEditable(Boolean.valueOf(false));
        descriptor.setSortable(Boolean.valueOf(true));
        descriptor.setFilterable(Boolean.valueOf(true));
        return descriptor;
    }

    private LiveDataPropertyDescriptor getActionDescriptor() {
        LiveDataPropertyDescriptor actionDescriptor = new LiveDataPropertyDescriptor();
        actionDescriptor.setName(this.l10n.getTranslationPlain("notifications.settings.filters.preferences.custom.table._actions", new Object[0]));
        actionDescriptor.setId(ACTIONS_FIELD);
        LiveDataPropertyDescriptor.DisplayerDescriptor displayer = new LiveDataPropertyDescriptor.DisplayerDescriptor(ACTIONS_FIELD);
        displayer.setParameter(ACTIONS_FIELD, List.of(DELETE));
        actionDescriptor.setDisplayer(displayer);
        actionDescriptor.setVisible(Boolean.valueOf(true));
        actionDescriptor.setEditable(Boolean.valueOf(false));
        actionDescriptor.setSortable(Boolean.valueOf(false));
        actionDescriptor.setFilterable(Boolean.valueOf(false));
        return actionDescriptor;
    }

    public static enum Scope {
        WIKI("wiki"),
        SPACE("page"),
        PAGE("pageOnly"),
        USER("user");

        private final String fieldName;

        private Scope(String fieldName) {
            this.fieldName = fieldName;
        }

        String getFieldName() {
            return this.fieldName;
        }
    }
}

