/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.XWikiUsersDocumentInitializer;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentCreatingEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterPreferenceManager;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="org.xwiki.notifications.filters.internal.UserAddedEventListener")
public class UserAddedEventListener
extends AbstractEventListener {
    public static final String NAME = "org.xwiki.notifications.filters.internal.UserAddedEventListener";
    private static final List<String> NOTIFICATION_CODE_SPACE = Arrays.asList("XWiki", "Notifications", "Code");
    protected static final LocalDocumentReference NOTIFICATION_CONFIGURATION = new LocalDocumentReference(NOTIFICATION_CODE_SPACE, "NotificationAdministration");
    protected static final LocalDocumentReference TOGGLEABLE_FILTER_PREFERENCE_CLASS = new LocalDocumentReference(NOTIFICATION_CODE_SPACE, "ToggleableFilterPreferenceClass");
    @Inject
    private NotificationFilterPreferenceManager notificationFilterPreferenceManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;

    public UserAddedEventListener() {
        super(NAME, new Event[]{new DocumentCreatingEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument userDoc = (XWikiDocument)source;
        if (userDoc.getXObject((EntityReference)XWikiUsersDocumentInitializer.XWIKI_USERS_DOCUMENT_REFERENCE) != null) {
            DocumentReference userDocReference = userDoc.getDocumentReference();
            try {
                this.copyFilterPreferences(userDocReference);
                this.copyToggleableFilterPreferences(userDoc);
            }
            catch (Exception e) {
                this.logger.error("Error while trying to copy filter preferences to new user", (Throwable)e);
            }
        }
    }

    private void copyFilterPreferences(DocumentReference userDocReference) throws NotificationException {
        Collection filterPreferences = this.notificationFilterPreferenceManager.getFilterPreferences(userDocReference.getWikiReference());
        HashSet<DefaultNotificationFilterPreference> userFilterPreferences = new HashSet<DefaultNotificationFilterPreference>();
        for (NotificationFilterPreference filterPreference : filterPreferences) {
            DefaultNotificationFilterPreference preference = new DefaultNotificationFilterPreference(filterPreference, false);
            userFilterPreferences.add(preference);
        }
        this.notificationFilterPreferenceManager.saveFilterPreferences(userDocReference, userFilterPreferences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToggleableFilterPreferences(XWikiDocument userDocument) throws Exception {
        XWikiContext xWikiContext = (XWikiContext)this.contextProvider.get();
        WikiReference currentWikiReference = xWikiContext.getWikiReference();
        try {
            xWikiContext.setWikiReference(userDocument.getDocumentReference().getWikiReference());
            if (userDocument.getXObjects((EntityReference)TOGGLEABLE_FILTER_PREFERENCE_CLASS).isEmpty()) {
                XWikiDocument notificationConfiguration = xWikiContext.getWiki().getDocument((EntityReference)NOTIFICATION_CONFIGURATION, xWikiContext);
                List xObjects = notificationConfiguration.getXObjects((EntityReference)TOGGLEABLE_FILTER_PREFERENCE_CLASS);
                for (BaseObject xObject : xObjects) {
                    if (xObject == null) continue;
                    userDocument.addXObject(xObject.duplicate());
                }
            }
        }
        finally {
            xWikiContext.setWikiReference(currentWikiReference);
        }
    }
}

