/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.FilterPreferencesModelBridge;
import org.xwiki.notifications.filters.internal.NotificationFilterPreferenceStore;
import org.xwiki.notifications.filters.internal.ToggleableFilterPreferenceDocumentInitializer;
import org.xwiki.notifications.filters.internal.ToggleableNotificationFilter;
import org.xwiki.notifications.filters.internal.ToggleableNotificationFilterActivation;

@Component
@Singleton
public class DefaultFilterPreferencesModelBridge
implements FilterPreferencesModelBridge {
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private NotificationFilterPreferenceStore notificationFilterPreferenceStore;

    private List<DefaultNotificationFilterPreference> getInternalFilterPreferences(DocumentReference user) throws NotificationException {
        return this.notificationFilterPreferenceStore.getPreferencesOfUser(user);
    }

    public Set<NotificationFilterPreference> getFilterPreferences(DocumentReference user) throws NotificationException {
        return new HashSet<NotificationFilterPreference>(this.getInternalFilterPreferences(user));
    }

    public Set<NotificationFilterPreference> getFilterPreferences(WikiReference wikiReference) throws NotificationException {
        return new HashSet<NotificationFilterPreference>(this.notificationFilterPreferenceStore.getPreferencesOfWiki(wikiReference));
    }

    public Map<String, ToggleableNotificationFilterActivation> getToggleableFilterActivations(DocumentReference user) throws NotificationException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        WikiReference currentWiki = context.getWikiReference();
        context.setWikiReference(user.getWikiReference());
        XWiki xwiki = context.getWiki();
        HashMap<String, ToggleableNotificationFilterActivation> filterStatus = new HashMap<String, ToggleableNotificationFilterActivation>();
        try {
            XWikiDocument doc = xwiki.getDocument(user, context);
            for (NotificationFilter filter : this.componentManager.getInstanceList(NotificationFilter.class)) {
                if (!(filter instanceof ToggleableNotificationFilter)) continue;
                ToggleableNotificationFilter toggleableFilter = (ToggleableNotificationFilter)filter;
                boolean status = toggleableFilter.isEnabledByDefault();
                BaseObject obj = doc.getXObject((EntityReference)ToggleableFilterPreferenceDocumentInitializer.XCLASS, "filterName", filter.getName(), false);
                int objNumber = -1;
                if (obj != null) {
                    status = obj.getIntValue("isEnabled", status ? 1 : 0) != 0;
                    objNumber = obj.getNumber();
                }
                ToggleableNotificationFilterActivation filterActivation = new ToggleableNotificationFilterActivation(filter.getName(), status, user, objNumber);
                filterStatus.put(filter.getName(), filterActivation);
            }
        }
        catch (Exception e) {
            throw new NotificationException(String.format("Failed to get the toggleable filters preferences for the user [%s].", user), (Throwable)e);
        }
        finally {
            context.setWikiReference(currentWiki);
        }
        return filterStatus;
    }

    public void deleteFilterPreference(DocumentReference user, String filterPreferenceId) throws NotificationException {
        this.notificationFilterPreferenceStore.deleteFilterPreference(user, filterPreferenceId);
    }

    public void deleteFilterPreferences(DocumentReference user, Set<String> filterPreferenceIds) throws NotificationException {
        this.notificationFilterPreferenceStore.deleteFilterPreferences(user, filterPreferenceIds);
    }

    public void deleteFilterPreferences(DocumentReference user) throws NotificationException {
        this.notificationFilterPreferenceStore.deleteFilterPreferences(user);
    }

    public void deleteFilterPreference(WikiReference wikiReference, String filterPreferenceId) throws NotificationException {
        this.notificationFilterPreferenceStore.deleteFilterPreference(wikiReference, filterPreferenceId);
    }

    public void deleteFilterPreferences(WikiReference wikiReference) throws NotificationException {
        this.notificationFilterPreferenceStore.deleteFilterPreference(wikiReference);
    }

    public void setFilterPreferenceEnabled(DocumentReference user, String filterPreferenceId, boolean enabled) throws NotificationException {
        NotificationFilterPreference preference = this.notificationFilterPreferenceStore.getFilterPreference(user, filterPreferenceId);
        if (preference != null && enabled != preference.isEnabled()) {
            preference.setEnabled(enabled);
            this.saveFilterPreferences(user, Collections.singletonList(preference));
        }
    }

    public void setFilterPreferenceEnabled(WikiReference wikiReference, String filterPreferenceId, boolean enabled) throws NotificationException {
        NotificationFilterPreference preference = this.notificationFilterPreferenceStore.getFilterPreference(wikiReference, filterPreferenceId);
        if (preference != null && enabled != preference.isEnabled()) {
            preference.setEnabled(enabled);
            this.saveFilterPreferences(wikiReference, Collections.singletonList(preference));
        }
    }

    public void saveFilterPreferences(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences) throws NotificationException {
        this.notificationFilterPreferenceStore.saveFilterPreferences(user, filterPreferences);
    }

    public void saveFilterPreferences(WikiReference wikiReference, Collection<NotificationFilterPreference> filterPreferences) throws NotificationException {
        this.notificationFilterPreferenceStore.saveFilterPreferences(wikiReference, filterPreferences);
    }

    public void setStartDateForUser(DocumentReference user, Date startDate) throws NotificationException {
        Set<NotificationFilterPreference> preferences = this.getFilterPreferences(user);
        if (preferences.isEmpty()) {
            return;
        }
        for (NotificationFilterPreference preference : preferences) {
            if (!(preference instanceof DefaultNotificationFilterPreference)) continue;
            ((DefaultNotificationFilterPreference)preference).setStartingDate(startDate);
        }
        this.saveFilterPreferences(user, preferences);
    }

    public void createScopeFilterPreference(DocumentReference user, NotificationFilterType type, Set<NotificationFormat> formats, List<String> eventTypes, EntityReference reference) throws NotificationException {
        this.saveFilterPreferences(user, Collections.singletonList(this.getScopeFilterPreference(type, formats, eventTypes, reference)));
    }

    public void createScopeFilterPreference(WikiReference wikiReference, NotificationFilterType type, Set<NotificationFormat> formats, List<String> eventTypes, EntityReference reference) throws NotificationException {
        this.saveFilterPreferences(wikiReference, Collections.singletonList(this.getScopeFilterPreference(type, formats, eventTypes, reference)));
    }

    private NotificationFilterPreference getScopeFilterPreference(NotificationFilterType type, Set<NotificationFormat> formats, List<String> eventTypes, EntityReference reference) throws NotificationException {
        DefaultNotificationFilterPreference preference = new DefaultNotificationFilterPreference();
        preference.setFilterType(type);
        preference.setNotificationFormats(formats);
        if (eventTypes != null && !eventTypes.isEmpty()) {
            preference.setEventTypes(new HashSet<String>(eventTypes));
        }
        preference.setEnabled(true);
        preference.setFilterName("scopeNotificationFilter");
        preference.setStartingDate(new Date());
        switch (reference.getType()) {
            case WIKI: {
                preference.setWiki(reference.getName());
                break;
            }
            case SPACE: {
                preference.setPage((String)this.entityReferenceSerializer.serialize(reference, new Object[0]));
                break;
            }
            case DOCUMENT: {
                preference.setPageOnly((String)this.entityReferenceSerializer.serialize(reference, new Object[0]));
                break;
            }
        }
        return preference;
    }
}

