/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.filters.internal.CachedFilterPreferencesModelBridge;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.FilterPreferencesModelBridge;
import org.xwiki.notifications.filters.internal.event.NotificationFilterPreferenceAddOrUpdatedEvent;
import org.xwiki.notifications.filters.internal.event.NotificationFilterPreferenceDeletedEvent;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="org.xwiki.notifications.filters.internal.CachedModelBridgeInvalidatorListener")
public class CachedModelBridgeInvalidatorListener
extends AbstractEventListener {
    public static final String NAME = "org.xwiki.notifications.filters.internal.CachedModelBridgeInvalidatorListener";
    @Inject
    @Named(value="cached")
    private FilterPreferencesModelBridge bridge;
    @Inject
    private DocumentReferenceResolver<String> resolver;

    public CachedModelBridgeInvalidatorListener() {
        super(NAME, new Event[]{new NotificationFilterPreferenceAddOrUpdatedEvent(), new NotificationFilterPreferenceDeletedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (source instanceof DefaultNotificationFilterPreference) {
            DefaultNotificationFilterPreference preferences = (DefaultNotificationFilterPreference)source;
            String owner = preferences.getOwner();
            if (owner != null) {
                if (StringUtils.contains((CharSequence)owner, (int)58)) {
                    ((CachedFilterPreferencesModelBridge)this.bridge).invalidatePreferencefilter((EntityReference)this.resolver.resolve((Object)owner, new Object[0]));
                } else {
                    ((CachedFilterPreferencesModelBridge)this.bridge).invalidatePreferencefilter((EntityReference)new WikiReference(owner));
                }
            }
        } else if (source instanceof DocumentReference) {
            ((CachedFilterPreferencesModelBridge)this.bridge).invalidatePreferencefilter((EntityReference)((DocumentReference)source));
        } else if (source instanceof WikiReference) {
            ((CachedFilterPreferencesModelBridge)this.bridge).invalidatePreferencefilter((EntityReference)((WikiReference)source));
        }
    }
}

