/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.validation.edit.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.validation.edit.EditConfirmationChecker;
import org.xwiki.model.validation.edit.EditConfirmationCheckerResults;
import org.xwiki.model.validation.edit.internal.EditConfirmationCheckersManager;

@Component
@Singleton
public class DefaultEditConfirmationCheckersManager
implements EditConfirmationCheckersManager {
    private static final String CACHED_QUALIFIER = "cached";
    private static final String FORCED_QUALIFIER = "forced";
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public EditConfirmationCheckerResults check() {
        EditConfirmationCheckerResults result = new EditConfirmationCheckerResults();
        XWikiDocument xWikiDocument = ((XWikiContext)this.xcontextProvider.get()).getDoc();
        String cachedKeyPrefix = this.computePrefix(xWikiDocument, CACHED_QUALIFIER);
        String forcedKeyPrefix = this.computePrefix(xWikiDocument, FORCED_QUALIFIER);
        HttpSession session = this.getSession();
        this.confirmationCheckersStream().flatMap(entry -> {
            String forcedKey = DefaultEditConfirmationCheckersManager.computeKey(entry, forcedKeyPrefix);
            String cachedKey = DefaultEditConfirmationCheckersManager.computeKey(entry, cachedKeyPrefix);
            Object forcedValue = session.getAttribute(forcedKey);
            EditConfirmationChecker checker = (EditConfirmationChecker)entry.getValue();
            Optional check = checker.check();
            check.ifPresentOrElse(editConfirmationCheckerResult -> {
                if (!result.isError()) {
                    session.setAttribute(cachedKey, (Object)editConfirmationCheckerResult.getSkipValue());
                }
            }, () -> session.removeAttribute(cachedKey));
            Optional checkResult = check.flatMap(editConfirmationCheckerResult -> {
                if (!editConfirmationCheckerResult.isError() && forcedValue != null && Objects.equals(editConfirmationCheckerResult.getSkipValue(), forcedValue)) {
                    return Optional.empty();
                }
                return Optional.of(editConfirmationCheckerResult);
            });
            return checkResult.stream();
        }).forEach(arg_0 -> ((EditConfirmationCheckerResults)result).append(arg_0));
        return result;
    }

    public void force() {
        XWikiDocument xWikiDocument = ((XWikiContext)this.xcontextProvider.get()).getDoc();
        String cachedKeyPrefix = this.computePrefix(xWikiDocument, CACHED_QUALIFIER);
        String forcedKeyPrefix = this.computePrefix(xWikiDocument, FORCED_QUALIFIER);
        HttpSession session = this.getSession();
        this.confirmationCheckersStream().forEach(entry -> {
            String cachedKey = DefaultEditConfirmationCheckersManager.computeKey(entry, cachedKeyPrefix);
            String forcedKey = DefaultEditConfirmationCheckersManager.computeKey(entry, forcedKeyPrefix);
            Object lastCheck = session.getAttribute(cachedKey);
            session.removeAttribute(cachedKey);
            session.setAttribute(forcedKey, lastCheck);
        });
    }

    private String computePrefix(XWikiDocument xWikiDocument, String qualifier) {
        String documentReference = (String)this.entityReferenceSerializer.serialize((EntityReference)xWikiDocument.getDocumentReference(), new Object[0]);
        return String.format("force_edit_%s_%s", documentReference, qualifier);
    }

    private static String computeKey(Map.Entry<String, EditConfirmationChecker> entry, String keyPrefix) {
        return String.format("%s_%s", keyPrefix, entry.getKey());
    }

    private Stream<Map.Entry<String, EditConfirmationChecker>> confirmationCheckersStream() {
        try {
            return this.componentManager.getInstanceMap(EditConfirmationChecker.class).entrySet().stream();
        }
        catch (ComponentLookupException e) {
            this.logger.warn("Failed to resolve the map of [{}]. Cause: [{}]", (Object)EditConfirmationChecker.class.getCanonicalName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return Stream.empty();
        }
    }

    private HttpSession getSession() {
        return ((XWikiContext)this.xcontextProvider.get()).getRequest().getSession();
    }
}

