/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.DefaultSymbolScheme;
import org.xwiki.model.internal.reference.LocalizedStringEntityReferenceSerializer;
import org.xwiki.stability.Unstable;

public class EntityReference
implements Serializable,
Cloneable,
Comparable<EntityReference> {
    @Unstable
    public static final String PARENT_TYPE_PARAMETER = "parentType";
    protected static final LocalizedStringEntityReferenceSerializer TOSTRING_SERIALIZER = new LocalizedStringEntityReferenceSerializer(new DefaultSymbolScheme());
    private static final long serialVersionUID = 2L;
    private String name;
    private EntityReference parent;
    private EntityType type;
    private Map<String, Serializable> parameters;
    private transient Integer size;
    private transient List<EntityReference> referenceList;

    public EntityReference(EntityReference reference) {
        this(reference, reference.parent);
    }

    public EntityReference(EntityReference reference, EntityReference parent) {
        this(reference.name, reference.type, parent, reference.parameters);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected EntityReference(EntityReference reference, EntityReference oldReference, EntityReference newReference) {
        if (reference == null) {
            throw new IllegalArgumentException("Cloned reference must not be null");
        }
        this.setName(reference.name);
        this.setType(reference.type);
        if (reference.parent == null) {
            if (oldReference != null) throw new IllegalArgumentException("The old reference [" + String.valueOf(oldReference) + "] does not belong to the parents chain of the reference [" + String.valueOf(reference) + "]");
            this.setParent(newReference);
        } else if (reference.parent.equals(oldReference)) {
            this.setParent(newReference);
        } else {
            this.setParent(new EntityReference(reference.parent, oldReference, newReference));
        }
        this.setParameters(reference.parameters);
    }

    public EntityReference(String name, EntityType type) {
        this(name, type, null, null);
    }

    public EntityReference(String name, EntityType type, EntityReference parent) {
        this.setName(name);
        this.setType(type);
        this.setParent(parent);
    }

    public EntityReference(String name, EntityType type, Map<String, Serializable> parameters) {
        this.setName(name);
        this.setType(type);
        this.setParameters(parameters);
    }

    public EntityReference(String name, EntityType type, EntityReference parent, Map<String, Serializable> parameters) {
        this.setName(name);
        this.setType(type);
        this.setParent(parent);
        this.setParameters(parameters);
    }

    public EntityReference(EntityReference reference, Map<String, Serializable> parameters) {
        this(reference.getName(), reference.getType(), reference.getParent(), parameters);
    }

    protected void setName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("An Entity Reference name cannot be null or empty");
        }
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    protected void setParent(EntityReference parent) {
        this.parent = parent;
    }

    public final EntityReference getParent() {
        return this.parent;
    }

    protected void setType(EntityType type) {
        if (type == null) {
            throw new IllegalArgumentException("An Entity Reference type cannot be null");
        }
        this.type = type;
    }

    public final EntityType getType() {
        return this.type;
    }

    protected void setParameters(Map<String, Serializable> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, Serializable> entry : parameters.entrySet()) {
                this.setParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void setParameter(String name, Serializable value) {
        if (value != null) {
            if (this.parameters == null) {
                this.parameters = new TreeMap<String, Serializable>();
            }
            if (PARENT_TYPE_PARAMETER.equals(name)) {
                this.setParentTypeParameter(value);
            } else {
                this.parameters.put(name, value);
            }
        } else if (this.parameters != null) {
            this.parameters.remove(name);
            if (this.parameters.isEmpty()) {
                this.parameters = null;
            }
        }
    }

    private void setParentTypeParameter(Serializable value) {
        if (value != null && this.getParent() == null) {
            EntityType entityType;
            EntityType parentType = value instanceof EntityType ? (entityType = (EntityType)((Object)value)) : EntityType.valueOf(value.toString().toUpperCase(Locale.ROOT));
            if (this.getType().getAllowedParents().contains((Object)parentType)) {
                this.parameters.put(PARENT_TYPE_PARAMETER, (Serializable)((Object)parentType));
            } else {
                throw new IllegalArgumentException("The parent type [" + String.valueOf((Object)parentType) + "] does not belong to the allowed parents");
            }
        }
    }

    protected final <T> T getParameter(String name) {
        return (T)(this.parameters == null ? null : this.parameters.get(name));
    }

    public final Map<String, Serializable> getParameters() {
        return this.parameters == null ? Collections.emptyMap() : this.parameters;
    }

    @Transient
    public EntityReference getRoot() {
        EntityReference reference = this;
        while (reference.getParent() != null) {
            reference = reference.getParent();
        }
        return reference;
    }

    @Transient
    public List<EntityReference> getReversedReferenceChain() {
        if (this.referenceList == null) {
            LinkedList<EntityReference> referenceDeque = new LinkedList<EntityReference>();
            EntityReference reference = this;
            do {
                referenceDeque.push(reference);
            } while ((reference = reference.getParent()) != null);
            this.referenceList = Collections.unmodifiableList(referenceDeque);
        }
        return this.referenceList;
    }

    public int size() {
        if (this.size == null) {
            int i = 0;
            for (EntityReference currentReference = this; currentReference != null; currentReference = currentReference.getParent()) {
                ++i;
            }
            this.size = i;
        }
        return this.size;
    }

    public EntityReference extractReference(EntityType type) {
        EntityReference reference;
        for (reference = this; reference != null && reference.getType() != type; reference = reference.getParent()) {
        }
        return reference;
    }

    public EntityReference extractFirstReference(EntityType type) {
        EntityReference reference;
        for (reference = this.extractReference(type); reference != null && reference.getParent() != null && reference.getParent().getType().equals((Object)type); reference = reference.getParent()) {
        }
        return reference;
    }

    public EntityReference replaceParent(EntityReference oldParent, EntityReference newParent) {
        if (oldParent == newParent) {
            return this;
        }
        return new EntityReference(this, oldParent, newParent);
    }

    public EntityReference replaceParent(EntityReference newParent) {
        if (newParent == this.getParent()) {
            return this;
        }
        return new EntityReference(this, newParent);
    }

    public EntityReference appendParent(EntityReference newParent) {
        if (newParent == null) {
            return this;
        }
        return new EntityReference(this, null, newParent);
    }

    public EntityReference removeParent(EntityReference oldParent) {
        if (oldParent == null) {
            return this;
        }
        return new EntityReference(this, oldParent, null);
    }

    public boolean hasParent(EntityReference expectedParent) {
        EntityReference actualParent = this.getParent();
        if (actualParent == expectedParent) {
            return true;
        }
        while (actualParent != null && !actualParent.equals(expectedParent)) {
            actualParent = actualParent.getParent();
        }
        return actualParent != null;
    }

    public EntityReference removeParameters(boolean recursive) {
        EntityReference current;
        if (!recursive) {
            current = this.getParameters().isEmpty() ? this : new EntityReference(this.getName(), this.getType(), this.getParent());
        } else {
            current = null;
            for (EntityReference entry : this.getReversedReferenceChain()) {
                if (entry.getParent() == current && entry.getParameters().isEmpty()) {
                    current = entry;
                    continue;
                }
                current = new EntityReference(entry.getName(), entry.getType(), current);
            }
        }
        return current;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(StringUtils.capitalize((String)this.getType().getLowerCase()));
        sb.append(' ');
        sb.append(TOSTRING_SERIALIZER.serialize(this, new Object[0]));
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityReference)) {
            return false;
        }
        EntityReference ref = (EntityReference)obj;
        return this.name.equals(ref.name) && this.type.equals((Object)ref.type) && (this.parent == null ? ref.parent == null : this.parent.equals(ref.parent)) && (this.parameters == null ? ref.parameters == null : this.parameters.equals(ref.parameters));
    }

    public boolean equals(EntityReference otherReference, EntityType to) {
        if (to == null) {
            return this.equals(otherReference);
        }
        if (otherReference == this) {
            return true;
        }
        if (otherReference == null) {
            return false;
        }
        EntityReference currentReference1 = this;
        EntityReference currentReference2 = otherReference;
        while (currentReference1 != null && (currentReference1.getType() == to || currentReference1.getType().isAllowedAncestor(to))) {
            if (!currentReference1.equalsNonRecursive(currentReference2)) {
                return false;
            }
            currentReference1 = currentReference1.getParent();
            currentReference2 = currentReference2.getParent();
        }
        return currentReference2 == null || to.isAllowedAncestor(currentReference2.getType());
    }

    public boolean equals(EntityReference otherReference, EntityType from, EntityType to) {
        if (otherReference == this) {
            return true;
        }
        if (otherReference == null) {
            return false;
        }
        EntityReference currentReference1 = from != null ? this.extractReference(from) : this;
        EntityReference currentReference2 = from != null ? otherReference.extractReference(from) : otherReference;
        return currentReference1.equals(currentReference2, to);
    }

    public boolean equalsNonRecursive(EntityReference otherReference) {
        if (otherReference == this) {
            return true;
        }
        if (otherReference == null) {
            return false;
        }
        return this.name.equals(otherReference.name) && this.type.equals((Object)otherReference.type) && (this.parameters == null ? otherReference.parameters == null : this.parameters.equals(otherReference.parameters));
    }

    @Unstable
    public EntityType getParentType() {
        EntityType result;
        if (this.getParent() == null) {
            result = (EntityType)((Object)this.getParameter(PARENT_TYPE_PARAMETER));
            if (result == null && !this.getType().getAllowedParents().isEmpty()) {
                result = this.getType().getAllowedParents().get(0);
            }
        } else {
            result = this.getParent().getType();
        }
        return result;
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 17).append((Object)this.getName()).append((Object)this.getType()).append((Object)this.getParent()).append(this.parameters).toHashCode();
    }

    @Override
    public int compareTo(EntityReference reference) {
        if (reference == null) {
            throw new NullPointerException("Provided reference should not be null");
        }
        if (reference == this) {
            return 0;
        }
        List<EntityReference> references = this.getReversedReferenceChain();
        Iterator<EntityReference> it = references.iterator();
        List<EntityReference> otherReferences = reference.getReversedReferenceChain();
        Iterator<EntityReference> otherIt = otherReferences.iterator();
        while (it.hasNext() && otherIt.hasNext()) {
            EntityReference element = it.next();
            EntityReference otherElement = otherIt.next();
            int result = element.getName().compareTo(otherElement.getName());
            if (result != 0) {
                return result;
            }
            result = this.compareParameters(element.getParameters(), otherElement.getParameters());
            if (result == 0) continue;
            return result;
        }
        return references.size() - otherReferences.size();
    }

    private int compareParameters(Map<String, Serializable> parameters, Map<String, Serializable> otherParameters) {
        for (Map.Entry<String, Serializable> entry : parameters.entrySet()) {
            Serializable otherValue;
            Serializable value = entry.getValue();
            int result = this.compareTo(value, otherValue = otherParameters.get(entry.getKey()));
            if (result == 0) continue;
            return result;
        }
        return parameters.size() - otherParameters.size();
    }

    private int compareTo(Object value, Object otherValue) {
        if (value != otherValue) {
            if (value == null) {
                return -1;
            }
            if (otherValue == null) {
                return 1;
            }
            if (value.getClass() == otherValue.getClass() && value instanceof Comparable) {
                return ((Comparable)value).compareTo(otherValue);
            }
            if (!value.equals(otherValue)) {
                return 1;
            }
        }
        return 0;
    }
}

