/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import javax.inject.Singleton;
import org.xwiki.collection.SoftCache;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;

@Component(roles={EntityReferenceFactory.class})
@Singleton
public class EntityReferenceFactory {
    private SoftCache<EntityReference, EntityReference> cache = new SoftCache();

    public <E extends EntityReference> E getReference(E reference) {
        if (reference == null) {
            return null;
        }
        EntityReference entityReference = (EntityReference)this.cache.get(reference);
        if (entityReference == null || !reference.getClass().isAssignableFrom(entityReference.getClass())) {
            entityReference = this.unique(reference);
            this.cache.put((Object)entityReference, (Object)entityReference);
        }
        return (E)entityReference;
    }

    private <E extends EntityReference> E unique(E reference) {
        EntityReference parent = reference.getParent();
        EntityReference cachedParent = this.getReference(parent);
        if (cachedParent != parent) {
            EntityReference uniqueReference = reference.replaceParent(cachedParent);
            if (reference.getClass().isAssignableFrom(uniqueReference.getClass())) {
                return (E)uniqueReference;
            }
        }
        return reference;
    }
}

