/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.phase.Initializable;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.AbstractEntityReferenceResolver;
import org.xwiki.model.internal.reference.SymbolScheme;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;

public abstract class AbstractStringEntityReferenceResolver
extends AbstractEntityReferenceResolver
implements EntityReferenceResolver<String>,
Initializable {
    private String[] escapeMatching;
    private String[] escapeMatchingReplace;
    @Inject
    private SymbolScheme symbolScheme;
    private Map<EntityType, Map<Character, EntityType>> referenceSetup;

    public AbstractStringEntityReferenceResolver() {
    }

    public AbstractStringEntityReferenceResolver(SymbolScheme symbolScheme) {
        this.symbolScheme = symbolScheme;
        this.initialize();
    }

    public void initialize() {
        this.referenceSetup = new EnumMap<EntityType, Map<Character, EntityType>>(EntityType.class);
        Map<EntityType, Map<EntityType, Character>> separators = this.getSymbolScheme().getSeparatorSymbols();
        for (Map.Entry<EntityType, Map<EntityType, Character>> separatorEntry : separators.entrySet()) {
            HashMap<Character, EntityType> characterMap = new HashMap<Character, EntityType>();
            for (Map.Entry<EntityType, Character> characterEntry : separatorEntry.getValue().entrySet()) {
                characterMap.put(characterEntry.getValue(), characterEntry.getKey());
            }
            this.referenceSetup.put(separatorEntry.getKey(), characterMap);
        }
        String escape = Character.toString(this.getSymbolScheme().getEscapeSymbol().charValue());
        this.escapeMatching = new String[]{escape + escape, escape};
        this.escapeMatchingReplace = new String[]{escape, ""};
    }

    private StringBuilder createStringBuilder(String entityReferenceRepresentation) {
        StringBuilder representation = entityReferenceRepresentation == null ? new StringBuilder() : new StringBuilder(entityReferenceRepresentation);
        return representation;
    }

    @Override
    public EntityReference resolve(String entityReferenceRepresentation, EntityType type, Object ... parameters) {
        if (type == null) {
            Character entityTypeSeparator = this.getSymbolScheme().getEntityTypeSeparator();
            if (entityTypeSeparator != null) {
                type = Enum.valueOf(EntityType.class, StringUtils.substringBefore((String)entityReferenceRepresentation, (int)entityTypeSeparator.charValue()).toUpperCase(Locale.ENGLISH));
                entityReferenceRepresentation = StringUtils.substringAfter((String)entityReferenceRepresentation, (int)entityTypeSeparator.charValue());
            } else {
                throw new IllegalArgumentException("Impossible to extract the type from the reference: the symbol scheme does not indicate any");
            }
        }
        if (type == null) {
            throw new IllegalArgumentException("Impossible to parse an entity reference without knowing the entity type");
        }
        Map<Character, EntityType> typeSetup = this.getTypeSetup(type);
        if (typeSetup == null || typeSetup.isEmpty()) {
            return this.getNewReference(entityReferenceRepresentation, true, type, parameters);
        }
        StringBuilder representation = this.createStringBuilder(entityReferenceRepresentation);
        EntityReference reference = null;
        Character escapeSymbol = this.getSymbolScheme().getEscapeSymbol();
        EntityType currentType = type;
        while (typeSetup != null && !typeSetup.isEmpty()) {
            EntityType parentType = null;
            Character parameterSeparator = this.getSymbolScheme().getParameterSeparator(currentType);
            String defaultParameter = this.getSymbolScheme().getDefaultParameter(currentType);
            HashMap<String, Serializable> referenceParameters = null;
            boolean unescape = false;
            int i = representation.length();
            while (--i >= 0) {
                int numberOfEscapeChars;
                char currentChar = representation.charAt(i);
                int nextIndex = i - 1;
                char nextChar = '\u0000';
                if (nextIndex >= 0) {
                    nextChar = representation.charAt(nextIndex);
                }
                if (typeSetup.containsKey(Character.valueOf(currentChar))) {
                    numberOfEscapeChars = this.getNumberOfCharsBefore(escapeSymbol.charValue(), representation, nextIndex);
                    if (numberOfEscapeChars % 2 == 0) {
                        parentType = typeSetup.get(Character.valueOf(currentChar));
                        break;
                    }
                    unescape = true;
                    --i;
                    continue;
                }
                if (nextChar == escapeSymbol.charValue()) {
                    unescape = true;
                    --i;
                    continue;
                }
                if (parameterSeparator == null || parameterSeparator.charValue() != currentChar) continue;
                numberOfEscapeChars = this.getNumberOfCharsBefore(escapeSymbol.charValue(), representation, nextIndex);
                if (numberOfEscapeChars % 2 == 0) {
                    if (referenceParameters == null) {
                        referenceParameters = new HashMap<String, Serializable>();
                    }
                    this.parseParameter(representation, i + 1, referenceParameters, defaultParameter, escapeSymbol);
                    representation.delete(i, representation.length());
                    continue;
                }
                unescape = true;
                --i;
            }
            reference = this.appendNewReference(reference, this.getNewReference(i, representation, unescape, currentType, referenceParameters, parameters));
            currentType = parentType != null ? parentType : typeSetup.values().iterator().next();
            typeSetup = this.getTypeSetup(currentType);
        }
        reference = this.appendNewReference(reference, this.getNewReference(representation, true, currentType, parameters));
        reference = this.evaluateKeywords(reference, parameters);
        return reference;
    }

    private EntityReference evaluateKeywords(EntityReference reference, Object ... parameters) {
        if (reference == null) {
            return null;
        }
        EntityReference evaluatedReference = reference;
        EntityReference evaluatedParent = this.evaluateKeywords(reference.getParent(), parameters);
        if (reference.getName().equals(this.getSymbolScheme().getCurrentReferenceKeyword(reference.getType()))) {
            if (evaluatedParent == null) {
                evaluatedReference = this.resolveDefaultReference(reference.getType(), parameters);
            } else if (evaluatedParent.getType() != reference.getType()) {
                EntityReference defaultReference = this.resolveDefaultReference(reference.getType(), parameters);
                EntityReference defaultParent = defaultReference.extractReference(evaluatedParent.getType());
                evaluatedReference = defaultReference.replaceParent(defaultParent, evaluatedParent);
            } else {
                evaluatedReference = evaluatedParent;
            }
        } else if (reference.getName().equals(this.getSymbolScheme().getParentReferenceKeyword(reference.getType()))) {
            EntityReference defaultReference;
            evaluatedReference = evaluatedParent == null ? null : (evaluatedParent.getType() != reference.getType() ? ((defaultReference = this.resolveDefaultReference(reference.getType(), parameters)).getParent() == null ? evaluatedParent : defaultReference.getParent().appendParent(evaluatedParent)) : evaluatedParent.getParent());
        } else if (evaluatedParent != reference.getParent()) {
            evaluatedReference = new EntityReference(reference, evaluatedParent);
        }
        return evaluatedReference;
    }

    protected Map<Character, EntityType> getTypeSetup(EntityType type) {
        return this.referenceSetup.get((Object)type);
    }

    private String unescape(String text) {
        return StringUtils.isEmpty((CharSequence)text) ? text : StringUtils.replaceEach((String)text, (String[])this.escapeMatching, (String[])this.escapeMatchingReplace);
    }

    private EntityReference getNewReference(CharSequence representation, boolean unescape, EntityType type, Object ... parameters) {
        EntityReference newReference;
        if (representation.length() > 0) {
            String name = representation.toString();
            if (unescape) {
                name = this.unescape(name);
            }
            newReference = new EntityReference(name, type);
        } else {
            newReference = this.resolveDefaultReference(type, null, parameters);
        }
        return newReference;
    }

    private EntityReference getNewReference(int i, StringBuilder representation, boolean unescape, EntityType type, Map<String, Serializable> referenceParameters, Object ... parameters) {
        EntityReference newReference;
        if (i == representation.length() - 1) {
            newReference = this.resolveDefaultReference(type, referenceParameters, parameters);
        } else {
            String name = representation.substring(i + 1, representation.length());
            if (unescape) {
                name = this.unescape(name);
            }
            newReference = new EntityReference(name, type, referenceParameters);
        }
        representation.delete(i < 0 ? 0 : i, representation.length());
        return newReference;
    }

    protected EntityReference resolveDefaultReference(EntityType type, Map<String, Serializable> referenceParameters, Object ... parameters) {
        EntityReference reference = this.resolveDefaultReference(type, parameters);
        if (referenceParameters != null && !referenceParameters.isEmpty()) {
            reference = new EntityReference(reference, referenceParameters);
        }
        return reference;
    }

    private void parseParameter(StringBuilder representation, int index, Map<String, Serializable> parsedParameters, String defaultParameter, Character escapeSymbol) {
        String key = null;
        String value = null;
        boolean unescape = false;
        boolean unescapeKey = false;
        int valueIndex = index;
        boolean escaped = false;
        for (int i = index; i < representation.length(); ++i) {
            char c = representation.charAt(i);
            if (escaped) {
                unescape = true;
                escaped = false;
                continue;
            }
            if (key == null && c == '=') {
                key = representation.substring(index, i);
                valueIndex = i + 1;
                unescapeKey = unescape;
                unescape = false;
                continue;
            }
            if (c != escapeSymbol.charValue()) continue;
            escaped = true;
        }
        if (key == null) {
            key = defaultParameter;
        } else if (unescapeKey) {
            key = this.unescape(key);
        }
        if (!parsedParameters.containsKey(key)) {
            value = representation.substring(valueIndex, representation.length());
            if (unescape) {
                value = this.unescape(value);
            }
            String parameterName = key != null ? key : defaultParameter;
            parsedParameters.put(parameterName, this.getSymbolScheme().resolveParameter(parameterName, value));
        }
    }

    private EntityReference appendNewReference(EntityReference reference, EntityReference newReference) {
        if (newReference != null) {
            if (reference != null) {
                return reference.appendParent(newReference);
            }
            return newReference;
        }
        return reference;
    }

    private int getNumberOfCharsBefore(char c, StringBuilder representation, int currentPosition) {
        int position;
        for (position = currentPosition; position >= 0 && representation.charAt(position) == c; --position) {
        }
        return currentPosition - position;
    }

    protected SymbolScheme getSymbolScheme() {
        return this.symbolScheme;
    }
}

