/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public enum EntityType {
    WIKI(new EntityType[0]),
    SPACE(WIKI, null),
    DOCUMENT(SPACE),
    ATTACHMENT(DOCUMENT),
    OBJECT(DOCUMENT),
    OBJECT_PROPERTY(OBJECT),
    CLASS_PROPERTY(DOCUMENT),
    BLOCK(DOCUMENT, OBJECT_PROPERTY),
    PAGE(WIKI, null),
    PAGE_ATTACHMENT(PAGE),
    PAGE_OBJECT(PAGE),
    PAGE_OBJECT_PROPERTY(PAGE_OBJECT),
    PAGE_CLASS_PROPERTY(PAGE);

    private final String lowerCase;
    private final List<EntityType> allowedParents;
    private final boolean[] allowedAncestors = new boolean[13];

    private EntityType(EntityType ... allowedParents) {
        this.lowerCase = this.name().toLowerCase(Locale.US);
        ArrayList<EntityType> list = new ArrayList<EntityType>(allowedParents.length);
        for (EntityType parent : allowedParents) {
            list.add(parent != null ? parent : this);
        }
        this.allowedParents = Collections.unmodifiableList(list);
        this.setParentTypes(this.allowedParents);
    }

    private void setParentTypes(List<EntityType> parents) {
        for (EntityType parent : parents) {
            if (this.allowedAncestors[parent.ordinal()]) continue;
            this.allowedAncestors[parent.ordinal()] = true;
            this.setParentTypes(parent.getAllowedParents());
        }
    }

    public String getLowerCase() {
        return this.lowerCase;
    }

    public List<EntityType> getAllowedParents() {
        return this.allowedParents;
    }

    public boolean isAllowedAncestor(EntityType type) {
        return this.allowedAncestors[type.ordinal()];
    }
}

