/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mentions.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.RecordableEvent;
import org.xwiki.eventstream.RecordableEventConverter;
import org.xwiki.eventstream.RecordableEventDescriptor;
import org.xwiki.mentions.events.MentionEvent;
import org.xwiki.mentions.events.MentionEventParams;
import org.xwiki.mentions.internal.MentionsNotificationsObjectMapper;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;

@Component
@Singleton
@Named(value="mentions")
public class MentionsRecordableEventConverter
implements RecordableEventConverter {
    public static final String MENTIONS_PARAMETER_KEY = "mentions";
    @Inject
    private RecordableEventConverter defaultConverter;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private MentionsNotificationsObjectMapper objectMapper;
    @Inject
    @Named(value="mentions.mention")
    private RecordableEventDescriptor descriptor;
    @Inject
    private Logger logger;

    public Event convert(RecordableEvent recordableEvent, String source, Object data) {
        MentionEvent mentionEvent = (MentionEvent)recordableEvent;
        MentionEventParams params = mentionEvent.getParams();
        DocumentReference userDocument = this.documentReferenceResolver.resolve((Object)params.getUserReference(), new Object[0]);
        DocumentReference document = this.documentReferenceResolver.resolve((Object)params.getDocumentReference(), new Object[0]);
        Optional<String> serialize = this.objectMapper.serialize(mentionEvent.getParams());
        return serialize.map(json -> {
            try {
                Event convertedEvent = this.defaultConverter.convert(recordableEvent, source, data);
                convertedEvent.setUser(userDocument);
                convertedEvent.setDocument(document);
                convertedEvent.setType("mentions.mention");
                convertedEvent.setWiki(document.getWikiReference());
                convertedEvent.setTitle(this.descriptor.getEventTitle());
                Map<String, String> parameters = this.initializeParameters((String)json);
                convertedEvent.setParameters(parameters);
                return convertedEvent;
            }
            catch (Exception e) {
                this.logger.warn("Failed to convert the recordable event [{}]. Cause [{}].", (Object)recordableEvent, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                return null;
            }
        }).orElse(null);
    }

    private Map<String, String> initializeParameters(String value) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(MENTIONS_PARAMETER_KEY, value);
        return parameters;
    }

    public List<RecordableEvent> getSupportedEvents() {
        return Collections.singletonList(new MentionEvent(null, null));
    }
}

