/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mentions.internal.analyzer;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.mentions.DisplayStyle;
import org.xwiki.mentions.MentionLocation;
import org.xwiki.mentions.internal.MentionXDOMService;
import org.xwiki.mentions.internal.MentionedActorReference;
import org.xwiki.mentions.internal.analyzer.AbstractDocumentMentionsAnalyzer;
import org.xwiki.mentions.notifications.MentionNotificationParameter;
import org.xwiki.mentions.notifications.MentionNotificationParameters;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.syntax.Syntax;

@Component(roles={UpdatedDocumentMentionsAnalyzer.class})
@Singleton
public class UpdatedDocumentMentionsAnalyzer
extends AbstractDocumentMentionsAnalyzer {
    @Inject
    private MentionXDOMService xdomService;

    public List<MentionNotificationParameters> analyze(XWikiDocument oldDoc, XWikiDocument newDoc, DocumentReference documentReference, String version, String authorReference) {
        ArrayList<MentionNotificationParameters> mentionNotificationParametersList = new ArrayList<MentionNotificationParameters>();
        this.handleUpdatedContent(oldDoc.getXDOM(), newDoc.getXDOM(), (EntityReference)documentReference, version, authorReference, MentionLocation.DOCUMENT).ifPresent(mentionNotificationParametersList::add);
        mentionNotificationParametersList.addAll(this.traverseXObjectsOnUpdate(oldDoc.getXObjects(), newDoc.getXObjects(), version, authorReference, newDoc.getSyntax()));
        return mentionNotificationParametersList;
    }

    private Optional<MentionNotificationParameters> handleUpdatedContent(XDOM oldXDOM, XDOM newXDOM, EntityReference entityReference, String version, String authorReference, MentionLocation location) {
        MentionNotificationParameters ret = new MentionNotificationParameters(authorReference, entityReference, location, version);
        List<MacroBlock> oldMentions = this.xdomService.listMentionMacros(oldXDOM);
        List<MacroBlock> newMentions = this.xdomService.listMentionMacros(newXDOM);
        Map<MentionedActorReference, List<String>> oldCounts = this.xdomService.groupAnchorsByUserReference(oldMentions);
        Map<MentionedActorReference, List<String>> newCounts = this.xdomService.groupAnchorsByUserReference(newMentions);
        this.addAllMentions(ret, newCounts, newMentions);
        for (Map.Entry<MentionedActorReference, List<String>> entry : newCounts.entrySet()) {
            long oldEmptyAnchorsNumber;
            MentionedActorReference key = entry.getKey();
            String type = key.getType();
            String reference = key.getReference();
            List<String> newAnchorIds = entry.getValue();
            List oldAnchorsIds = oldCounts.getOrDefault(key, Collections.emptyList());
            List anchorsToNotify = newAnchorIds.stream().filter(value -> !StringUtils.isEmpty((CharSequence)value) && !oldAnchorsIds.contains(value)).collect(Collectors.toList());
            long newEmptyAnchorsNumber = newAnchorIds.stream().filter(StringUtils::isEmpty).count();
            if (newEmptyAnchorsNumber > (oldEmptyAnchorsNumber = oldAnchorsIds.stream().filter(StringUtils::isEmpty).count())) {
                DisplayStyle displayStyle = this.findDisplayStyle(newMentions, reference, null);
                this.addNewMention(ret, type, new MentionNotificationParameter(reference, null, displayStyle));
            }
            for (String anchor : anchorsToNotify) {
                DisplayStyle displayStyle = this.findDisplayStyle(newMentions, reference, anchor);
                this.addNewMention(ret, type, new MentionNotificationParameter(reference, anchor, displayStyle));
            }
        }
        return this.wrapResult(ret);
    }

    private List<MentionNotificationParameters> traverseXObjectsOnUpdate(Map<DocumentReference, List<BaseObject>> oldXObjects, Map<DocumentReference, List<BaseObject>> xObjects, String version, String authorReference, Syntax syntax) {
        ArrayList<MentionNotificationParameters> ret = new ArrayList<MentionNotificationParameters>();
        for (Map.Entry<DocumentReference, List<BaseObject>> entry : xObjects.entrySet()) {
            List<BaseObject> oldEntry = oldXObjects.get(entry.getKey());
            for (BaseObject baseObject : entry.getValue()) {
                if (baseObject == null) continue;
                ret.addAll(this.handleBaseObjectOnUpdate(oldEntry, baseObject, version, authorReference, syntax));
            }
        }
        return ret;
    }

    private List<MentionNotificationParameters> handleBaseObjectOnUpdate(List<BaseObject> oldEntry, BaseObject baseObject, String version, String authorReference, Syntax syntax) {
        ArrayList<MentionNotificationParameters> mentionNotificationParametersList = new ArrayList<MentionNotificationParameters>();
        if (baseObject != null) {
            Optional<Object> oldBaseObject = oldEntry != null && oldEntry.size() > baseObject.getNumber() ? Optional.ofNullable(oldEntry.get(baseObject.getNumber())) : Optional.empty();
            if (Objects.equals(baseObject.getXClassReference().getLocalDocumentReference(), XWikiDocument.COMMENTSCLASS_REFERENCE)) {
                Optional.ofNullable(baseObject.getField("comment")).ifPresent(it -> {
                    LargeStringProperty lsp = (LargeStringProperty)it;
                    PropertyInterface field = lsp.getObject().getField("selection");
                    boolean isComment = field == null || StringUtils.isEmpty((CharSequence)field.toFormString());
                    MentionLocation location = isComment ? MentionLocation.COMMENT : MentionLocation.ANNOTATION;
                    this.handleProperty(oldBaseObject, lsp, version, location, authorReference, syntax).ifPresent(mentionNotificationParametersList::add);
                });
            } else {
                for (Object o : baseObject.getProperties()) {
                    if (!(o instanceof LargeStringProperty)) continue;
                    this.handleProperty(oldBaseObject, (LargeStringProperty)o, version, MentionLocation.TEXT_FIELD, authorReference, syntax).ifPresent(mentionNotificationParametersList::add);
                }
            }
        }
        return mentionNotificationParametersList;
    }

    private Optional<MentionNotificationParameters> handleProperty(Optional<BaseObject> oldBaseObject, LargeStringProperty largeStringProperty, String version, MentionLocation location, String authorReference, Syntax syntax) {
        Optional oldDom = oldBaseObject.flatMap(it -> Optional.ofNullable(it.getField(largeStringProperty.getName()))).filter(it -> it instanceof LargeStringProperty).flatMap(it -> this.xdomService.parse(((LargeStringProperty)it).getValue(), syntax));
        return this.xdomService.parse(largeStringProperty.getValue(), syntax).flatMap(xdom -> {
            EntityReference entityReference = largeStringProperty.getReference();
            return oldDom.map(value -> this.handleUpdatedContent((XDOM)value, (XDOM)xdom, entityReference, version, authorReference, location)).orElseGet(() -> this.handleCreatedContent((XDOM)xdom, entityReference, version, authorReference, location));
        });
    }

    private Optional<MentionNotificationParameters> handleCreatedContent(XDOM newXdom, EntityReference entityReference, String version, String authorReference, MentionLocation location) {
        MentionNotificationParameters mentionNotificationParameters = new MentionNotificationParameters(authorReference, entityReference, location, version);
        List<MacroBlock> newMentions = this.xdomService.listMentionMacros(newXdom);
        Map<MentionedActorReference, List<String>> mentionedActorReferenceListMap = this.xdomService.groupAnchorsByUserReference(newMentions);
        this.addAllMentions(mentionNotificationParameters, mentionedActorReferenceListMap, newMentions);
        mentionedActorReferenceListMap.forEach((key, value) -> value.forEach(anchorId -> {
            DisplayStyle displayStyle = this.findDisplayStyle(newMentions, key.getReference(), (String)anchorId);
            this.addNewMention(mentionNotificationParameters, key.getType(), new MentionNotificationParameter(key.getReference(), anchorId, displayStyle));
        }));
        return this.wrapResult(mentionNotificationParameters);
    }
}

