/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mentions.internal;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.mentions.DisplayStyle;
import org.xwiki.mentions.MentionsFormatter;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.user.UserProperties;
import org.xwiki.user.UserPropertiesResolver;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Singleton
@Named(value="user")
@Component
public class UserMentionsFormatter
implements MentionsFormatter {
    @Inject
    private UserPropertiesResolver userPropertiesResolver;
    @Inject
    private UserReferenceResolver<String> userReferenceResolver;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;

    public String formatMention(String actorReference, DisplayStyle style) {
        UserReference resolve = this.userReferenceResolver.resolve((Object)actorReference, new Object[0]);
        UserProperties userProperties = this.userPropertiesResolver.resolve(resolve, new Object[0]);
        String firstName = Objects.toString(userProperties.getFirstName(), "");
        String lastName = Objects.toString(userProperties.getLastName(), "");
        String content = Objects.equals(style, DisplayStyle.LOGIN) || Objects.equals(firstName, "") && Objects.equals(lastName, "") ? this.documentReferenceResolver.resolve((Object)actorReference, new Object[0]).getName() : (Objects.equals(style, DisplayStyle.FIRST_NAME) ? firstName : String.format("%s %s", firstName, lastName).trim());
        return "@" + content;
    }
}

