/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mentions.internal;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DocumentRevisionProvider;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseStringProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.mentions.MentionLocation;
import org.xwiki.mentions.MentionsConfiguration;
import org.xwiki.mentions.events.MentionEvent;
import org.xwiki.mentions.events.MentionEventParams;
import org.xwiki.mentions.events.NewMentionsEvent;
import org.xwiki.mentions.internal.MentionXDOMService;
import org.xwiki.mentions.internal.QuoteService;
import org.xwiki.mentions.notifications.MentionNotificationParameter;
import org.xwiki.mentions.notifications.MentionNotificationParameters;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.user.UserReferenceSerializer;

@Component
@Named(value="UserMentionEventListener")
@Singleton
public class UserMentionEventListener
implements EventListener {
    public static final String TYPE = "UserMentionEventListener";
    @Inject
    private ObservationManager observationManager;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private UserReferenceSerializer<String> userReferenceSerializer;
    @Inject
    private QuoteService quote;
    @Inject
    private MentionsConfiguration configuration;
    @Inject
    private UserReferenceResolver<String> userReferenceResolver;
    @Inject
    private DocumentRevisionProvider documentRevisionProvider;
    @Inject
    private MentionXDOMService xdomService;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private Logger logger;

    public String getName() {
        return TYPE;
    }

    public List<Event> getEvents() {
        return Collections.singletonList(new NewMentionsEvent());
    }

    public void onEvent(Event event, Object source, Object data) {
        MentionNotificationParameters mentionNotificationParameters = (MentionNotificationParameters)data;
        Set newMentions = (Set)mentionNotificationParameters.getNewMentions().get("user");
        if (newMentions != null) {
            Optional<Object> optionalDoc;
            EntityReference entityReference = mentionNotificationParameters.getEntityReference();
            try {
                optionalDoc = Optional.of(this.documentRevisionProvider.getRevision((DocumentReference)entityReference.extractReference(EntityType.DOCUMENT), mentionNotificationParameters.getVersion()));
            }
            catch (XWikiException e) {
                this.logger.warn("Failed to send the mentions notifications. Cause: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                optionalDoc = Optional.empty();
            }
            optionalDoc.ifPresent(doc -> {
                for (MentionNotificationParameter mentionNotificationParameter : newMentions) {
                    this.handleNotification(mentionNotificationParameters, entityReference, (XWikiDocument)doc, mentionNotificationParameter);
                }
            });
        }
    }

    private void handleNotification(MentionNotificationParameters mentionNotificationParameters, EntityReference entityReference, XWikiDocument doc, MentionNotificationParameter mentionNotificationParameter) {
        if (this.canView(mentionNotificationParameter.getReference(), entityReference)) {
            String extractedQuote = this.getQuoteFromXDOM(mentionNotificationParameters, entityReference, doc, mentionNotificationParameter);
            MentionEventParams params = new MentionEventParams().setUserReference(mentionNotificationParameters.getAuthorReference()).setDocumentReference((String)this.entityReferenceSerializer.serialize(entityReference.extractReference(EntityType.DOCUMENT), new Object[0])).setLocation(mentionNotificationParameters.getLocation()).setAnchor(mentionNotificationParameter.getAnchorId()).setQuote(extractedQuote);
            String mentionedIdentity = mentionNotificationParameter.getReference();
            UserReference userReference = this.userReferenceResolver.resolve((Object)mentionedIdentity, new Object[]{entityReference.extractReference(EntityType.WIKI)});
            String identity = (String)this.userReferenceSerializer.serialize(userReference);
            MentionEvent event = new MentionEvent(Collections.singleton(identity), params);
            this.observationManager.notify((Event)event, (Object)"org.xwiki.contrib:mentions-notifications", (Object)"mentions.mention");
        }
    }

    private boolean canView(String userReference, EntityReference entityReference) {
        return this.authorizationManager.hasAccess(Right.VIEW, this.documentReferenceResolver.resolve((Object)userReference, new Object[]{entityReference.extractReference(EntityType.WIKI)}), entityReference);
    }

    private String getQuoteFromXDOM(MentionNotificationParameters mentionNotificationParameters, EntityReference entityReference, XWikiDocument doc, MentionNotificationParameter mentionNotificationParameter) {
        String extractedQuote;
        if (this.configuration.isQuoteActivated()) {
            Object xdom;
            if (MentionLocation.DOCUMENT.equals((Object)mentionNotificationParameters.getLocation())) {
                xdom = doc.getXDOM();
            } else {
                String name = entityReference.getName();
                PropertyInterface field = doc.getXObject(entityReference.extractReference(EntityType.OBJECT)).getField(name);
                xdom = field instanceof BaseStringProperty ? (XDOM)this.xdomService.parse(((BaseStringProperty)field).getValue(), doc.getSyntax()).orElse(null) : null;
            }
            extractedQuote = xdom != null ? (String)this.quote.extract((XDOM)xdom, mentionNotificationParameter.getAnchorId()).orElse(null) : null;
        } else {
            extractedQuote = null;
        }
        return extractedQuote;
    }
}

