/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mentions.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.mentions.MentionsFormatter;
import org.xwiki.mentions.internal.MentionFormatterProvider;

@Component
@Singleton
public class DefaultMentionsFormatterProvider
implements MentionFormatterProvider {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    @Inject
    private MentionsFormatter defaultFormatter;

    public MentionsFormatter get(String type) {
        MentionsFormatter ret;
        String hint = type;
        if (StringUtils.isEmpty((CharSequence)type)) {
            hint = "user";
        }
        try {
            ret = (MentionsFormatter)this.componentManager.getInstance(MentionsFormatter.class, hint);
        }
        catch (ComponentLookupException e) {
            this.logger.debug("Unable to find a formatter with type [{}]. Fallback to the default formatter. Cause: [{}]", (Object)type, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            ret = this.defaultFormatter;
        }
        return ret;
    }
}

