/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mentions.internal;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.mentions.internal.MentionXDOMService;
import org.xwiki.mentions.internal.MentionedActorReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Singleton
public class DefaultMentionXDOMService
implements MentionXDOMService {
    private static final String MENTION_MACRO_NAME = "mention";
    private static final String REFERENCE_PARAM_NAME = "reference";
    private static final String ANCHORID_PARAM_NAME = "anchor";
    private static final String TYPE_PARAM_NAME = "type";
    @Inject
    private Logger logger;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;

    private static boolean matchMentionMacro(Block block) {
        return block instanceof MacroBlock && Objects.equals(((MacroBlock)block).getId(), MENTION_MACRO_NAME);
    }

    @Override
    public List<MacroBlock> listMentionMacros(XDOM xdom) {
        return xdom.getBlocks(DefaultMentionXDOMService::matchMentionMacro, Block.Axes.DESCENDANT);
    }

    @Override
    public Map<MentionedActorReference, List<String>> groupAnchorsByUserReference(List<MacroBlock> mentions) {
        HashMap<MentionedActorReference, List<String>> ret = new HashMap<MentionedActorReference, List<String>>();
        for (MacroBlock block : mentions) {
            String userReference = block.getParameter(REFERENCE_PARAM_NAME);
            String type = Optional.ofNullable(block.getParameter(TYPE_PARAM_NAME)).orElse("user");
            ret.merge(new MentionedActorReference(userReference, type), new ArrayList<String>(Collections.singletonList(block.getParameter(ANCHORID_PARAM_NAME))), (l1, l2) -> {
                l1.addAll(l2);
                return l1;
            });
        }
        return ret;
    }

    @Override
    public Optional<XDOM> parse(String payload, Syntax syntax) {
        Optional<XDOM> oxdom;
        try {
            Parser instance = (Parser)((ComponentManager)this.componentManager.get()).getInstance(Parser.class, syntax.toIdString());
            XDOM xdom = instance.parse((Reader)new StringReader(payload));
            oxdom = Optional.of(xdom);
        }
        catch (ParseException e) {
            this.logger.warn("Failed to parse the payload [{}]. Cause [{}].", (Object)payload, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            oxdom = Optional.empty();
        }
        catch (ComponentLookupException e) {
            this.logger.warn("Failed to get the parser instance [{}]. Cause [{}].", (Object)syntax, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            oxdom = Optional.empty();
        }
        return oxdom;
    }
}

