/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mentions.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.index.TaskManager;
import org.xwiki.mentions.DisplayStyle;
import org.xwiki.mentions.MentionsConfiguration;
import org.xwiki.mentions.internal.MentionFormatterProvider;
import org.xwiki.script.service.ScriptService;

@Component
@Singleton
@Named(value="mentions")
public class MentionsScriptService
implements ScriptService {
    @Inject
    private MentionsConfiguration configuration;
    @Inject
    private MentionFormatterProvider mentionFormatterProvider;
    @Inject
    private TaskManager eventExecutor;

    public String getMentionsColor() {
        return this.configuration.getMentionsColor();
    }

    public String getSelfMentionsColor() {
        return this.configuration.getSelfMentionsColor();
    }

    public long getQueueSize() {
        return this.eventExecutor.getQueueSize("mention");
    }

    public boolean isQuoteActivated() {
        return this.configuration.isQuoteActivated();
    }

    public String format(String actorReference, DisplayStyle style, String type) {
        String hint = StringUtils.isEmpty((CharSequence)type) ? "user" : type;
        return this.mentionFormatterProvider.get(hint).formatMention(actorReference, style);
    }
}

