/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mentions.notifications;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.mentions.MentionLocation;
import org.xwiki.mentions.notifications.MentionNotificationParameter;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.text.XWikiToStringBuilder;

public class MentionNotificationParameters
implements Serializable {
    private static final long serialVersionUID = -8847694983380889549L;
    private final Map<String, Set<MentionNotificationParameter>> newMentions;
    private final Map<String, Set<MentionNotificationParameter>> unmodifiableNewMentions;
    private final Map<String, Set<MentionNotificationParameter>> mentions;
    private final Map<String, Set<MentionNotificationParameter>> unmodifiableMentions;
    private final String authorReference;
    private final EntityReference entityReference;
    private final MentionLocation location;
    private final String version;

    public MentionNotificationParameters(String authorReference, EntityReference entityReference, MentionLocation location, String version) {
        this.authorReference = authorReference;
        this.entityReference = entityReference;
        this.location = location;
        this.version = version;
        this.newMentions = new HashMap<String, Set<MentionNotificationParameter>>();
        this.mentions = new HashMap<String, Set<MentionNotificationParameter>>();
        this.unmodifiableNewMentions = Collections.unmodifiableMap(this.newMentions);
        this.unmodifiableMentions = Collections.unmodifiableMap(this.mentions);
    }

    public String getAuthorReference() {
        return this.authorReference;
    }

    public EntityReference getEntityReference() {
        return this.entityReference;
    }

    public MentionLocation getLocation() {
        return this.location;
    }

    public MentionNotificationParameters addMention(String type, MentionNotificationParameter mentionedActorReference) {
        this.addToMap(type, mentionedActorReference, this.mentions);
        return this;
    }

    public MentionNotificationParameters addNewMention(String type, MentionNotificationParameter mentionedActorReference) {
        this.addToMap(type, mentionedActorReference, this.newMentions);
        return this;
    }

    public Map<String, Set<MentionNotificationParameter>> getNewMentions() {
        return this.unmodifiableNewMentions;
    }

    public Map<String, Set<MentionNotificationParameter>> getMentions() {
        return this.unmodifiableMentions;
    }

    public String getVersion() {
        return this.version;
    }

    private void addToMap(String type, MentionNotificationParameter mentionedActorReference, Map<String, Set<MentionNotificationParameter>> mentionsMap) {
        if (!mentionsMap.containsKey(type)) {
            mentionsMap.put(type, new HashSet());
        }
        mentionsMap.get(type).add(mentionedActorReference);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MentionNotificationParameters that = (MentionNotificationParameters)o;
        return new EqualsBuilder().append(this.newMentions, that.newMentions).append(this.mentions, that.mentions).append((Object)this.authorReference, (Object)that.authorReference).append((Object)this.entityReference, (Object)that.entityReference).append((Object)this.location, (Object)that.location).append((Object)this.version, (Object)that.version).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.newMentions).append(this.mentions).append((Object)this.authorReference).append((Object)this.entityReference).append((Object)this.location).append((Object)this.version).toHashCode();
    }

    public String toString() {
        return new XWikiToStringBuilder((Object)this).append("authorReference", (Object)this.getAuthorReference()).append("entityReference", (Object)this.getEntityReference()).append("version", (Object)this.getVersion()).append("location", (Object)this.getLocation()).append("mentions", this.mentions).append("newMentions", this.newMentions).build();
    }
}

