/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.thread.context;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.CloneFailedException;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextInitializer;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.mail.internal.thread.context.Copier;

@Component
@Singleton
public class ExecutionContextCopier
implements Copier<ExecutionContext> {
    @Inject
    private ExecutionContextManager executionContextManager;
    @Inject
    private Copier<XWikiContext> xwikiContextCloner;
    @Inject
    @Named(value="velocity")
    private ExecutionContextInitializer velocityExecutionContextInitializer;

    @Override
    public ExecutionContext copy(ExecutionContext originalExecutionContext) throws CloneFailedException {
        try {
            ExecutionContext clonedExecutionContext = this.executionContextManager.clone(originalExecutionContext);
            XWikiContext xwikiContext = (XWikiContext)originalExecutionContext.getProperty("xwikicontext");
            XWikiContext clonedXWikiContext = this.xwikiContextCloner.copy(xwikiContext);
            clonedExecutionContext.setProperty("xwikicontext", (Object)clonedXWikiContext);
            clonedExecutionContext.removeProperty("velocityContext");
            this.velocityExecutionContextInitializer.initialize(clonedExecutionContext);
            return clonedExecutionContext;
        }
        catch (Exception e) {
            throw new CloneFailedException(String.format("Failed to clone [%s]", originalExecutionContext), (Throwable)e);
        }
    }
}

