/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.thread;

import com.xpn.xwiki.XWikiContext;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MailContentStore;
import org.xwiki.mail.MailListener;
import org.xwiki.mail.MailStatusResult;
import org.xwiki.mail.internal.UpdateableMailStatusResult;
import org.xwiki.mail.internal.thread.AbstractMailRunnable;
import org.xwiki.mail.internal.thread.MailQueueManager;
import org.xwiki.mail.internal.thread.PrepareMailQueueItem;
import org.xwiki.mail.internal.thread.SendMailQueueItem;

@Component
@Named(value="prepare")
@Singleton
public class PrepareMailRunnable
extends AbstractMailRunnable {
    private static final int TIMEOUT = 60;
    @Inject
    private MailQueueManager<PrepareMailQueueItem> prepareMailQueueManager;
    @Inject
    private MailQueueManager<SendMailQueueItem> sendMailQueueManager;
    @Inject
    @Named(value="filesystem")
    private MailContentStore mailContentStore;

    @Override
    public void run() {
        do {
            try {
                if (this.prepareMailQueueManager.hasMessage()) {
                    PrepareMailQueueItem mailItem = this.prepareMailQueueManager.peekMessage();
                    try {
                        this.prepareMail(mailItem);
                    }
                    finally {
                        this.prepareMailQueueManager.removeMessageFromQueue(mailItem);
                    }
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.debug("Mail Prepare Thread was forcefully stopped", (Throwable)e);
                break;
            }
            catch (Exception e) {
                this.logger.error("Unexpected error in the Mail Prepare Thread", (Throwable)e);
            }
        } while (!this.shouldStop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareMail(PrepareMailQueueItem item) {
        Iterator<? extends MimeMessage> messageIterator = item.getMessages().iterator();
        MailListener listener = item.getListener();
        if (listener != null) {
            listener.onPrepareBegin(item.getBatchId(), Collections.emptyMap());
        }
        long messageCounter = 0L;
        try {
            boolean shouldStop = false;
            while (!shouldStop) {
                this.prepareContext(item.getContext());
                try {
                    if (messageIterator.hasNext()) {
                        MimeMessage mimeMessage = messageIterator.next();
                        this.prepareSingleMail(mimeMessage, item);
                        ++messageCounter;
                        continue;
                    }
                    shouldStop = true;
                }
                finally {
                    this.removeContext();
                }
            }
        }
        catch (Exception e) {
            if (listener != null) {
                listener.onPrepareFatalError(e, Collections.emptyMap());
            }
        }
        finally {
            if (listener != null) {
                MailStatusResult result = listener.getMailStatusResult();
                if (result instanceof UpdateableMailStatusResult) {
                    ((UpdateableMailStatusResult)result).setTotalSize(messageCounter);
                }
                listener.onPrepareEnd(Collections.emptyMap());
            }
        }
    }

    protected void prepareContext(ExecutionContext executionContext) throws ExecutionContextException {
        try {
            this.execution.setContext(executionContext);
        }
        catch (Exception e) {
            throw new ExecutionContextException("Failed to set the execution context.", (Throwable)e);
        }
    }

    private void prepareSingleMail(MimeMessage mimeMessage, PrepareMailQueueItem item) {
        MailListener listener = item.getListener();
        this.completeMessage(mimeMessage);
        ExtendedMimeMessage message = ExtendedMimeMessage.wrap((MimeMessage)mimeMessage);
        try {
            this.mailContentStore.save(item.getBatchId(), message);
        }
        catch (Exception e) {
            if (listener != null) {
                listener.onPrepareMessageError(message, e, Collections.emptyMap());
            }
            return;
        }
        if (listener != null) {
            listener.onPrepareMessageSuccess(message, Collections.emptyMap());
        }
        SendMailQueueItem smqi = new SendMailQueueItem(message.getUniqueMessageId(), item.getSession(), listener, item.getBatchId(), this.extractWikiId(item));
        try {
            boolean result = this.sendMailQueueManager.addMessageToQueue(smqi, 60L, TimeUnit.SECONDS);
            if (!result) {
                this.logger.warn("The following mail items couldn't be added to the send queue, which is full: [{}]. They will need to be resent later on.", (Object)smqi);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(String.format("The following mail items couldn't be added to the send queue as it was interrupted: [%s]. The messages are not lost and can be resent later on.", smqi), e);
        }
    }

    private String extractWikiId(PrepareMailQueueItem item) {
        XWikiContext xcontext = (XWikiContext)item.getContext().getProperty("xwikicontext");
        return xcontext.getWikiId();
    }

    private void completeMessage(MimeMessage mimeMessage) {
        this.tryToEnsureFrom(mimeMessage);
        this.tryToAddDefaultBccIfNeeded(mimeMessage);
    }

    private void tryToEnsureFrom(MimeMessage mimeMessage) {
        String from;
        if (this.getFrom(mimeMessage) == null && (from = this.configuration.getFromAddress()) != null) {
            try {
                mimeMessage.setFrom((Address)new InternetAddress(from));
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
    }

    private void tryToAddDefaultBccIfNeeded(MimeMessage mimeMessage) {
        Address[] bccAddresses = this.getBccRecipients(mimeMessage);
        if (bccAddresses == null || bccAddresses.length == 0) {
            for (String address : this.configuration.getBCCAddresses()) {
                try {
                    mimeMessage.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(address));
                }
                catch (MessagingException messagingException) {}
            }
        }
    }

    private Address[] getFrom(MimeMessage mimeMessage) {
        try {
            return mimeMessage.getFrom();
        }
        catch (MessagingException e) {
            return null;
        }
    }

    private Address[] getBccRecipients(MimeMessage mimeMessage) {
        try {
            return mimeMessage.getRecipients(Message.RecipientType.BCC);
        }
        catch (MessagingException e) {
            return null;
        }
    }
}

