/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.factory.usersandgroups;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.text.XWikiToStringBuilder;

public class UsersAndGroupsSource {
    private List<DocumentReference> includedUserAndGroupReferences;
    private List<DocumentReference> excludedUserAndGroupReferences;
    private List<Address> includedAddresses;
    private List<Address> excludedAdresses;

    public UsersAndGroupsSource(List<DocumentReference> includedUserAndGroupReferences, List<DocumentReference> excludedUserAndGroupReferences, List<Address> includedAddresses, List<Address> excludedAddresses) {
        this.includedUserAndGroupReferences = includedUserAndGroupReferences;
        this.excludedUserAndGroupReferences = excludedUserAndGroupReferences;
        this.includedAddresses = includedAddresses;
        this.excludedAdresses = excludedAddresses;
    }

    public List<DocumentReference> getIncludedUserAndGroupReferences() {
        return this.includedUserAndGroupReferences;
    }

    public List<DocumentReference> getExcludedUserAndGroupReferences() {
        return this.excludedUserAndGroupReferences;
    }

    public List<Address> getIncludedAddresses() {
        return this.includedAddresses;
    }

    public List<Address> getExcludedAddresses() {
        return this.excludedAdresses;
    }

    public static UsersAndGroupsSource parse(Map<String, Object> sourceMap) throws MessagingException {
        List<DocumentReference> includedUserAndGroupReferences = UsersAndGroupsSource.extractUserAndGroupReferences("users", "groups", sourceMap);
        List<DocumentReference> excludedUserAndGroupReferences = UsersAndGroupsSource.extractUserAndGroupReferences("excludedUsers", "excludedGroups", sourceMap);
        List<Address> includedAddresses = UsersAndGroupsSource.extractAddresses("emails", sourceMap);
        List<Address> excludedAddresses = UsersAndGroupsSource.extractAddresses("excludedEmails", sourceMap);
        return new UsersAndGroupsSource(includedUserAndGroupReferences, excludedUserAndGroupReferences, includedAddresses, excludedAddresses);
    }

    private static List<Address> extractAddresses(String key, Map<String, Object> sourceMap) throws MessagingException {
        List<Address> addresses;
        List emails = (List)sourceMap.get(key);
        if (emails != null) {
            addresses = new ArrayList();
            for (String email : emails) {
                addresses.add((Address)InternetAddress.parse((String)email)[0]);
            }
        } else {
            addresses = Collections.emptyList();
        }
        return addresses;
    }

    private static List<DocumentReference> extractUserAndGroupReferences(String userKey, String groupKey, Map<String, Object> sourceMap) {
        List groupReferences;
        ArrayList<DocumentReference> userAndGroupReferences = new ArrayList<DocumentReference>();
        List userReferences = (List)sourceMap.get(userKey);
        if (userReferences != null) {
            userAndGroupReferences.addAll(userReferences);
        }
        if ((groupReferences = (List)sourceMap.get(groupKey)) != null) {
            userAndGroupReferences.addAll(groupReferences);
        }
        return userAndGroupReferences;
    }

    public String toString() {
        XWikiToStringBuilder builder = new XWikiToStringBuilder((Object)this);
        builder.append("includedUserAndGroupsReferences", this.getIncludedUserAndGroupReferences());
        builder.append("excludedUserAndGroupsReferences", this.getExcludedUserAndGroupReferences());
        builder.append("includedAddresses", this.getIncludedAddresses());
        builder.append("excludedAddresses", this.getExcludedAddresses());
        return builder.toString();
    }
}

