/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.factory.text;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.xwiki.component.annotation.Component;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MimeBodyPartFactory;
import org.xwiki.mail.internal.factory.AbstractMimeMessageFactory;
import org.xwiki.properties.ConverterManager;

@Component
@Singleton
@Named(value="text")
public class TextMimeMessageFactory
extends AbstractMimeMessageFactory<MimeMessage> {
    @Inject
    private ConverterManager converterManager;
    @Inject
    private MimeBodyPartFactory<String> mimeBodyPartFactory;

    public MimeMessage createMessage(Object source, Map<String, Object> parameters) throws MessagingException {
        ExtendedMimeMessage message = new ExtendedMimeMessage();
        Address from = (Address)this.converterManager.convert(Address.class, parameters.get("from"));
        if (from != null) {
            message.setFrom(from);
        }
        this.setRecipient((MimeMessage)message, Message.RecipientType.TO, parameters.get("to"));
        this.setRecipient((MimeMessage)message, Message.RecipientType.CC, parameters.get("cc"));
        this.setRecipient((MimeMessage)message, Message.RecipientType.BCC, parameters.get("bcc"));
        String type = (String)parameters.get("type");
        if (type != null) {
            message.setType(type);
        }
        String subject = (String)parameters.get("subject");
        message.setSubject(subject);
        MimeMultipart multipart = new MimeMultipart("mixed");
        multipart.addBodyPart((BodyPart)this.mimeBodyPartFactory.create((Object)((String)source), parameters));
        message.setContent((Multipart)multipart);
        return message;
    }

    private void setRecipient(MimeMessage message, Message.RecipientType type, Object value) throws MessagingException {
        Address[] addresses = (Address[])this.converterManager.convert(Address[].class, value);
        if (addresses != null) {
            message.setRecipients(type, addresses);
        }
    }
}

