/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.factory;

import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.mail.MimeMessageFactory;
import org.xwiki.mail.internal.factory.AbstractMimeMessageFactory;

public abstract class AbstractIteratorMimeMessageFactory
extends AbstractMimeMessageFactory<Iterator<MimeMessage>> {
    @Inject
    @Named(value="context")
    protected Provider<ComponentManager> componentManagerProvider;

    protected MimeMessageFactory getInternalMimeMessageFactory(String hint) throws MessagingException {
        try {
            return (MimeMessageFactory)((ComponentManager)this.componentManagerProvider.get()).getInstance((Type)new DefaultParameterizedType(null, MimeMessageFactory.class, new Type[]{MimeMessage.class}), hint);
        }
        catch (ComponentLookupException e) {
            throw new MessagingException(String.format("Failed to find a [%s<MimeMessage>] for hint [%s]", MimeMessageFactory.class.getSimpleName(), hint));
        }
    }

    protected void validateParameters(Map<String, Object> parameters, String ... names) throws MessagingException {
        if (parameters == null) {
            throw new MessagingException("You must pass parameters for this Mime Message Factory to work!");
        }
        for (String name : names) {
            Object parameterValue = parameters.get(name);
            if (parameterValue != null) continue;
            throw new MessagingException(String.format("The parameter [%s] is mandatory.", name));
        }
    }
}

