/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.configuration;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.mail.MailSenderConfiguration;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultMailSenderConfiguration
implements MailSenderConfiguration {
    public static final String JAVAMAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String JAVAMAIL_SMTP_HOST = "mail.smtp.host";
    public static final String JAVAMAIL_SMTP_PORT = "mail.smtp.port";
    public static final String JAVAMAIL_SMTP_USERNAME = "mail.smtp.user";
    public static final String JAVAMAIL_SMTP_AUTH = "mail.smtp.auth";
    private static final String PREFIX = "mail.sender.";
    private static final int DEFAULT_PORT = 25;
    private static final long DEFAULT_SEND_WAIT_TIME = 8000L;
    private static final String FROM_PROPERTY = "from";
    private static final String BCC_PROPERTY = "bcc";
    private static final String HOST_PROPERTY = "host";
    private static final String PORT_PROPERTY = "port";
    private static final String USERNAME_PROPERTY = "username";
    private static final String PASSWORD_PROPERTY = "password";
    private static final String PROPERTIES_PROPERTY = "properties";
    private static final String SEND_WAIT_TIME = "sendWaitTime";
    private static final String PREPARE_QUEUE_CAPACITY_PROPERTY = "prepareQueueCapacity";
    private static final String SEND_QUEUE_CAPACITY_PROPERTY = "sendQueueCapacity";
    private static final int PREPARE_QUEUE_CAPACITY_DEFAULT = 1000;
    private static final int SEND_QUEUE_CAPACITY_DEFAULT = 1000;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="mailsend")
    private ConfigurationSource currentWikiMailConfigSource;
    @Inject
    @Named(value="mailsendmainwiki")
    private ConfigurationSource mainWikiMailConfigSource;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource xwikiPropertiesSource;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public String getHost() {
        String host = (String)this.currentWikiMailConfigSource.getProperty(HOST_PROPERTY, String.class);
        if (host == null && !this.isMainWiki()) {
            host = (String)this.mainWikiMailConfigSource.getProperty(HOST_PROPERTY, String.class);
        }
        if (host == null) {
            host = (String)this.xwikiPropertiesSource.getProperty("mail.sender.host", (Object)"localhost");
        }
        return host;
    }

    public int getPort() {
        Integer port = (Integer)this.currentWikiMailConfigSource.getProperty(PORT_PROPERTY, Integer.class);
        if (port == null && !this.isMainWiki()) {
            port = (Integer)this.mainWikiMailConfigSource.getProperty(PORT_PROPERTY, Integer.class);
        }
        if (port == null) {
            port = (Integer)this.xwikiPropertiesSource.getProperty("mail.sender.port", (Object)25);
        }
        return port;
    }

    public String getUsername() {
        String username = (String)this.currentWikiMailConfigSource.getProperty(USERNAME_PROPERTY, String.class);
        String currentHost = (String)this.currentWikiMailConfigSource.getProperty(HOST_PROPERTY, String.class);
        if (username == null && !this.isMainWiki() && currentHost == null) {
            username = (String)this.mainWikiMailConfigSource.getProperty(USERNAME_PROPERTY, String.class);
        }
        if (username == null && (!this.isMainWiki() && currentHost == null || this.isMainWiki())) {
            username = (String)this.xwikiPropertiesSource.getProperty("mail.sender.username", String.class);
        }
        return username;
    }

    public String getPassword() {
        String password = (String)this.currentWikiMailConfigSource.getProperty(PASSWORD_PROPERTY, String.class);
        String currentHost = (String)this.currentWikiMailConfigSource.getProperty(HOST_PROPERTY, String.class);
        if (password == null && !this.isMainWiki() && currentHost == null) {
            password = (String)this.mainWikiMailConfigSource.getProperty(PASSWORD_PROPERTY, String.class);
        }
        if (password == null && (!this.isMainWiki() && currentHost == null || this.isMainWiki())) {
            password = (String)this.xwikiPropertiesSource.getProperty("mail.sender.password", String.class);
        }
        return password;
    }

    public List<String> getBCCAddresses() {
        ArrayList<String> bccAddresses = new ArrayList<String>();
        String bccAsString = (String)this.currentWikiMailConfigSource.getProperty(BCC_PROPERTY, String.class);
        if (bccAsString == null && !this.isMainWiki()) {
            bccAsString = (String)this.mainWikiMailConfigSource.getProperty(BCC_PROPERTY, String.class);
        }
        if (bccAsString == null) {
            bccAsString = (String)this.xwikiPropertiesSource.getProperty("mail.sender.bcc", String.class);
        }
        if (bccAsString != null) {
            for (String address : StringUtils.split((String)bccAsString, (char)',')) {
                bccAddresses.add(StringUtils.trim((String)address));
            }
        }
        return bccAddresses;
    }

    public String getFromAddress() {
        String from = (String)this.currentWikiMailConfigSource.getProperty(FROM_PROPERTY, String.class);
        if (from == null && !this.isMainWiki()) {
            from = (String)this.mainWikiMailConfigSource.getProperty(FROM_PROPERTY, String.class);
        }
        if (from == null) {
            from = (String)this.xwikiPropertiesSource.getProperty("mail.sender.from", String.class);
        }
        return from;
    }

    public Properties getAdditionalProperties() {
        Properties properties;
        String extraPropertiesAsString = (String)this.currentWikiMailConfigSource.getProperty(PROPERTIES_PROPERTY, String.class);
        if (extraPropertiesAsString == null && !this.isMainWiki()) {
            extraPropertiesAsString = (String)this.mainWikiMailConfigSource.getProperty(PROPERTIES_PROPERTY, String.class);
        }
        if (extraPropertiesAsString == null) {
            properties = (Properties)this.xwikiPropertiesSource.getProperty("mail.sender.properties", Properties.class);
        } else {
            ByteArrayInputStream is = new ByteArrayInputStream(extraPropertiesAsString.getBytes());
            properties = new Properties();
            try {
                properties.load(is);
            }
            catch (Exception e) {
                this.logger.warn("Error while parsing mail properties [{}]. Root cause [{}]. Ignoring configuration...", (Object)extraPropertiesAsString, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return properties;
    }

    public Properties getAllProperties() {
        Properties properties = new Properties();
        this.addProperty(properties, JAVAMAIL_TRANSPORT_PROTOCOL, "smtp");
        this.addProperty(properties, JAVAMAIL_SMTP_HOST, this.getHost());
        this.addProperty(properties, JAVAMAIL_SMTP_USERNAME, this.getUsername());
        this.addProperty(properties, JAVAMAIL_SMTP_PORT, Integer.toString(this.getPort()));
        if (this.usesAuthentication()) {
            properties.put(JAVAMAIL_SMTP_AUTH, "true");
        }
        properties.putAll((Map<?, ?>)this.getAdditionalProperties());
        return properties;
    }

    private void addProperty(Properties properties, String key, String value) {
        if (value != null) {
            properties.setProperty(key, value);
        }
    }

    public boolean usesAuthentication() {
        return !StringUtils.isEmpty((CharSequence)this.getUsername()) && !StringUtils.isEmpty((CharSequence)this.getPassword());
    }

    public String getScriptServicePermissionCheckerHint() {
        return (String)this.xwikiPropertiesSource.getProperty("mail.sender.scriptServiceCheckerHint", (Object)"programmingrights");
    }

    public long getSendWaitTime() {
        Long waitTime = (Long)this.currentWikiMailConfigSource.getProperty(SEND_WAIT_TIME);
        if (waitTime == null) {
            waitTime = (Long)this.xwikiPropertiesSource.getProperty("mail.sender.sendWaitTime", (Object)8000L);
        }
        return waitTime;
    }

    public int getPrepareQueueCapacity() {
        return (Integer)this.xwikiPropertiesSource.getProperty("mail.sender.prepareQueueCapacity", (Object)1000);
    }

    public int getSendQueueCapacity() {
        return (Integer)this.xwikiPropertiesSource.getProperty("mail.sender.sendQueueCapacity", (Object)1000);
    }

    private boolean isMainWiki() {
        return this.wikiDescriptorManager.isMainWiki(this.wikiDescriptorManager.getCurrentWikiId());
    }
}

