/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.configuration;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XObjectAddedEvent;
import com.xpn.xwiki.internal.event.XObjectDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectUpdatedEvent;
import com.xpn.xwiki.objects.BaseObjectReference;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.mail.GeneralMailConfigurationUpdatedEvent;
import org.xwiki.mail.internal.configuration.AbstractGeneralMailConfigClassDocumentConfigurationSource;
import org.xwiki.mail.internal.configuration.AbstractMailConfigClassDocumentConfigurationSource;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.RegexEntityReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@Named(value="generalmailconfigurationchangedeventgenerator")
@Singleton
public class GeneralMailConfigurationUpdatedEventGenerator
implements EventListener {
    static final String NAME = "generalmailconfigurationchangedeventgenerator";
    @Inject
    protected EntityReferenceSerializer<String> referenceSerializer;
    @Inject
    private Provider<ObservationManager> observationManagerProvider;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="mailgeneral")
    private ConfigurationSource currentWikiMailConfigSource;
    @Inject
    @Named(value="mailgeneralmainwiki")
    private ConfigurationSource mainWikiMailConfigSource;

    public String getName() {
        return NAME;
    }

    public List<Event> getEvents() {
        String serializedClassReference = (String)this.referenceSerializer.serialize((EntityReference)AbstractGeneralMailConfigClassDocumentConfigurationSource.GENERAL_MAILCONFIGCLASS_REFERENCE, new Object[0]);
        RegexEntityReference filter = BaseObjectReference.any((String)serializedClassReference);
        return List.of(new XObjectAddedEvent((EntityReference)filter), new XObjectDeletedEvent((EntityReference)filter), new XObjectUpdatedEvent((EntityReference)filter));
    }

    public void onEvent(Event event, Object source, Object data) {
        ObservationManager observationManager = (ObservationManager)this.observationManagerProvider.get();
        if (source instanceof XWikiDocument) {
            XWikiDocument document = (XWikiDocument)source;
            LocalDocumentReference localDocumentReference = new LocalDocumentReference(document.getDocumentReference());
            if (!AbstractMailConfigClassDocumentConfigurationSource.MAILCONFIG_REFERENCE.equals((Object)localDocumentReference)) {
                return;
            }
            this.clearCache(this.currentWikiMailConfigSource);
            String wikiId = document.getDocumentReference().getWikiReference().getName();
            if (((XWikiContext)this.contextProvider.get()).isMainWiki(wikiId)) {
                this.clearCache(this.mainWikiMailConfigSource);
                observationManager.notify((Event)new GeneralMailConfigurationUpdatedEvent(), null);
            } else {
                observationManager.notify((Event)new GeneralMailConfigurationUpdatedEvent(wikiId), (Object)wikiId);
            }
        }
    }

    private void clearCache(ConfigurationSource mainWikiMailConfigSource) {
        if (mainWikiMailConfigSource instanceof AbstractGeneralMailConfigClassDocumentConfigurationSource) {
            ((AbstractGeneralMailConfigClassDocumentConfigurationSource)mainWikiMailConfigSource).clearCache();
        }
    }
}

