/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.configuration;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.mail.GeneralMailConfiguration;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultGeneralMailConfiguration
implements GeneralMailConfiguration {
    private static final String OBFUSCATE_EMAIL_ADDRESSES = "obfuscate";
    private static final boolean DEFAULT_OBFUSCATE_EMAIL_ADDRESSES = false;
    private static final String PREFIX = "mail.general.";
    @Inject
    @Named(value="mailgeneral")
    private ConfigurationSource currentWikiMailConfigSource;
    @Inject
    @Named(value="mailgeneralmainwiki")
    private ConfigurationSource mainWikiMailConfigSource;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource xwikiPropertiesSource;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public boolean shouldObfuscate() {
        Boolean obfuscateEmailAddresses = (Boolean)this.currentWikiMailConfigSource.getProperty(OBFUSCATE_EMAIL_ADDRESSES, Boolean.class);
        if (obfuscateEmailAddresses == null && !this.isMainWiki()) {
            obfuscateEmailAddresses = (Boolean)this.mainWikiMailConfigSource.getProperty(OBFUSCATE_EMAIL_ADDRESSES, Boolean.class);
        }
        if (obfuscateEmailAddresses == null) {
            obfuscateEmailAddresses = (Boolean)this.xwikiPropertiesSource.getProperty("mail.general.obfuscate", (Object)false);
        }
        return obfuscateEmailAddresses;
    }

    private boolean isMainWiki() {
        return this.wikiDescriptorManager.isMainWiki(this.wikiDescriptorManager.getCurrentWikiId());
    }
}

