/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

public abstract class AbstractAddressConverter<T extends Address>
extends AbstractConverter<T> {
    protected Address convertToType(Type targetType, Object value) {
        InternetAddress address;
        if (value == null) {
            return null;
        }
        try {
            address = InternetAddress.parse((String)value.toString())[0];
        }
        catch (AddressException e) {
            throw new ConversionException(String.format("Failed to convert [%s] to [%s]", value, targetType.getTypeName()), (Throwable)e);
        }
        return address;
    }

    protected String convertToString(T value) {
        Address[] array = (Address[])Array.newInstance(value.getClass(), 1);
        array[0] = value;
        return InternetAddress.toString((Address[])array);
    }
}

