/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.script;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.localization.Translation;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.LogTree;
import org.xwiki.logging.LogUtils;
import org.xwiki.logging.LoggerConfiguration;
import org.xwiki.logging.LoggerManager;
import org.xwiki.logging.Message;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="logging")
@Singleton
public class LoggingScriptService
implements ScriptService {
    @Inject
    private LoggerManager loggerManager;
    @Inject
    private LoggerConfiguration loggerConfiguration;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private ContextualLocalizationManager localization;

    public Logger getLogger(String name) {
        return LoggerFactory.getLogger((String)name);
    }

    public Map<String, LogLevel> getLevels() {
        Collection registeredLoggers = this.loggerManager.getLoggers();
        HashMap<String, LogLevel> levels = new HashMap<String, LogLevel>(registeredLoggers.size());
        for (Logger registeredLogger : registeredLoggers) {
            levels.put(registeredLogger.getName(), this.getLevel(registeredLogger.getName()));
        }
        return levels;
    }

    public LogLevel getLevel(String loggerName) {
        return this.loggerManager.getLoggerLevel(loggerName);
    }

    public void setLevel(String logger, LogLevel level) {
        if (!this.authorization.hasAccess(Right.PROGRAM)) {
            return;
        }
        this.loggerManager.setLoggerLevel(logger, level);
    }

    public LogTree toLogTree(Iterable<LogEvent> logs) {
        LogTree logTree = new LogTree();
        for (LogEvent logEvent : logs) {
            logTree.log(logEvent);
        }
        return logTree;
    }

    public LogEvent translate(LogEvent logEvent) {
        return (LogEvent)this.translate((Message)logEvent);
    }

    public Message translate(Message message) {
        Translation translation;
        String translationKey;
        if (message != null && (translationKey = message.getTranslationKey()) != null && (translation = this.localization.getTranslation(message.getTranslationKey())) != null) {
            return LogUtils.translate((Message)message, (String)((String)translation.getRawSource()), (String)"messagetool/1.0");
        }
        return message;
    }

    public void deprecate(String loggerName, String message) {
        if (this.loggerConfiguration.isDeprecatedLogEnabled()) {
            this.getLogger(loggerName).warn("[DEPRECATED] " + message);
        }
    }
}

