/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.wiki.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.wiki.internal.WikiTranslationConfiguration;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.display.BlockSupplierProvider;

@Component
@Singleton
@Named(value="XWiki.TranslationDocumentClass")
public class TranslationDocumentObjectRequiredRightAnalyzer
implements RequiredRightAnalyzer<BaseObject> {
    @Inject
    @Named(value="translation")
    private BlockSupplierProvider<String> translationMessageSupplierProvider;
    @Inject
    private BlockSupplierProvider<BaseObject> xObjectDisplayerProvider;
    @Inject
    @Named(value="stringCode")
    private BlockSupplierProvider<String> stringCodeBlockSupplierProvider;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private WikiTranslationConfiguration configuration;

    public List<RequiredRightAnalysisResult> analyze(BaseObject object) {
        String translationKey;
        RequiredRight requiredRight;
        String scope;
        switch (scope = object.getStringValue("scope")) {
            case "GLOBAL": {
                requiredRight = RequiredRight.PROGRAM;
                translationKey = "localization.requiredrights.translationDocument.global";
                break;
            }
            case "WIKI": {
                requiredRight = RequiredRight.WIKI_ADMIN;
                translationKey = "localization.requiredrights.translationDocument.wiki";
                break;
            }
            case "USER": {
                if (this.configuration.isRestrictUserTranslations()) {
                    requiredRight = RequiredRight.SCRIPT;
                    translationKey = "localization.requiredrights.translationDocument.user";
                    break;
                }
                return List.of();
            }
            default: {
                return List.of();
            }
        }
        XWikiDocument document = ((XWikiContext)this.contextProvider.get()).getDoc();
        return List.of(new RequiredRightAnalysisResult(object.getReference(), this.translationMessageSupplierProvider.get((Object)translationKey, new Object[0]), this.xObjectDisplayerProvider.get((Object)object, new Object[0]), List.of(requiredRight)), new RequiredRightAnalysisResult((EntityReference)document.getDocumentReference(), this.translationMessageSupplierProvider.get((Object)(translationKey + ".content"), new Object[0]), this.stringCodeBlockSupplierProvider.get((Object)document.getContent(), new Object[0]), List.of(requiredRight)));
    }
}

