/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.script;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.localization.LocalizationContext;
import org.xwiki.localization.LocalizationException;
import org.xwiki.localization.LocalizationManager;
import org.xwiki.localization.Translation;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.script.service.ScriptService;
import org.xwiki.text.StringUtils;

@Component
@Named(value="localization")
@Singleton
public class LocalizationScriptService
implements ScriptService {
    @Inject
    private LocalizationManager localization;
    @Inject
    private LocalizationContext localizationContext;
    @Inject
    private Environment environment;
    @Inject
    private Logger logger;

    public Translation get(String key) {
        return this.get(key, this.localizationContext.getCurrentLocale());
    }

    public Translation get(String key, Locale locale) {
        return this.localization.getTranslation(key, locale);
    }

    public boolean use(String bundleType, String bundleId) {
        try {
            this.localization.use(bundleType, bundleId);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Locale getCurrentLocale() {
        return this.localizationContext.getCurrentLocale();
    }

    public Locale getDefaultLocale() {
        return this.localization.getDefaultLocale();
    }

    public Locale toLocale(String str) {
        try {
            return LocaleUtils.toLocale((String)str);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String render(String key) {
        return this.render(key, (Collection)null);
    }

    public String render(Collection<String> keys) {
        return this.render(keys, (Collection)null);
    }

    public String render(String key, Locale locale) {
        return this.render(key, (Collection)null, locale);
    }

    public String render(Collection<String> keys, Locale locale) {
        return this.render(keys, (Collection)null, locale);
    }

    public String render(String key, Collection<?> parameters) {
        return this.render(key, Syntax.PLAIN_1_0, parameters);
    }

    public String render(Collection<String> keys, Collection<?> parameters) {
        return this.render(keys, Syntax.PLAIN_1_0, parameters);
    }

    public String render(String key, Collection<?> parameters, Locale locale) {
        return this.render(key, Syntax.PLAIN_1_0, parameters, locale);
    }

    public String render(Collection<String> keys, Collection<?> parameters, Locale locale) {
        return this.render(keys, Syntax.PLAIN_1_0, parameters, locale);
    }

    public String render(String key, Syntax syntax) {
        return this.render(key, syntax, (Collection)null);
    }

    public String render(Collection<String> keys, Syntax syntax) {
        return this.render(keys, syntax, (Collection)null);
    }

    public String render(String key, Syntax syntax, Locale locale) {
        return this.render(key, syntax, (Collection)null, locale);
    }

    public String render(Collection<String> keys, Syntax syntax, Locale locale) {
        return this.render(keys, syntax, (Collection)null, locale);
    }

    public String render(String key, Syntax syntax, Collection<?> parameters) {
        return this.render(key, syntax, parameters, this.localizationContext.getCurrentLocale());
    }

    public String render(Collection<String> keys, Syntax syntax, Collection<?> parameters) {
        return this.render(keys, syntax, parameters, this.localizationContext.getCurrentLocale());
    }

    public String render(String key, Syntax syntax, Collection<?> parameters, Locale locale) {
        return this.render(Collections.singletonList(key), syntax, parameters, locale);
    }

    public String render(Collection<String> keys, Syntax syntax, Collection<?> parameters, Locale locale) {
        String result;
        if (CollectionUtils.isEmpty(keys)) {
            return null;
        }
        String translation = null;
        for (String key : keys) {
            if (key != null && (translation = this.getTranslation(key, syntax, parameters, locale)) != null) break;
        }
        if (translation != null) {
            result = translation;
        } else {
            result = null;
            for (String key : keys) {
                if (key == null) continue;
                result = key;
            }
        }
        return result;
    }

    public Set<Locale> getAvailableLocales() {
        HashSet<Locale> locales = new HashSet<Locale>(LocaleUtils.availableLocaleSet());
        try (InputStream resource = this.environment.getResourceAsStream("/WEB-INF/xwiki-locales.txt");){
            LineIterator iterator = IOUtils.lineIterator((InputStream)resource, (Charset)StandardCharsets.US_ASCII);
            while (iterator.hasNext()) {
                String line = iterator.nextLine();
                if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                locales.add(LocaleUtils.toLocale((String)line));
            }
            iterator.close();
        }
        catch (Exception e) {
            this.logger.warn("Exception while looking for XWiki Locales.", (Throwable)e);
        }
        return locales;
    }

    private String getTranslation(String key, Syntax syntax, Collection<?> parameters, Locale locale) {
        String result;
        try {
            result = parameters == null ? this.localization.getTranslation(key, locale, syntax, new Object[0]) : this.localization.getTranslation(key, locale, syntax, parameters.toArray());
        }
        catch (LocalizationException e) {
            result = null;
        }
        return result;
    }
}

