/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.internal;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.LocaleUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.LocalizationContext;
import org.xwiki.localization.LocalizationManager;
import org.xwiki.localization.Translation;
import org.xwiki.localization.rest.TranslationsResource;
import org.xwiki.localization.rest.model.jaxb.ObjectFactory;
import org.xwiki.localization.rest.model.jaxb.Translations;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.rest.XWikiRestComponent;

@Component
@Named(value="org.xwiki.localization.internal.DefaultTranslationsResource")
@Singleton
public class DefaultTranslationsResource
implements TranslationsResource,
XWikiRestComponent {
    @Inject
    private LocalizationContext localizationContext;
    @Inject
    private LocalizationManager localizationManager;
    @Inject
    private ModelContext modelContext;
    @Inject
    private Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Translations getTranslations(String wikiId, String localeString, String prefix, List<String> keys) {
        EntityReference oldEntityReference = this.modelContext.getCurrentEntityReference();
        try {
            this.modelContext.setCurrentEntityReference((EntityReference)new WikiReference(wikiId));
            Locale locale = localeString != null ? LocaleUtils.toLocale((String)localeString) : this.localizationContext.getCurrentLocale();
            String cleanPrefix = Objects.toString(prefix, "");
            ObjectFactory objectFactory = new ObjectFactory();
            Translations result = objectFactory.createTranslations();
            for (String key : keys) {
                if (key == null) continue;
                String fullKey = cleanPrefix + key;
                Translation translation = this.localizationManager.getTranslation(fullKey, locale);
                if (translation != null) {
                    String rawSource = (String)translation.getRawSource();
                    result.getTranslations().add(this.createTranslation(objectFactory, fullKey, rawSource));
                    continue;
                }
                result.getTranslations().add(this.createTranslation(objectFactory, fullKey, null));
                this.logger.warn("Translation key [{}] not found for locale [{}] in wiki [{}].", new Object[]{fullKey, locale, wikiId});
            }
            Translations translations = result;
            return translations;
        }
        finally {
            this.modelContext.setCurrentEntityReference(oldEntityReference);
        }
    }

    private org.xwiki.localization.rest.model.jaxb.Translation createTranslation(ObjectFactory objectFactory, String key, String rawSource) {
        org.xwiki.localization.rest.model.jaxb.Translation translation = objectFactory.createTranslation();
        translation.setKey(key);
        translation.setRawSource(rawSource);
        return translation;
    }
}

