/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.macro.internal;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.LocalizationContext;
import org.xwiki.localization.LocalizationManager;
import org.xwiki.localization.Translation;
import org.xwiki.localization.macro.TranslationMacroParameters;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.MacroPreparationException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.util.ParserUtils;

@Component
@Named(value="translation")
@Singleton
public class TranslationMacro
extends AbstractMacro<TranslationMacroParameters> {
    private static final String DESCRIPTION = "Display a translation message.";
    private static final String CONTENT_DESCRIPTION = "the default translation message";
    private static final ParserUtils PARSERUTILS = new ParserUtils();
    @Inject
    private LocalizationManager localization;
    @Inject
    private LocalizationContext localizationContext;
    @Inject
    private MacroContentParser macroContentParser;
    @Inject
    @Named(value="plain/1.0")
    private Parser plainParser;

    public TranslationMacro() {
        super("Translation", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), TranslationMacroParameters.class);
        this.setDefaultCategories(Set.of("Content"));
    }

    public List<Block> execute(TranslationMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List<Object> blocks;
        Locale locale = parameters.getLocale() != null ? parameters.getLocale() : this.localizationContext.getCurrentLocale();
        Translation translation = this.localization.getTranslation(parameters.getKey(), locale);
        if (translation != null) {
            Block block = parameters.getParameters() != null ? translation.render(locale, (Object[])parameters.getParameters()) : translation.render(locale, new Object[0]);
            blocks = block instanceof CompositeBlock ? block.getChildren() : Arrays.asList(block);
            if (!context.getCurrentMacroBlock().isInline()) {
                blocks = Arrays.asList(new GroupBlock(blocks));
            }
        } else if (content != null) {
            blocks = this.macroContentParser.parse(content, context, false, context.getCurrentMacroBlock().isInline()).getChildren();
        } else {
            try {
                blocks = this.plainParser.parse((Reader)new StringReader(parameters.getKey())).getChildren();
                if (context.getCurrentMacroBlock().isInline()) {
                    PARSERUTILS.removeTopLevelParagraph(blocks);
                }
            }
            catch (ParseException e) {
                throw new MacroExecutionException("Failed to parse key [" + parameters.getKey() + "]", (Throwable)e);
            }
        }
        return blocks;
    }

    public void prepare(MacroBlock macroBlock) throws MacroPreparationException {
        this.macroContentParser.prepareContentWiki(macroBlock);
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public boolean isExecutionIsolated(TranslationMacroParameters parameters, String content) {
        return true;
    }
}

