/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.internal;

import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.localization.LocalizationException;
import org.xwiki.localization.LocalizationManager;
import org.xwiki.localization.Translation;
import org.xwiki.localization.TranslationBundle;
import org.xwiki.localization.TranslationBundleContext;
import org.xwiki.localization.TranslationBundleDoesNotExistsException;
import org.xwiki.localization.TranslationBundleFactory;
import org.xwiki.localization.TranslationBundleFactoryDoesNotExistsException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Singleton
public class DefaultLocalizationManager
implements LocalizationManager {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private TranslationBundleContext bundleContext;
    @Inject
    private Logger logger;

    @Override
    public Translation getTranslation(String key, Locale locale) {
        for (TranslationBundle bundle : this.bundleContext.getBundles()) {
            try {
                Translation translation = bundle.getTranslation(key, locale);
                if (translation == null || !translation.getLocale().equals(locale)) continue;
                return translation;
            }
            catch (Exception e) {
                this.logger.error("Failed to get translation", (Throwable)e);
            }
        }
        Locale parentLocale = LocaleUtils.getParentLocale(locale);
        if (parentLocale != null) {
            return this.getTranslation(key, parentLocale);
        }
        return null;
    }

    @Override
    public String getTranslationPlain(String key, Locale locale, Object ... parameters) {
        String result;
        try {
            result = this.getTranslation(key, locale, Syntax.PLAIN_1_0, parameters);
        }
        catch (LocalizationException e) {
            result = null;
        }
        return result;
    }

    @Override
    public String getTranslation(String key, Locale locale, Syntax targetSyntax, Object ... parameters) throws LocalizationException {
        String result;
        Translation translation = this.getTranslation(key, locale);
        if (translation == null) {
            result = null;
        } else {
            Block block = translation.render(parameters);
            DefaultWikiPrinter wikiPrinter = new DefaultWikiPrinter();
            BlockRenderer renderer = this.getSyntaxRenderer(targetSyntax);
            renderer.render(block, (WikiPrinter)wikiPrinter);
            result = wikiPrinter.toString();
        }
        return result;
    }

    @Override
    public TranslationBundle getTranslationBundle(String bundleType, String bundleId) throws TranslationBundleDoesNotExistsException, TranslationBundleFactoryDoesNotExistsException {
        TranslationBundleFactory bundleFactory;
        if (((ComponentManager)this.componentManagerProvider.get()).hasComponent(TranslationBundle.class, bundleType + ":" + bundleId)) {
            try {
                return (TranslationBundle)((ComponentManager)this.componentManagerProvider.get()).getInstance(TranslationBundle.class, bundleType + ":" + bundleId);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to lookup component", (Throwable)e);
            }
        }
        try {
            bundleFactory = (TranslationBundleFactory)((ComponentManager)this.componentManagerProvider.get()).getInstance(TranslationBundleFactory.class, bundleType);
        }
        catch (ComponentLookupException e) {
            throw new TranslationBundleFactoryDoesNotExistsException(String.format("Failed to lookup BundleFactory for type [%s]", bundleType), e);
        }
        return bundleFactory.getBundle(bundleId);
    }

    @Override
    public void use(String bundleType, String bundleId) throws TranslationBundleDoesNotExistsException, TranslationBundleFactoryDoesNotExistsException {
        TranslationBundle bundle = this.getTranslationBundle(bundleType, bundleId);
        this.bundleContext.addBundle(bundle);
    }

    @Override
    public Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    private BlockRenderer getSyntaxRenderer(Syntax syntax) throws LocalizationException {
        BlockRenderer result;
        try {
            result = (BlockRenderer)((ComponentManager)this.componentManagerProvider.get()).getInstance(BlockRenderer.class, syntax.toIdString());
        }
        catch (ComponentLookupException e) {
            throw new LocalizationException(String.format("Failed to render the translation using the [%s] syntax", syntax), e);
        }
        return result;
    }
}

