import { resolveComponent as R, withDirectives as Q, createElementBlock as x, openBlock as A, createElementVNode as O, createCommentVNode as K, renderSlot as fn, createBlock as G, createVNode as k, vShow as J, withCtx as N, withModifiers as de, toDisplayString as C, createTextVNode as ee, Fragment as re, renderList as te, normalizeClass as Lo, resolveDynamicComponent as Za, markRaw as xo, KeepAlive as Co, reactive as Z, ref as pn, createApp as Fo } from "vue";
import { _ as X, X as ne, c as Qa } from "./main-CkFK4rnR.js";
import { d as Jt } from "./vuedraggable-CK8z7qA8.js";
import { X as en } from "./XWikiDraggableItem-CDX0sDyH.js";
import { L as Mo } from "./LivedataFilter-CokHnDEB.js";
import { l as Do } from "./require-Dl4qyrU9.js";
import { createI18n as jo } from "vue-i18n";
const ko = {
  name: "LivedataBaseAdvancedPanel",
  components: { XWikiIcon: ne },
  inject: ["logic"],
  props: {
    // The panel id is used to open the panel in the dropdown menu
    // and is used as item in the `Logic.openedPanels` array
    panelId: String
  },
  data() {
    return {
      // whether the panel is collapsed (panel body is hidden) or not
      // A panel will always be expanded when opened.
      collapsed: !1
    };
  },
  computed: {
    data() {
      return this.logic.data;
    },
    // returns whether the panel is opened based on the `Logic.openedPanels` array
    panelOpened() {
      return this.logic.uniqueArrayHas(this.logic.openedPanels, this.panelId);
    }
  },
  watch: {
    // whenever panel is opened, ensure it is not collapsed
    panelOpened() {
      this.panelOpened && (this.collapsed = !1);
    }
  }
}, Bo = { class: "livedata-advanced-panel panel panel-default" }, No = { class: "panel-heading" }, Ho = { class: "title" }, Go = { class: "actions" }, Xo = {
  key: 0,
  class: "panel-body"
};
function Uo(t, e, r, n, i, a) {
  const o = R("XWikiIcon");
  return Q((A(), x("div", Bo, [
    O("div", No, [
      O("span", Ho, [
        fn(t.$slots, "header")
      ]),
      O("div", Go, [
        O("span", {
          class: "action collapse-button",
          onClick: e[0] || (e[0] = (u) => i.collapsed = !i.collapsed)
        }, [
          i.collapsed ? (A(), G(o, {
            key: 1,
            "icon-descriptor": { name: "arrow_out" }
          })) : (A(), G(o, {
            key: 0,
            "icon-descriptor": { name: "arrow_in" }
          }))
        ]),
        O("span", {
          class: "action close-button",
          onClick: e[1] || (e[1] = (u) => a.logic.uniqueArrayRemove(a.logic.openedPanels, r.panelId))
        }, [
          k(o, { "icon-descriptor": { name: "cross" } })
        ])
      ])
    ]),
    i.collapsed ? K("", !0) : (A(), x("div", Xo, [
      fn(t.$slots, "body")
    ]))
  ], 512)), [
    [J, a.panelOpened]
  ]);
}
const Ee = /* @__PURE__ */ X(ko, [["render", Uo]]), $o = {
  name: "LivedataAdvancedPanelProperties",
  components: {
    XWikiIcon: ne,
    LivedataBaseAdvancedPanel: Ee,
    draggable: Jt,
    XWikiDraggableItem: en
  },
  inject: ["logic"],
  props: { panel: Object },
  computed: {
    data() {
      return this.logic.data;
    },
    properties() {
      return this.logic.getPropertyDescriptors();
    }
  },
  methods: {
    // event handler called when properties are dragged and dropped
    reorderProperty(t) {
      this.logic.reorderProperty(t.moved.oldIndex, t.moved.newIndex);
    }
  }
}, Wo = ["checked", "onChange"], Ko = { class: "property-name" };
function zo(t, e, r, n, i, a) {
  const o = R("XWikiIcon"), u = R("XWikiDraggableItem"), s = R("draggable"), c = R("LivedataBaseAdvancedPanel");
  return A(), G(c, {
    class: "livedata-advanced-panel-properties",
    "panel-id": r.panel.id
  }, {
    header: N(() => [
      k(o, {
        "icon-descriptor": { name: r.panel.icon }
      }, null, 8, ["icon-descriptor"]),
      ee(" " + C(r.panel.title), 1)
    ]),
    body: N(() => [
      k(s, {
        class: "draggable-container",
        list: a.properties,
        "item-key": "id",
        onChange: a.reorderProperty,
        tag: "div",
        handle: ".handle"
      }, {
        item: N(({ element: f }) => [
          k(u, { class: "property" }, {
            default: N(() => [
              O("div", {
                class: "visibility",
                onClick: e[0] || (e[0] = de((d) => d.currentTarget.querySelector("input").click(), ["self"]))
              }, [
                O("input", {
                  type: "checkbox",
                  checked: a.logic.isPropertyVisible(f.id),
                  onChange: (d) => a.logic.setPropertyVisible(f.id, d.target.checked)
                }, null, 40, Wo)
              ]),
              O("span", Ko, C(f.name), 1)
            ]),
            _: 2
          }, 1024)
        ]),
        _: 1
      }, 8, ["list", "onChange"])
    ]),
    _: 1
  }, 8, ["panel-id"]);
}
const Yo = /* @__PURE__ */ X($o, [["render", zo]]), Vo = {
  name: "LivedataAdvancedPanelSort",
  components: {
    XWikiIcon: ne,
    LivedataBaseAdvancedPanel: Ee,
    draggable: Jt,
    XWikiDraggableItem: en
  },
  inject: ["logic"],
  props: { panel: Object },
  computed: {
    data() {
      return this.logic.data;
    },
    // The sortable properties that don't have a sort entry in the live data query.
    unsortedProperties() {
      return this.logic.getUnsortedProperties().map(
        (t) => this.logic.getPropertyDescriptor(t)
      );
    },
    sorts() {
      return this.data.query.sort;
    }
  },
  methods: {
    // Change event handler called by the add-sort select
    addSortLevel(t) {
      t !== "none" && (this.logic.addSort(t), this.$refs.selectPropertiesNone.selected = !0);
    },
    // Event handler called when sort entries are dragged and dropped
    reorderSorts(t) {
      this.logic.reorderSort(t.moved.element.property, t.moved.newIndex).catch((e) => console.warn(e));
    }
  }
}, Zo = ["onChange"], Qo = ["selected"], Jo = ["selected"], es = ["onClick", "title"], rs = ["value", "textContent"];
function ts(t, e, r, n, i, a) {
  const o = R("XWikiIcon"), u = R("XWikiDraggableItem"), s = R("draggable"), c = R("LivedataBaseAdvancedPanel");
  return A(), G(c, {
    class: "livedata-advanced-panel-sort",
    "panel-id": r.panel.id
  }, {
    header: N(() => [
      k(o, {
        "icon-descriptor": { name: r.panel.icon }
      }, null, 8, ["icon-descriptor"]),
      ee(" " + C(r.panel.title), 1)
    ]),
    body: N(() => [
      Q(O("div", { class: "text-muted" }, C(t.$t("livedata.panel.sort.noneSortable")), 513), [
        [J, !a.logic.getSortableProperties().length]
      ]),
      k(s, {
        class: "draggable-container",
        list: a.sorts,
        "item-key": "property",
        onChange: a.reorderSorts,
        tag: "div",
        handle: ".handle"
      }, {
        item: N(({ element: f, index: d }) => [
          k(u, { class: "sort-entry" }, {
            default: N(() => [
              O("span", null, C(a.logic.getPropertyDescriptor(f.property).name), 1),
              e[1] || (e[1] = O("span", { style: { margin: "0 1rem" } }, " - ", -1)),
              O("select", {
                onChange: (h) => a.logic.sort(f.property, d, h.target.value === "true")
              }, [
                O("option", {
                  value: "false",
                  selected: !f.descending
                }, C(t.$t("livedata.panel.sort.direction.ascending")), 9, Qo),
                O("option", {
                  value: "true",
                  selected: f.descending
                }, C(t.$t("livedata.panel.sort.direction.descending")), 9, Jo)
              ], 40, Zo),
              O("a", {
                class: "delete-sort",
                href: "#",
                onClick: de((h) => a.logic.removeSort(f.property), ["prevent"]),
                title: t.$t("livedata.panel.sort.delete")
              }, [
                k(o, { "icon-descriptor": { name: "trash" } })
              ], 8, es)
            ]),
            _: 2
          }, 1024)
        ]),
        _: 1
      }, 8, ["list", "onChange"]),
      Q(O("select", {
        class: "add-sort-select",
        onChange: e[0] || (e[0] = (f) => a.addSortLevel(f.target.value))
      }, [
        O("option", {
          value: "none",
          ref: "selectPropertiesNone",
          selected: "",
          disabled: ""
        }, C(t.$t("livedata.panel.sort.add")), 513),
        (A(!0), x(re, null, te(a.unsortedProperties, (f) => (A(), x("option", {
          key: f.id,
          value: f.id,
          textContent: C(f.name)
        }, null, 8, rs))), 128))
      ], 544), [
        [J, a.unsortedProperties.length > 0]
      ])
    ]),
    _: 1
  }, 8, ["panel-id"]);
}
const ns = /* @__PURE__ */ X(Vo, [["render", ts]]), is = {
  name: "LivedataAdvancedPanelFilterEntry",
  components: {
    LivedataFilter: Mo,
    XWikiIcon: ne
  },
  inject: ["logic"],
  props: {
    filterIndex: Number,
    propertyId: String
  },
  computed: {
    // The filter entry corresponding to the props
    filterEntry() {
      return this.logic.getQueryFilterGroup(this.propertyId).constraints[this.filterIndex];
    }
  }
}, as = { class: "livedata-filter-container" }, os = ["value", "textContent", "selected"], ss = ["title"];
function us(t, e, r, n, i, a) {
  const o = R("LivedataFilter"), u = R("XWikiIcon");
  return A(), x("div", as, [
    O("select", {
      class: "operator-select",
      onChange: e[0] || (e[0] = (s) => a.logic.filter(r.propertyId, r.filterIndex, { operator: s.target.value }))
    }, [
      (A(!0), x(re, null, te(a.logic.getFilterDescriptor(r.propertyId).operators, (s) => (A(), x("option", {
        key: s.id,
        value: s.id,
        textContent: C(s.name),
        selected: s.id === a.filterEntry.operator
      }, null, 8, os))), 128))
    ], 32),
    k(o, {
      "property-id": r.propertyId,
      index: r.filterIndex,
      "is-advanced": !0
    }, null, 8, ["property-id", "index"]),
    O("a", {
      class: "delete-filter",
      href: "#",
      onClick: e[1] || (e[1] = de((s) => a.logic.removeFilter(r.propertyId, r.filterIndex), ["prevent"])),
      title: t.$t("livedata.panel.filter.delete")
    }, [
      k(u, { "icon-descriptor": { name: "trash" } })
    ], 8, ss)
  ]);
}
const cs = /* @__PURE__ */ X(is, [["render", us]]), ls = {
  name: "LivedataAdvancedPanelFilter",
  components: {
    XWikiIcon: ne,
    LivedataBaseAdvancedPanel: Ee,
    LivedataAdvancedPanelFilterEntry: cs,
    draggable: Jt,
    XWikiDraggableItem: en
  },
  inject: ["logic"],
  props: { panel: Object },
  computed: {
    data() {
      return this.logic.data;
    },
    // The filterable properties that don't have a filter group in the live data query.
    unfilteredProperties() {
      return this.logic.getUnfilteredProperties().map(
        (t) => this.logic.getPropertyDescriptor(t)
      );
    }
  },
  methods: {
    // Change event handler called by the add-filters select
    addFilterGroup(t) {
      t !== "none" && (this.logic.addFilter(t), this.$refs.selectFilterPropertiesNone.selected = !0);
    },
    // Event handler called when filter entries are dragged and dropped
    // When a property is simply reodered, it dispatches only one "move" event
    // When a property is move between two different properties
    // it dispatches two event:
    // - a "remove" event for the property that had the moved property
    // - a "added" evnet for the property that receive the moved property
    reorderFilter(t, e) {
      t.moved ? this.logic.filter(e.property, t.moved.oldIndex, {
        index: t.moved.newIndex
      }).catch((r) => void console.warn(r)) : t.added ? this.logic.addFilter(
        e.property,
        t.added.element.operator,
        t.added.element.value,
        t.added.newIndex
      ).catch((r) => void console.warn(r)) : t.removed && this.logic.removeFilter(e.property, t.removed.oldIndex).catch((r) => void console.warn(r));
    }
  }
}, ds = { class: "filter-group-title" }, fs = { class: "property-name" }, ps = ["onClick", "title"], hs = { class: "filters" }, vs = ["onClick"], ys = ["value", "textContent"];
function gs(t, e, r, n, i, a) {
  const o = R("XWikiIcon"), u = R("LivedataAdvancedPanelFilterEntry"), s = R("XWikiDraggableItem"), c = R("draggable"), f = R("LivedataBaseAdvancedPanel");
  return A(), G(f, {
    class: "livedata-advanced-panel-filter",
    "panel-id": r.panel.id
  }, {
    header: N(() => [
      k(o, {
        "icon-descriptor": { name: r.panel.icon }
      }, null, 8, ["icon-descriptor"]),
      ee(" " + C(r.panel.title), 1)
    ]),
    body: N(() => [
      Q(O("div", { class: "text-muted" }, C(t.$t("livedata.panel.filter.noneFilterable")), 513), [
        [J, !a.logic.getFilterableProperties().length]
      ]),
      (A(!0), x(re, null, te(a.data.query.filters, (d) => (A(), x("div", {
        class: "livedata-filter-group",
        key: d.property
      }, [
        O("div", ds, [
          O("span", fs, C(a.logic.getPropertyDescriptor(d.property).name), 1),
          O("a", {
            class: "delete-filter-group",
            href: "#",
            onClick: de((h) => a.logic.removeAllFilters(d.property), ["prevent"]),
            title: t.$t("livedata.panel.filter.deleteAll")
          }, [
            k(o, { "icon-descriptor": { name: "trash" } })
          ], 8, ps)
        ]),
        O("div", hs, [
          k(c, {
            class: "filter-entries draggable-container",
            list: a.logic.getQueryFilterGroup(d.property).constraints,
            "item-key": "id",
            onChange: (h) => a.reorderFilter(h, d),
            group: `filter-panel${a.logic.getFilterDescriptor(d.property).id}`,
            tag: "div",
            handle: ".handle"
          }, {
            item: N(({ index: h }) => [
              k(s, null, {
                default: N(() => [
                  k(u, {
                    "filter-index": h,
                    "property-id": d.property
                  }, null, 8, ["filter-index", "property-id"])
                ]),
                _: 2
              }, 1024)
            ]),
            _: 2
          }, 1032, ["list", "onChange", "group"]),
          O("a", {
            class: "add-filter",
            href: "#",
            onClick: de((h) => a.logic.addFilter(d.property), ["prevent"])
          }, " + " + C(t.$t("livedata.panel.filter.addConstraint")), 9, vs)
        ])
      ]))), 128)),
      Q(O("select", {
        class: "add-filters-select",
        onChange: e[0] || (e[0] = (d) => a.addFilterGroup(d.target.value))
      }, [
        O("option", {
          value: "none",
          ref: "selectFilterPropertiesNone",
          selected: "",
          disabled: ""
        }, C(t.$t("livedata.panel.filter.addProperty")), 513),
        (A(!0), x(re, null, te(a.unfilteredProperties, (d) => (A(), x("option", {
          key: d.id,
          value: d.id,
          textContent: C(d.name)
        }, null, 8, ys))), 128))
      ], 544), [
        [J, a.unfilteredProperties.length > 0]
      ])
    ]),
    _: 1
  }, 8, ["panel-id"]);
}
const _s = /* @__PURE__ */ X(ls, [["render", gs]]), bs = {
  name: "LiveDataAdvancedPanelExtension",
  components: {
    XWikiIcon: ne,
    LivedataBaseAdvancedPanel: Ee
  },
  inject: ["logic"],
  props: { panel: Object },
  methods: {
    attachContainer() {
      if ("bodyContainer" in this.$refs) {
        const t = this.$refs.bodyContainer;
        t.hasChildNodes() ? t.firstChild !== this.panel.container && t.firstChild.replaceWith(this.panel.container) : t.appendChild(this.panel.container);
      }
    }
  },
  watch: {
    "panel.container": function() {
      this.attachContainer();
    }
  },
  mounted() {
    this.attachContainer(), this.$watch("$refs.basePanel.collapsed", function(t) {
      t || this.$nextTick(this.attachContainer);
    });
  }
}, ms = {
  ref: "bodyContainer",
  class: "extension-body"
};
function qs(t, e, r, n, i, a) {
  const o = R("XWikiIcon"), u = R("LivedataBaseAdvancedPanel");
  return A(), G(u, {
    class: Lo(["livedata-advanced-panel-extension", `livedata-advanced-panel-${r.panel.id}`]),
    "panel-id": r.panel.id,
    ref: "basePanel"
  }, {
    header: N(() => [
      k(o, {
        "icon-descriptor": { name: r.panel.icon }
      }, null, 8, ["icon-descriptor"]),
      ee(" " + C(r.panel.title), 1)
    ]),
    body: N(() => [
      O("div", ms, null, 512)
    ]),
    _: 1
  }, 8, ["class", "panel-id"]);
}
const Ps = /* @__PURE__ */ X(bs, [["render", qs]]), Ss = {
  name: "LivedataAdvancedPanels",
  components: {
    LivedataAdvancedPanelProperties: Yo,
    LivedataAdvancedPanelSort: ns,
    LivedataAdvancedPanelFilter: _s,
    LiveDataAdvancedPanelExtension: Ps
  },
  inject: ["logic"]
}, ws = { class: "livedata-advanced-panels" };
function Es(t, e, r, n, i, a) {
  return A(), x("div", ws, [
    (A(!0), x(re, null, te(a.logic.panels, (o) => (A(), G(Za(o.component), {
      key: o.id,
      panel: o
    }, null, 8, ["panel"]))), 128))
  ]);
}
const As = /* @__PURE__ */ X(Ss, [["render", Es]]), Os = {
  name: "LivedataLayout",
  inject: ["logic"],
  props: {
    // The id of the layout to load
    layoutId: String
  },
  data() {
    return {
      // The layout component
      // It is set to `undefined before it is resolved
      layoutComponent: void 0
    };
  },
  computed: {
    data() {
      return this.logic.data;
    },
    description() {
      return this.data?.meta?.description;
    },
    hasDescription() {
      return this.description && this.description !== "";
    },
    descriptionId() {
      return `${this.logic.data.id}-description`;
    }
  },
  // On mounted and when the `layoutId` prop change,
  // try to load the layout corresponding to the layoutId
  // or the default one as fallback
  watch: {
    layoutId: {
      immediate: !0,
      handler(t, e) {
        this.loadLayout(this.layoutId).then((r) => {
          this.logic.triggerEvent("layoutLoaded", {
            layoutId: t,
            previousLayoutId: e,
            component: r
          });
        }).catch((r) => {
          this.layoutId && this.layoutId !== this.data.meta.defaultLayout ? (console.warn(r), this.logic.changeLayout(this.data.meta.defaultLayout)) : console.error(r);
        });
      }
    }
  },
  methods: {
    // Capitalize the given string
    capitalize(t) {
      return t ??= "", t[0].toUpperCase() + t.slice(1);
    },
    // Load the layout component corresponding to the given layoutId
    // On success, set `this.layoutComponent` to the retreived component,
    // which automatically insert the component in the html
    async loadLayout(t) {
      const e = await Qa.load("layout", t);
      if (!e)
        throw new Error(`Unknown layout [${t}]`);
      return this.layoutComponent = xo(e), e;
    }
  }
}, Ts = { class: "livedata-layout" }, Is = ["id"];
function Rs(t, e, r, n, i, a) {
  return A(), x("div", Ts, [
    a.hasDescription ? (A(), x("p", {
      key: 0,
      class: "livedata-layout-description",
      id: a.descriptionId
    }, C(a.description), 9, Is)) : K("", !0),
    (A(), G(Co, null, [
      O("div", null, [
        i.layoutComponent ? (A(), G(Za(i.layoutComponent), {
          key: 0,
          "aria-describedby": a.descriptionId
        }, null, 8, ["aria-describedby"])) : K("", !0)
      ])
    ], 1024))
  ]);
}
const Ls = /* @__PURE__ */ X(Os, [["render", Rs]]);
var hn = typeof globalThis < "u" ? globalThis : typeof window < "u" ? window : typeof global < "u" ? global : typeof self < "u" ? self : {};
function Ja(t) {
  return t && t.__esModule && Object.prototype.hasOwnProperty.call(t, "default") ? t.default : t;
}
var xe = {}, z = {}, Ce, vn;
function xs() {
  if (vn) return Ce;
  vn = 1;
  function t(e) {
    for (var r = -1, n = e ? e.length : 0, i = {}; ++r < n; ) {
      var a = e[r];
      i[a[0]] = a[1];
    }
    return i;
  }
  return Ce = t, Ce;
}
var Fe, yn;
function rn() {
  if (yn) return Fe;
  yn = 1;
  var t = Object.prototype, e = t.hasOwnProperty, r = Object.getPrototypeOf;
  function n(i, a) {
    return e.call(i, a) || typeof i == "object" && a in i && r(i) === null;
  }
  return Fe = n, Fe;
}
var Me, gn;
function Cs() {
  if (gn) return Me;
  gn = 1;
  var t = Object.keys;
  function e(r) {
    return t(Object(r));
  }
  return Me = e, Me;
}
var De, _n;
function Fs() {
  if (_n) return De;
  _n = 1;
  function t(e, r) {
    for (var n = -1, i = Array(e); ++n < e; )
      i[n] = r(n);
    return i;
  }
  return De = t, De;
}
var je, bn;
function eo() {
  if (bn) return je;
  bn = 1;
  function t(e) {
    return function(r) {
      return r?.[e];
    };
  }
  return je = t, je;
}
var ke, mn;
function Ms() {
  if (mn) return ke;
  mn = 1;
  var t = eo(), e = t("length");
  return ke = e, ke;
}
var Be, qn;
function ie() {
  if (qn) return Be;
  qn = 1;
  function t(e) {
    var r = typeof e;
    return !!e && (r == "object" || r == "function");
  }
  return Be = t, Be;
}
var Ne, Pn;
function tn() {
  if (Pn) return Ne;
  Pn = 1;
  var t = ie(), e = "[object Function]", r = "[object GeneratorFunction]", n = Object.prototype, i = n.toString;
  function a(o) {
    var u = t(o) ? i.call(o) : "";
    return u == e || u == r;
  }
  return Ne = a, Ne;
}
var He, Sn;
function Ae() {
  if (Sn) return He;
  Sn = 1;
  var t = 9007199254740991;
  function e(r) {
    return typeof r == "number" && r > -1 && r % 1 == 0 && r <= t;
  }
  return He = e, He;
}
var Ge, wn;
function fe() {
  if (wn) return Ge;
  wn = 1;
  var t = Ms(), e = tn(), r = Ae();
  function n(i) {
    return i != null && !(typeof i == "function" && e(i)) && r(t(i));
  }
  return Ge = n, Ge;
}
var Xe, En;
function ae() {
  if (En) return Xe;
  En = 1;
  function t(e) {
    return !!e && typeof e == "object";
  }
  return Xe = t, Xe;
}
var Ue, An;
function ro() {
  if (An) return Ue;
  An = 1;
  var t = fe(), e = ae();
  function r(n) {
    return e(n) && t(n);
  }
  return Ue = r, Ue;
}
var $e, On;
function nn() {
  if (On) return $e;
  On = 1;
  var t = ro(), e = "[object Arguments]", r = Object.prototype, n = r.hasOwnProperty, i = r.toString, a = r.propertyIsEnumerable;
  function o(u) {
    return t(u) && n.call(u, "callee") && (!a.call(u, "callee") || i.call(u) == e);
  }
  return $e = o, $e;
}
var We, Tn;
function H() {
  if (Tn) return We;
  Tn = 1;
  var t = Array.isArray;
  return We = t, We;
}
var Ke, In;
function to() {
  if (In) return Ke;
  In = 1;
  var t = H(), e = ae(), r = "[object String]", n = Object.prototype, i = n.toString;
  function a(o) {
    return typeof o == "string" || !t(o) && e(o) && i.call(o) == r;
  }
  return Ke = a, Ke;
}
var ze, Rn;
function Ds() {
  if (Rn) return ze;
  Rn = 1;
  var t = Fs(), e = nn(), r = H(), n = Ae(), i = to();
  function a(o) {
    var u = o ? o.length : void 0;
    return n(u) && (r(o) || i(o) || e(o)) ? t(u, String) : null;
  }
  return ze = a, ze;
}
var Ye, Ln;
function an() {
  if (Ln) return Ye;
  Ln = 1;
  var t = 9007199254740991, e = /^(?:0|[1-9]\d*)$/;
  function r(n, i) {
    return n = typeof n == "number" || e.test(n) ? +n : -1, i = i ?? t, n > -1 && n % 1 == 0 && n < i;
  }
  return Ye = r, Ye;
}
var Ve, xn;
function js() {
  if (xn) return Ve;
  xn = 1;
  var t = Object.prototype;
  function e(r) {
    var n = r && r.constructor, i = typeof n == "function" && n.prototype || t;
    return r === i;
  }
  return Ve = e, Ve;
}
var Ze, Cn;
function Oe() {
  if (Cn) return Ze;
  Cn = 1;
  var t = rn(), e = Cs(), r = Ds(), n = fe(), i = an(), a = js();
  function o(u) {
    var s = a(u);
    if (!(s || n(u)))
      return e(u);
    var c = r(u), f = !!c, d = c || [], h = d.length;
    for (var q in u)
      t(u, q) && !(f && (q == "length" || i(q, h))) && !(s && q == "constructor") && d.push(q);
    return d;
  }
  return Ze = o, Ze;
}
var Qe, Fn;
function no() {
  if (Fn) return Qe;
  Fn = 1;
  function t(e, r, n) {
    var i = -1, a = e.length;
    r < 0 && (r = -r > a ? 0 : a + r), n = n > a ? a : n, n < 0 && (n += a), a = r > n ? 0 : n - r >>> 0, r >>>= 0;
    for (var o = Array(a); ++i < a; )
      o[i] = e[i + r];
    return o;
  }
  return Qe = t, Qe;
}
var Je, Mn;
function ks() {
  if (Mn) return Je;
  Mn = 1;
  var t = tn(), e = ie(), r = NaN, n = /^\s+|\s+$/g, i = /^[-+]0x[0-9a-f]+$/i, a = /^0b[01]+$/i, o = /^0o[0-7]+$/i, u = parseInt;
  function s(c) {
    if (e(c)) {
      var f = t(c.valueOf) ? c.valueOf() : c;
      c = e(f) ? f + "" : f;
    }
    if (typeof c != "string")
      return c === 0 ? c : +c;
    c = c.replace(n, "");
    var d = a.test(c);
    return d || o.test(c) ? u(c.slice(2), d ? 2 : 8) : i.test(c) ? r : +c;
  }
  return Je = s, Je;
}
var er, Dn;
function on() {
  if (Dn) return er;
  Dn = 1;
  var t = ks(), e = 1 / 0, r = 17976931348623157e292;
  function n(i) {
    if (!i)
      return i === 0 ? i : 0;
    if (i = t(i), i === e || i === -e) {
      var a = i < 0 ? -1 : 1;
      return a * r;
    }
    var o = i % 1;
    return i === i ? o ? i - o : i : 0;
  }
  return er = n, er;
}
var rr, jn;
function Bs() {
  if (jn) return rr;
  jn = 1;
  var t = no(), e = on();
  function r(n, i, a) {
    var o = n ? n.length : 0;
    return o ? (i = a || i === void 0 ? 1 : e(i), t(n, i < 0 ? 0 : i, o)) : [];
  }
  return rr = r, rr;
}
var tr, kn;
function Ns() {
  if (kn) return tr;
  kn = 1;
  var t = Bs();
  function e(r) {
    return t(r, 1);
  }
  return tr = e, tr;
}
var nr, Bn;
function sn() {
  if (Bn) return nr;
  Bn = 1;
  function t(e, r) {
    for (var n = -1, i = e.length, a = Array(i); ++n < i; )
      a[n] = r(e[n], n, e);
    return a;
  }
  return nr = t, nr;
}
var ir, Nn;
function Hs() {
  if (Nn) return ir;
  Nn = 1;
  function t() {
    this.__data__ = { array: [], map: null };
  }
  return ir = t, ir;
}
var ar, Hn;
function io() {
  if (Hn) return ar;
  Hn = 1;
  function t(e, r) {
    return e === r || e !== e && r !== r;
  }
  return ar = t, ar;
}
var or, Gn;
function Te() {
  if (Gn) return or;
  Gn = 1;
  var t = io();
  function e(r, n) {
    for (var i = r.length; i--; )
      if (t(r[i][0], n))
        return i;
    return -1;
  }
  return or = e, or;
}
var sr, Xn;
function ao() {
  if (Xn) return sr;
  Xn = 1;
  var t = Te(), e = Array.prototype, r = e.splice;
  function n(i, a) {
    var o = t(i, a);
    if (o < 0)
      return !1;
    var u = i.length - 1;
    return o == u ? i.pop() : r.call(i, o, 1), !0;
  }
  return sr = n, sr;
}
var ur, Un;
function Gs() {
  if (Un) return ur;
  Un = 1;
  var t = ao();
  function e(r) {
    var n = this.__data__, i = n.array;
    return i ? t(i, r) : n.map.delete(r);
  }
  return ur = e, ur;
}
var cr, $n;
function oo() {
  if ($n) return cr;
  $n = 1;
  var t = Te();
  function e(r, n) {
    var i = t(r, n);
    return i < 0 ? void 0 : r[i][1];
  }
  return cr = e, cr;
}
var lr, Wn;
function Xs() {
  if (Wn) return lr;
  Wn = 1;
  var t = oo();
  function e(r) {
    var n = this.__data__, i = n.array;
    return i ? t(i, r) : n.map.get(r);
  }
  return lr = e, lr;
}
var dr, Kn;
function so() {
  if (Kn) return dr;
  Kn = 1;
  var t = Te();
  function e(r, n) {
    return t(r, n) > -1;
  }
  return dr = e, dr;
}
var fr, zn;
function Us() {
  if (zn) return fr;
  zn = 1;
  var t = so();
  function e(r) {
    var n = this.__data__, i = n.array;
    return i ? t(i, r) : n.map.has(r);
  }
  return fr = e, fr;
}
var pr, Yn;
function uo() {
  if (Yn) return pr;
  Yn = 1;
  function t(e) {
    var r = !1;
    if (e != null && typeof e.toString != "function")
      try {
        r = !!(e + "");
      } catch {
      }
    return r;
  }
  return pr = t, pr;
}
var hr, Vn;
function $s() {
  if (Vn) return hr;
  Vn = 1;
  var t = tn(), e = uo(), r = ae(), n = /[\\^$.*+?()[\]{}|]/g, i = /^\[object .+?Constructor\]$/, a = Object.prototype, o = Function.prototype.toString, u = a.hasOwnProperty, s = RegExp(
    "^" + o.call(u).replace(n, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
  );
  function c(f) {
    return f == null ? !1 : t(f) ? s.test(o.call(f)) : r(f) && (e(f) ? s : i).test(f);
  }
  return hr = c, hr;
}
var vr, Zn;
function un() {
  if (Zn) return vr;
  Zn = 1;
  var t = $s();
  function e(r, n) {
    var i = r?.[n];
    return t(i) ? i : void 0;
  }
  return vr = e, vr;
}
var yr, Qn;
function Ie() {
  if (Qn) return yr;
  Qn = 1;
  var t = un(), e = t(Object, "create");
  return yr = e, yr;
}
var gr, Jn;
function Ws() {
  if (Jn) return gr;
  Jn = 1;
  var t = Ie(), e = Object.prototype;
  function r() {
  }
  return r.prototype = t ? t(null) : e, gr = r, gr;
}
var le = { exports: {} }, _r, ei;
function Ks() {
  if (ei) return _r;
  ei = 1;
  function t(e) {
    return e && e.Object === Object ? e : null;
  }
  return _r = t, _r;
}
var ri = le.exports, ti;
function Re() {
  return ti || (ti = 1, function(t, e) {
    var r = Ks(), n = {
      function: !0,
      object: !0
    }, i = e && !e.nodeType ? e : null, a = t && !t.nodeType ? t : null, o = r(i && a && typeof hn == "object" && hn), u = r(n[typeof self] && self), s = r(n[typeof window] && window), c = r(n[typeof ri] && ri), f = o || s !== (c && c.window) && s || u || c || Function("return this")();
    t.exports = f;
  }(le, le.exports)), le.exports;
}
var br, ni;
function oe() {
  if (ni) return br;
  ni = 1;
  var t = un(), e = Re(), r = t(e, "Map");
  return br = r, br;
}
var mr, ii;
function zs() {
  if (ii) return mr;
  ii = 1;
  var t = Ws(), e = oe();
  function r() {
    this.__data__ = { hash: new t(), map: e ? new e() : [], string: new t() };
  }
  return mr = r, mr;
}
var qr, ai;
function co() {
  if (ai) return qr;
  ai = 1;
  var t = Ie(), e = Object.prototype, r = e.hasOwnProperty;
  function n(i, a) {
    return t ? i[a] !== void 0 : r.call(i, a);
  }
  return qr = n, qr;
}
var Pr, oi;
function Ys() {
  if (oi) return Pr;
  oi = 1;
  var t = co();
  function e(r, n) {
    return t(r, n) && delete r[n];
  }
  return Pr = e, Pr;
}
var Sr, si;
function Le() {
  if (si) return Sr;
  si = 1;
  function t(e) {
    var r = typeof e;
    return r == "number" || r == "boolean" || r == "string" && e !== "__proto__" || e == null;
  }
  return Sr = t, Sr;
}
var wr, ui;
function Vs() {
  if (ui) return wr;
  ui = 1;
  var t = oe(), e = ao(), r = Ys(), n = Le();
  function i(a) {
    var o = this.__data__;
    return n(a) ? r(typeof a == "string" ? o.string : o.hash, a) : t ? o.map.delete(a) : e(o.map, a);
  }
  return wr = i, wr;
}
var Er, ci;
function Zs() {
  if (ci) return Er;
  ci = 1;
  var t = Ie(), e = "__lodash_hash_undefined__", r = Object.prototype, n = r.hasOwnProperty;
  function i(a, o) {
    if (t) {
      var u = a[o];
      return u === e ? void 0 : u;
    }
    return n.call(a, o) ? a[o] : void 0;
  }
  return Er = i, Er;
}
var Ar, li;
function Qs() {
  if (li) return Ar;
  li = 1;
  var t = oe(), e = oo(), r = Zs(), n = Le();
  function i(a) {
    var o = this.__data__;
    return n(a) ? r(typeof a == "string" ? o.string : o.hash, a) : t ? o.map.get(a) : e(o.map, a);
  }
  return Ar = i, Ar;
}
var Or, di;
function Js() {
  if (di) return Or;
  di = 1;
  var t = oe(), e = so(), r = co(), n = Le();
  function i(a) {
    var o = this.__data__;
    return n(a) ? r(typeof a == "string" ? o.string : o.hash, a) : t ? o.map.has(a) : e(o.map, a);
  }
  return Or = i, Or;
}
var Tr, fi;
function lo() {
  if (fi) return Tr;
  fi = 1;
  var t = Te();
  function e(r, n, i) {
    var a = t(r, n);
    a < 0 ? r.push([n, i]) : r[a][1] = i;
  }
  return Tr = e, Tr;
}
var Ir, pi;
function eu() {
  if (pi) return Ir;
  pi = 1;
  var t = Ie(), e = "__lodash_hash_undefined__";
  function r(n, i, a) {
    n[i] = t && a === void 0 ? e : a;
  }
  return Ir = r, Ir;
}
var Rr, hi;
function ru() {
  if (hi) return Rr;
  hi = 1;
  var t = oe(), e = lo(), r = eu(), n = Le();
  function i(a, o) {
    var u = this.__data__;
    return n(a) ? r(typeof a == "string" ? u.string : u.hash, a, o) : t ? u.map.set(a, o) : e(u.map, a, o), this;
  }
  return Rr = i, Rr;
}
var Lr, vi;
function tu() {
  if (vi) return Lr;
  vi = 1;
  var t = zs(), e = Vs(), r = Qs(), n = Js(), i = ru();
  function a(o) {
    var u = -1, s = o ? o.length : 0;
    for (this.clear(); ++u < s; ) {
      var c = o[u];
      this.set(c[0], c[1]);
    }
  }
  return a.prototype.clear = t, a.prototype.delete = e, a.prototype.get = r, a.prototype.has = n, a.prototype.set = i, Lr = a, Lr;
}
var xr, yi;
function nu() {
  if (yi) return xr;
  yi = 1;
  var t = tu(), e = lo(), r = 200;
  function n(i, a) {
    var o = this.__data__, u = o.array;
    u && (u.length < r - 1 ? e(u, i, a) : (o.array = null, o.map = new t(u)));
    var s = o.map;
    return s && s.set(i, a), this;
  }
  return xr = n, xr;
}
var Cr, gi;
function fo() {
  if (gi) return Cr;
  gi = 1;
  var t = Hs(), e = Gs(), r = Xs(), n = Us(), i = nu();
  function a(o) {
    var u = -1, s = o ? o.length : 0;
    for (this.clear(); ++u < s; ) {
      var c = o[u];
      this.set(c[0], c[1]);
    }
  }
  return a.prototype.clear = t, a.prototype.delete = e, a.prototype.get = r, a.prototype.has = n, a.prototype.set = i, Cr = a, Cr;
}
var Fr, _i;
function iu() {
  if (_i) return Fr;
  _i = 1;
  function t(e, r) {
    for (var n = -1, i = e.length; ++n < i; )
      if (r(e[n], n, e))
        return !0;
    return !1;
  }
  return Fr = t, Fr;
}
var Mr, bi;
function au() {
  if (bi) return Mr;
  bi = 1;
  var t = iu(), e = 1, r = 2;
  function n(i, a, o, u, s, c) {
    var f = -1, d = s & r, h = s & e, q = i.length, g = a.length;
    if (q != g && !(d && g > q))
      return !1;
    var m = c.get(i);
    if (m)
      return m == a;
    var _ = !0;
    for (c.set(i, a); ++f < q; ) {
      var S = i[f], w = a[f];
      if (u)
        var p = d ? u(w, S, f, a, i, c) : u(S, w, f, i, a, c);
      if (p !== void 0) {
        if (p)
          continue;
        _ = !1;
        break;
      }
      if (h) {
        if (!t(a, function(l) {
          return S === l || o(S, l, u, s, c);
        })) {
          _ = !1;
          break;
        }
      } else if (!(S === w || o(S, w, u, s, c))) {
        _ = !1;
        break;
      }
    }
    return c.delete(i), _;
  }
  return Mr = n, Mr;
}
var Dr, mi;
function po() {
  if (mi) return Dr;
  mi = 1;
  var t = Re(), e = t.Symbol;
  return Dr = e, Dr;
}
var jr, qi;
function ou() {
  if (qi) return jr;
  qi = 1;
  var t = Re(), e = t.Uint8Array;
  return jr = e, jr;
}
var kr, Pi;
function su() {
  if (Pi) return kr;
  Pi = 1;
  function t(e) {
    var r = -1, n = Array(e.size);
    return e.forEach(function(i, a) {
      n[++r] = [a, i];
    }), n;
  }
  return kr = t, kr;
}
var Br, Si;
function uu() {
  if (Si) return Br;
  Si = 1;
  function t(e) {
    var r = -1, n = Array(e.size);
    return e.forEach(function(i) {
      n[++r] = i;
    }), n;
  }
  return Br = t, Br;
}
var Nr, wi;
function cu() {
  if (wi) return Nr;
  wi = 1;
  var t = po(), e = ou(), r = su(), n = uu(), i = 1, a = 2, o = "[object Boolean]", u = "[object Date]", s = "[object Error]", c = "[object Map]", f = "[object Number]", d = "[object RegExp]", h = "[object Set]", q = "[object String]", g = "[object Symbol]", m = "[object ArrayBuffer]", _ = t ? t.prototype : void 0, S = t ? _.valueOf : void 0;
  function w(p, l, v, y, b, P) {
    switch (v) {
      case m:
        return !(p.byteLength != l.byteLength || !y(new e(p), new e(l)));
      case o:
      case u:
        return +p == +l;
      case s:
        return p.name == l.name && p.message == l.message;
      case f:
        return p != +p ? l != +l : p == +l;
      case d:
      case q:
        return p == l + "";
      case c:
        var E = r;
      case h:
        var I = P & a;
        return E || (E = n), (I || p.size == l.size) && y(E(p), E(l), b, P | i);
      case g:
        return !!t && S.call(p) == S.call(l);
    }
    return !1;
  }
  return Nr = w, Nr;
}
var Hr, Ei;
function lu() {
  if (Ei) return Hr;
  Ei = 1;
  var t = rn(), e = Oe(), r = 2;
  function n(i, a, o, u, s, c) {
    var f = s & r, d = e(i), h = d.length, q = e(a), g = q.length;
    if (h != g && !f)
      return !1;
    for (var m = h; m--; ) {
      var _ = d[m];
      if (!(f ? _ in a : t(a, _)))
        return !1;
    }
    var S = c.get(i);
    if (S)
      return S == a;
    var w = !0;
    c.set(i, a);
    for (var p = f; ++m < h; ) {
      _ = d[m];
      var l = i[_], v = a[_];
      if (u)
        var y = f ? u(v, l, _, a, i, c) : u(l, v, _, i, a, c);
      if (!(y === void 0 ? l === v || o(l, v, u, s, c) : y)) {
        w = !1;
        break;
      }
      p || (p = _ == "constructor");
    }
    if (w && !p) {
      var b = i.constructor, P = a.constructor;
      b != P && "constructor" in i && "constructor" in a && !(typeof b == "function" && b instanceof b && typeof P == "function" && P instanceof P) && (w = !1);
    }
    return c.delete(i), w;
  }
  return Hr = n, Hr;
}
var Gr, Ai;
function du() {
  if (Ai) return Gr;
  Ai = 1;
  var t = un(), e = Re(), r = t(e, "Set");
  return Gr = r, Gr;
}
var Xr, Oi;
function fu() {
  if (Oi) return Xr;
  Oi = 1;
  var t = oe(), e = du(), r = "[object Map]", n = "[object Object]", i = "[object Set]", a = Object.prototype, o = Function.prototype.toString, u = a.toString, s = t ? o.call(t) : "", c = e ? o.call(e) : "";
  function f(d) {
    return u.call(d);
  }
  return (t && f(new t()) != r || e && f(new e()) != i) && (f = function(d) {
    var h = u.call(d), q = h == n ? d.constructor : null, g = typeof q == "function" ? o.call(q) : "";
    if (g) {
      if (g == s)
        return r;
      if (g == c)
        return i;
    }
    return h;
  }), Xr = f, Xr;
}
var Ur, Ti;
function pu() {
  if (Ti) return Ur;
  Ti = 1;
  var t = Ae(), e = ae(), r = "[object Arguments]", n = "[object Array]", i = "[object Boolean]", a = "[object Date]", o = "[object Error]", u = "[object Function]", s = "[object Map]", c = "[object Number]", f = "[object Object]", d = "[object RegExp]", h = "[object Set]", q = "[object String]", g = "[object WeakMap]", m = "[object ArrayBuffer]", _ = "[object Float32Array]", S = "[object Float64Array]", w = "[object Int8Array]", p = "[object Int16Array]", l = "[object Int32Array]", v = "[object Uint8Array]", y = "[object Uint8ClampedArray]", b = "[object Uint16Array]", P = "[object Uint32Array]", E = {};
  E[_] = E[S] = E[w] = E[p] = E[l] = E[v] = E[y] = E[b] = E[P] = !0, E[r] = E[n] = E[m] = E[i] = E[a] = E[o] = E[u] = E[s] = E[c] = E[f] = E[d] = E[h] = E[q] = E[g] = !1;
  var I = Object.prototype, F = I.toString;
  function L(T) {
    return e(T) && t(T.length) && !!E[F.call(T)];
  }
  return Ur = L, Ur;
}
var $r, Ii;
function hu() {
  if (Ii) return $r;
  Ii = 1;
  var t = fo(), e = au(), r = cu(), n = lu(), i = fu(), a = H(), o = uo(), u = pu(), s = 2, c = "[object Arguments]", f = "[object Array]", d = "[object Object]", h = Object.prototype, q = h.hasOwnProperty;
  function g(m, _, S, w, p, l) {
    var v = a(m), y = a(_), b = f, P = f;
    v || (b = i(m), b == c ? b = d : b != d && (v = u(m))), y || (P = i(_), P == c ? P = d : P != d && (y = u(_)));
    var E = b == d && !o(m), I = P == d && !o(_), F = b == P;
    if (F && !(v || E))
      return r(m, _, b, S, w, p);
    var L = p & s;
    if (!L) {
      var T = E && q.call(m, "__wrapped__"), j = I && q.call(_, "__wrapped__");
      if (T || j)
        return S(T ? m.value() : m, j ? _.value() : _, w, p, l);
    }
    return F ? (l || (l = new t()), (v ? e : n)(m, _, S, w, p, l)) : !1;
  }
  return $r = g, $r;
}
var Wr, Ri;
function ho() {
  if (Ri) return Wr;
  Ri = 1;
  var t = hu(), e = ie(), r = ae();
  function n(i, a, o, u, s) {
    return i === a ? !0 : i == null || a == null || !e(i) && !r(a) ? i !== i && a !== a : t(i, a, n, o, u, s);
  }
  return Wr = n, Wr;
}
var Kr, Li;
function vu() {
  if (Li) return Kr;
  Li = 1;
  var t = fo(), e = ho(), r = 1, n = 2;
  function i(a, o, u, s) {
    var c = u.length, f = c, d = !s;
    if (a == null)
      return !f;
    for (a = Object(a); c--; ) {
      var h = u[c];
      if (d && h[2] ? h[1] !== a[h[0]] : !(h[0] in a))
        return !1;
    }
    for (; ++c < f; ) {
      h = u[c];
      var q = h[0], g = a[q], m = h[1];
      if (d && h[2]) {
        if (g === void 0 && !(q in a))
          return !1;
      } else {
        var _ = new t(), S = s ? s(g, m, q, a, o, _) : void 0;
        if (!(S === void 0 ? e(m, g, s, r | n, _) : S))
          return !1;
      }
    }
    return !0;
  }
  return Kr = i, Kr;
}
var zr, xi;
function yu() {
  if (xi) return zr;
  xi = 1;
  var t = ie();
  function e(r) {
    return r === r && !t(r);
  }
  return zr = e, zr;
}
var Yr, Ci;
function gu() {
  if (Ci) return Yr;
  Ci = 1;
  var t = sn();
  function e(r, n) {
    return t(n, function(i) {
      return [i, r[i]];
    });
  }
  return Yr = e, Yr;
}
var Vr, Fi;
function _u() {
  if (Fi) return Vr;
  Fi = 1;
  var t = gu(), e = Oe();
  function r(n) {
    return t(n, e(n));
  }
  return Vr = r, Vr;
}
var Zr, Mi;
function bu() {
  if (Mi) return Zr;
  Mi = 1;
  var t = yu(), e = _u();
  function r(n) {
    for (var i = e(n), a = i.length; a--; )
      i[a][2] = t(i[a][1]);
    return i;
  }
  return Zr = r, Zr;
}
var Qr, Di;
function mu() {
  if (Di) return Qr;
  Di = 1;
  var t = vu(), e = bu();
  function r(n) {
    var i = e(n);
    if (i.length == 1 && i[0][2]) {
      var a = i[0][0], o = i[0][1];
      return function(u) {
        return u == null ? !1 : u[a] === o && (o !== void 0 || a in Object(u));
      };
    }
    return function(u) {
      return u === n || t(u, n, i);
    };
  }
  return Qr = r, Qr;
}
var Jr, ji;
function qu() {
  if (ji) return Jr;
  ji = 1;
  var t = ae(), e = "[object Symbol]", r = Object.prototype, n = r.toString;
  function i(a) {
    return typeof a == "symbol" || t(a) && n.call(a) == e;
  }
  return Jr = i, Jr;
}
var et, ki;
function vo() {
  if (ki) return et;
  ki = 1;
  var t = po(), e = qu(), r = t ? t.prototype : void 0, n = t ? r.toString : void 0;
  function i(a) {
    if (typeof a == "string")
      return a;
    if (a == null)
      return "";
    if (e(a))
      return t ? n.call(a) : "";
    var o = a + "";
    return o == "0" && 1 / a == -1 / 0 ? "-0" : o;
  }
  return et = i, et;
}
var rt, Bi;
function Pu() {
  if (Bi) return rt;
  Bi = 1;
  var t = vo(), e = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]/g, r = /\\(\\)?/g;
  function n(i) {
    var a = [];
    return t(i).replace(e, function(o, u, s, c) {
      a.push(s ? c.replace(r, "$1") : u || o);
    }), a;
  }
  return rt = n, rt;
}
var tt, Ni;
function yo() {
  if (Ni) return tt;
  Ni = 1;
  var t = H(), e = Pu();
  function r(n) {
    return t(n) ? n : e(n);
  }
  return tt = r, tt;
}
var nt, Hi;
function cn() {
  if (Hi) return nt;
  Hi = 1;
  var t = H(), e = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, r = /^\w*$/;
  function n(i, a) {
    return typeof i == "number" ? !0 : !t(i) && (r.test(i) || !e.test(i) || a != null && i in Object(a));
  }
  return nt = n, nt;
}
var it, Gi;
function go() {
  if (Gi) return it;
  Gi = 1;
  var t = yo(), e = cn();
  function r(n, i) {
    i = e(i, n) ? [i + ""] : t(i);
    for (var a = 0, o = i.length; n != null && a < o; )
      n = n[i[a++]];
    return a && a == o ? n : void 0;
  }
  return it = r, it;
}
var at, Xi;
function _o() {
  if (Xi) return at;
  Xi = 1;
  var t = go();
  function e(r, n, i) {
    var a = r == null ? void 0 : t(r, n);
    return a === void 0 ? i : a;
  }
  return at = e, at;
}
var ot, Ui;
function Su() {
  if (Ui) return ot;
  Ui = 1;
  function t(e, r) {
    return r in Object(e);
  }
  return ot = t, ot;
}
var st, $i;
function wu() {
  if ($i) return st;
  $i = 1;
  function t(e) {
    var r = e ? e.length : 0;
    return r ? e[r - 1] : void 0;
  }
  return st = t, st;
}
var ut, Wi;
function Eu() {
  if (Wi) return ut;
  Wi = 1;
  var t = no(), e = _o();
  function r(n, i) {
    return i.length == 1 ? n : e(n, t(i, 0, -1));
  }
  return ut = r, ut;
}
var ct, Ki;
function bo() {
  if (Ki) return ct;
  Ki = 1;
  var t = yo(), e = nn(), r = H(), n = an(), i = cn(), a = Ae(), o = to(), u = wu(), s = Eu();
  function c(f, d, h) {
    if (f == null)
      return !1;
    var q = h(f, d);
    !q && !i(d) && (d = t(d), f = s(f, d), f != null && (d = u(d), q = h(f, d)));
    var g = f ? f.length : void 0;
    return q || !!g && a(g) && n(d, g) && (r(f) || o(f) || e(f));
  }
  return ct = c, ct;
}
var lt, zi;
function Au() {
  if (zi) return lt;
  zi = 1;
  var t = Su(), e = bo();
  function r(n, i) {
    return e(n, i, t);
  }
  return lt = r, lt;
}
var dt, Yi;
function Ou() {
  if (Yi) return dt;
  Yi = 1;
  var t = ho(), e = _o(), r = Au(), n = 1, i = 2;
  function a(o, u) {
    return function(s) {
      var c = e(s, o);
      return c === void 0 && c === u ? r(s, o) : t(u, c, void 0, n | i);
    };
  }
  return dt = a, dt;
}
var ft, Vi;
function mo() {
  if (Vi) return ft;
  Vi = 1;
  function t(e) {
    return e;
  }
  return ft = t, ft;
}
var pt, Zi;
function Tu() {
  if (Zi) return pt;
  Zi = 1;
  var t = go();
  function e(r) {
    return function(n) {
      return t(n, r);
    };
  }
  return pt = e, pt;
}
var ht, Qi;
function Iu() {
  if (Qi) return ht;
  Qi = 1;
  var t = eo(), e = Tu(), r = cn();
  function n(i) {
    return r(i) ? t(i) : e(i);
  }
  return ht = n, ht;
}
var vt, Ji;
function pe() {
  if (Ji) return vt;
  Ji = 1;
  var t = mu(), e = Ou(), r = mo(), n = H(), i = Iu();
  function a(o) {
    var u = typeof o;
    return u == "function" ? o : o == null ? r : u == "object" ? n(o) ? e(o[0], o[1]) : t(o) : i(o);
  }
  return vt = a, vt;
}
var yt, ea;
function Ru() {
  if (ea) return yt;
  ea = 1;
  function t(e) {
    return function(r, n, i) {
      for (var a = -1, o = Object(r), u = i(r), s = u.length; s--; ) {
        var c = u[e ? s : ++a];
        if (n(o[c], c, o) === !1)
          break;
      }
      return r;
    };
  }
  return yt = t, yt;
}
var gt, ra;
function Lu() {
  if (ra) return gt;
  ra = 1;
  var t = Ru(), e = t();
  return gt = e, gt;
}
var _t, ta;
function xu() {
  if (ta) return _t;
  ta = 1;
  var t = Lu(), e = Oe();
  function r(n, i) {
    return n && t(n, i, e);
  }
  return _t = r, _t;
}
var bt, na;
function Cu() {
  if (na) return bt;
  na = 1;
  var t = fe();
  function e(r, n) {
    return function(i, a) {
      if (i == null)
        return i;
      if (!t(i))
        return r(i, a);
      for (var o = i.length, u = n ? o : -1, s = Object(i); (n ? u-- : ++u < o) && a(s[u], u, s) !== !1; )
        ;
      return i;
    };
  }
  return bt = e, bt;
}
var mt, ia;
function he() {
  if (ia) return mt;
  ia = 1;
  var t = xu(), e = Cu(), r = e(t);
  return mt = r, mt;
}
var qt, aa;
function qo() {
  if (aa) return qt;
  aa = 1;
  var t = he(), e = fe();
  function r(n, i) {
    var a = -1, o = e(n) ? Array(n.length) : [];
    return t(n, function(u, s, c) {
      o[++a] = i(u, s, c);
    }), o;
  }
  return qt = r, qt;
}
var Pt, oa;
function ve() {
  if (oa) return Pt;
  oa = 1;
  var t = sn(), e = pe(), r = qo(), n = H();
  function i(a, o) {
    var u = n(a) ? t : r;
    return u(a, e(o, 3));
  }
  return Pt = i, Pt;
}
var St, sa;
function Fu() {
  if (sa) return St;
  sa = 1;
  function t(e, r, n, i) {
    var a = -1, o = e.length;
    for (i && o && (n = e[++a]); ++a < o; )
      n = r(n, e[a], a, e);
    return n;
  }
  return St = t, St;
}
var wt, ua;
function Mu() {
  if (ua) return wt;
  ua = 1;
  function t(e, r, n, i, a) {
    return a(e, function(o, u, s) {
      n = i ? (i = !1, o) : r(n, o, u, s);
    }), n;
  }
  return wt = t, wt;
}
var Et, ca;
function Po() {
  if (ca) return Et;
  ca = 1;
  var t = Fu(), e = he(), r = pe(), n = Mu(), i = H();
  function a(o, u, s) {
    var c = i(o) ? t : n, f = arguments.length < 3;
    return c(o, r(u, 4), s, f, e);
  }
  return Et = a, Et;
}
var At, la;
function Du() {
  if (la) return At;
  la = 1;
  function t(e, r) {
    for (var n = -1, i = e.length, a = -1, o = []; ++n < i; ) {
      var u = e[n];
      r(u, n, e) && (o[++a] = u);
    }
    return o;
  }
  return At = t, At;
}
var Ot, da;
function ju() {
  if (da) return Ot;
  da = 1;
  var t = he();
  function e(r, n) {
    var i = [];
    return t(r, function(a, o, u) {
      n(a, o, u) && i.push(a);
    }), i;
  }
  return Ot = e, Ot;
}
var Tt, fa;
function ku() {
  if (fa) return Tt;
  fa = 1;
  var t = Du(), e = ju(), r = pe(), n = H();
  function i(a, o) {
    var u = n(a) ? t : e;
    return u(a, r(o, 3));
  }
  return Tt = i, Tt;
}
var It, pa;
function Bu() {
  if (pa) return It;
  pa = 1;
  function t(e, r) {
    for (var n = -1, i = r.length, a = e.length; ++n < i; )
      e[a + n] = r[n];
    return e;
  }
  return It = t, It;
}
var Rt, ha;
function So() {
  if (ha) return Rt;
  ha = 1;
  var t = Bu(), e = nn(), r = H(), n = ro();
  function i(a, o, u, s) {
    s || (s = []);
    for (var c = -1, f = a.length; ++c < f; ) {
      var d = a[c];
      n(d) && (u || r(d) || e(d)) ? o ? i(d, o, u, s) : t(s, d) : u || (s[s.length] = d);
    }
    return s;
  }
  return Rt = i, Rt;
}
var Lt, va;
function Nu() {
  if (va) return Lt;
  va = 1;
  function t(e, r) {
    var n = e.length;
    for (e.sort(r); n--; )
      e[n] = e[n].value;
    return e;
  }
  return Lt = t, Lt;
}
var xt, ya;
function Hu() {
  if (ya) return xt;
  ya = 1;
  function t(e, r) {
    if (e !== r) {
      var n = e === null, i = e === void 0, a = e === e, o = r === null, u = r === void 0, s = r === r;
      if (e > r && !o || !a || n && !u && s || i && s)
        return 1;
      if (e < r && !n || !s || o && !i && a || u && a)
        return -1;
    }
    return 0;
  }
  return xt = t, xt;
}
var Ct, ga;
function Gu() {
  if (ga) return Ct;
  ga = 1;
  var t = Hu();
  function e(r, n, i) {
    for (var a = -1, o = r.criteria, u = n.criteria, s = o.length, c = i.length; ++a < s; ) {
      var f = t(o[a], u[a]);
      if (f) {
        if (a >= c)
          return f;
        var d = i[a];
        return f * (d == "desc" ? -1 : 1);
      }
    }
    return r.index - n.index;
  }
  return Ct = e, Ct;
}
var Ft, _a;
function Xu() {
  if (_a) return Ft;
  _a = 1;
  var t = sn(), e = pe(), r = qo(), n = Nu(), i = Gu();
  function a(o, u, s) {
    var c = -1, f = e;
    u = t(u.length ? u : Array(1), function(h) {
      return f(h);
    });
    var d = r(o, function(h, q, g) {
      var m = t(u, function(_) {
        return _(h);
      });
      return { criteria: m, index: ++c, value: h };
    });
    return n(d, function(h, q) {
      return i(h, q, s);
    });
  }
  return Ft = a, Ft;
}
var Mt, ba;
function Uu() {
  if (ba) return Mt;
  ba = 1;
  var t = io(), e = fe(), r = an(), n = ie();
  function i(a, o, u) {
    if (!n(u))
      return !1;
    var s = typeof o;
    return (s == "number" ? e(u) && r(o, u.length) : s == "string" && o in u) ? t(u[o], a) : !1;
  }
  return Mt = i, Mt;
}
var Dt, ma;
function $u() {
  if (ma) return Dt;
  ma = 1;
  function t(e, r, n) {
    var i = n.length;
    switch (i) {
      case 0:
        return e.call(r);
      case 1:
        return e.call(r, n[0]);
      case 2:
        return e.call(r, n[0], n[1]);
      case 3:
        return e.call(r, n[0], n[1], n[2]);
    }
    return e.apply(r, n);
  }
  return Dt = t, Dt;
}
var jt, qa;
function Wu() {
  if (qa) return jt;
  qa = 1;
  var t = $u(), e = on(), r = "Expected a function", n = Math.max;
  function i(a, o) {
    if (typeof a != "function")
      throw new TypeError(r);
    return o = n(o === void 0 ? a.length - 1 : e(o), 0), function() {
      for (var u = arguments, s = -1, c = n(u.length - o, 0), f = Array(c); ++s < c; )
        f[s] = u[o + s];
      switch (o) {
        case 0:
          return a.call(this, f);
        case 1:
          return a.call(this, u[0], f);
        case 2:
          return a.call(this, u[0], u[1], f);
      }
      var d = Array(o + 1);
      for (s = -1; ++s < o; )
        d[s] = u[s];
      return d[o] = f, t(a, this, d);
    };
  }
  return jt = i, jt;
}
var kt, Pa;
function Ku() {
  if (Pa) return kt;
  Pa = 1;
  var t = So(), e = Xu(), r = Uu(), n = Wu(), i = n(function(a, o) {
    if (a == null)
      return [];
    var u = o.length;
    return u > 1 && r(a, o[0], o[1]) ? o = [] : u > 2 && r(o[0], o[1], o[2]) && (o.length = 1), e(a, t(o), []);
  });
  return kt = i, kt;
}
var Bt, Sa;
function zu() {
  if (Sa) return Bt;
  Sa = 1;
  function t(e, r, n, i) {
    var a;
    return n(e, function(o, u, s) {
      if (r(o, u, s))
        return a = i ? u : o, !1;
    }), a;
  }
  return Bt = t, Bt;
}
var Nt, wa;
function Yu() {
  if (wa) return Nt;
  wa = 1;
  function t(e, r, n) {
    for (var i = e.length, a = n ? i : -1; n ? a-- : ++a < i; )
      if (r(e[a], a, e))
        return a;
    return -1;
  }
  return Nt = t, Nt;
}
var Ht, Ea;
function Vu() {
  if (Ea) return Ht;
  Ea = 1;
  var t = he(), e = zu(), r = Yu(), n = pe(), i = H();
  function a(o, u) {
    if (u = n(u, 3), i(o)) {
      var s = r(o, u);
      return s > -1 ? o[s] : void 0;
    }
    return e(o, u, t);
  }
  return Ht = a, Ht;
}
var D = {}, Gt, Aa;
function Zu() {
  if (Aa) return Gt;
  Aa = 1;
  var t = on(), e = vo(), r = 9007199254740991, n = Math.floor;
  function i(a, o) {
    a = e(a), o = t(o);
    var u = "";
    if (!a || o < 1 || o > r)
      return u;
    do
      o % 2 && (u += a), o = n(o / 2), a += a;
    while (o);
    return u;
  }
  return Gt = i, Gt;
}
var Oa;
function Y() {
  if (Oa) return D;
  Oa = 1;
  var t = ve(), e = o(t), r = Po(), n = o(r), i = Zu(), a = o(i);
  Object.defineProperty(D, "__esModule", {
    value: !0
  }), D.none = D.notNone = void 0, D.bitsRequired = u, D.paddedBinary = s, D.isNone = f, D.concat = d, D.toN = g, D.fromN = m, D.fromVarN = _, D.toVarN = S, D.paddedN = w, D.bitsToN = p, D.nToBits = l;
  function o(v) {
    return v && v.__esModule ? v : { default: v };
  }
  function u(v) {
    return v === 0 ? 1 : Math.floor(Math.log(v) / Math.LN2) + 1;
  }
  function s(v, y) {
    var b = v.toString(2);
    if (b.length > y)
      throw new Error("Invalid value or bitSize: can't fit " + v + " in " + y + " bits");
    return (0, a.default)("0", y - b.length) + b;
  }
  D.notNone = s(0, 1);
  var c = D.none = s(1, 1);
  function f(v) {
    return v && v.length >= 1 && v[0] === c[0];
  }
  function d(v) {
    return (0, n.default)(v, function(y, b) {
      return { bits: y.bits + (b.bits || ""), blob: y.blob + (b.blob || "") };
    }, { bits: "", blob: "" });
  }
  var h = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_-", q = h.length;
  function g(v) {
    if (v < 0)
      throw new Error("Invalid number: can't encode negative number " + v);
    for (var y = ""; v >= q; )
      y = h[v % q] + y, v = Math.floor(v / q);
    return y = h[v] + y, y;
  }
  function m(v) {
    for (var y = 0, b, P = 0; P < v.length; P++) {
      if (b = h.indexOf(v[P]), b === -1)
        throw new Error("Invalid number: can't decode " + v);
      y += b * Math.pow(q, v.length - P - 1);
    }
    return y;
  }
  function _(v) {
    for (var y = v, b = 0, P = !0; P; ) {
      if (y.length === 0)
        throw new Error("Invalid number: can't decode " + v);
      var E = y[0];
      y = y.substr(1);
      var I = m(E);
      P = I > 31, b = b << 5 | I & 31;
    }
    return [b, y];
  }
  function S(v) {
    for (var y = "", b = Math.ceil(u(v) / 5), P = s(v, b * 5); P; ) {
      var E = P.substr(0, 5);
      P = P.substr(5), E = (P.length === 0 ? "0" : "1") + E, y += p(E);
    }
    return y;
  }
  function w(v, y) {
    var b = g(v);
    if (b.length > y)
      throw new Error("Invalid charSize: can't encode " + v + " in " + y + " chars");
    return (0, a.default)(h[0], y - b.length) + b;
  }
  function p(v) {
    for (var y = "", b; v; )
      b = v.substr(0, 6), v = v.substr(6), b.length < 6 && (b += (0, a.default)("0", 6 - b.length)), y += g(parseInt(b, 2));
    return y;
  }
  function l(v, y) {
    return (0, e.default)(v, function(b) {
      return s(m(b), 6);
    }).join("").substr(0, y);
  }
  return D;
}
var Ta;
function W() {
  if (Ta) return z;
  Ta = 1;
  var t = xs(), e = y(t), r = Oe(), n = y(r), i = ie(), a = y(i), o = Ns(), u = y(o), s = ve(), c = y(s), f = H(), d = y(f), h = Po(), q = y(h), g = ku(), m = y(g), _ = Ku(), S = y(_), w = Vu(), p = y(w), l = /* @__PURE__ */ function() {
    function L(T, j) {
      var B = [], M = !0, U = !1, V = void 0;
      try {
        for (var $ = T[Symbol.iterator](), se; !(M = (se = $.next()).done) && (B.push(se.value), !(j && B.length === j)); M = !0)
          ;
      } catch (ye) {
        U = !0, V = ye;
      } finally {
        try {
          !M && $.return && $.return();
        } finally {
          if (U) throw V;
        }
      }
      return B;
    }
    return function(T, j) {
      if (Array.isArray(T))
        return T;
      if (Symbol.iterator in Object(T))
        return L(T, j);
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    };
  }();
  Object.defineProperty(z, "__esModule", {
    value: !0
  }), z.register = P, z.encode = E, z.decode = I, z.fromJson = F;
  var v = Y();
  function y(L) {
    return L && L.__esModule ? L : { default: L };
  }
  var b = {};
  function P(L, T) {
    b[L] = T;
  }
  function E(L, T) {
    var j = L.spec.encode(T), B = j.bits, M = j.blob;
    return L.encodedVersion + (0, v.toVarN)(B.length) + (0, v.bitsToN)(B) + M;
  }
  function I(L, T) {
    var j, B, M = (0, v.fromVarN)(T), U = l(M, 2);
    j = U[0], T = U[1];
    var V = (0, v.fromVarN)(T), $ = l(V, 2);
    B = $[0], T = $[1];
    var se = (0, p.default)(L, function(ue) {
      return ue.version === j;
    });
    if (!se)
      throw new Error("Invalid version: " + j);
    var ye = Math.ceil(B / 6), Ao = (0, v.nToBits)(T.substr(0, ye), B), Oo = T.substr(ye), To = se.spec.decode({ bits: Ao, blob: Oo }), Io = (0, S.default)((0, m.default)(L, function(ue) {
      return ue.version > j;
    }), "version");
    return (0, q.default)(Io, function(ue, Ro) {
      return Ro.migrate(ue);
    }, To.value);
  }
  function F(L, T, j) {
    function B(M) {
      if ((0, d.default)(M)) {
        var U = M[0];
        return U === "tuple" ? b.tuple((0, c.default)((0, u.default)(M), B)) : U === "array" ? b.array(B(M[1])) : b[U].apply(null, (0, u.default)(M));
      } else if ((0, a.default)(M)) {
        var V = (0, n.default)(M).sort();
        return b.object((0, e.default)((0, c.default)(V, function($) {
          return [$, B(M[$])];
        })));
      }
    }
    return {
      version: L,
      spec: B(T),
      jsonSpec: T,
      encodedVersion: (0, v.toVarN)(L),
      migrate: j || function(M) {
        return M;
      }
    };
  }
  return z;
}
var ge = {}, Ia;
function wo() {
  if (Ia) return ge;
  Ia = 1, Object.defineProperty(ge, "__esModule", {
    value: !0
  }), ge.default = r;
  var t = Y(), e = W();
  function r() {
    for (var n = arguments.length, i = Array(n), a = 0; a < n; a++)
      i[a] = arguments[a];
    var o = (0, t.bitsRequired)(i.length - 1);
    return {
      encode: function(s) {
        var c = i.indexOf(s);
        if (c === -1)
          throw new Error("Invalid choice: " + s + " is not one of " + i.join(","));
        return { bits: (0, t.paddedBinary)(c, o), blob: "" };
      },
      decode: function(s) {
        var c = s.bits, f = s.blob, d = parseInt(c.substr(0, o), 2);
        return {
          value: i[d],
          rest: { bits: c.substring(o), blob: f }
        };
      }
    };
  }
  return (0, e.register)("oneOf", r), ge;
}
var _e = {}, Ra;
function Qu() {
  if (Ra) return _e;
  Ra = 1, Object.defineProperty(_e, "__esModule", {
    value: !0
  }), _e.default = i;
  var t = wo(), e = n(t), r = W();
  function n(a) {
    return a && a.__esModule ? a : { default: a };
  }
  function i() {
    return (0, e.default)(!0, !1);
  }
  return (0, r.register)("boolean", i), _e;
}
var be = {}, La;
function Ju() {
  if (La) return be;
  La = 1, Object.defineProperty(be, "__esModule", {
    value: !0
  }), be.default = r;
  var t = Y(), e = W();
  function r() {
    return {
      encode: function(i) {
        var a = Math.abs(i).toString(2), o = (0, t.paddedBinary)(a.length, 6) + (i > 0 ? "1" : "0") + a;
        return { bits: o, blob: "" };
      },
      decode: function(i) {
        var a = i.bits, o = i.blob, u = parseInt(a.substr(0, 6), 2);
        a = a.substr(6);
        var s = a[0] === "1" ? 1 : -1;
        return a = a.substr(1), {
          value: s * parseInt(a.substr(0, u), 2),
          rest: { bits: a.substr(u), blob: o }
        };
      }
    };
  }
  return (0, e.register)("integer", r), be;
}
var me = {}, xa;
function ec() {
  if (xa) return me;
  xa = 1;
  var t = /* @__PURE__ */ function() {
    function i(a, o) {
      var u = [], s = !0, c = !1, f = void 0;
      try {
        for (var d = a[Symbol.iterator](), h; !(s = (h = d.next()).done) && (u.push(h.value), !(o && u.length === o)); s = !0)
          ;
      } catch (q) {
        c = !0, f = q;
      } finally {
        try {
          !s && d.return && d.return();
        } finally {
          if (c) throw f;
        }
      }
      return u;
    }
    return function(a, o) {
      if (Array.isArray(a))
        return a;
      if (Symbol.iterator in Object(a))
        return i(a, o);
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    };
  }();
  Object.defineProperty(me, "__esModule", {
    value: !0
  }), me.default = n;
  var e = Y(), r = W();
  function n() {
    return {
      encode: function(a) {
        return { bits: "", blob: (0, e.toVarN)(a.length) + a };
      },
      decode: function(a) {
        var o = a.bits, u = a.blob, s, c = (0, e.fromVarN)(u), f = t(c, 2);
        return s = f[0], u = f[1], {
          value: u.substr(0, s),
          rest: { bits: o, blob: u.substr(s) }
        };
      }
    };
  }
  return (0, r.register)("varchar", n), me;
}
var qe = {}, Ca;
function rc() {
  if (Ca) return qe;
  Ca = 1, Object.defineProperty(qe, "__esModule", {
    value: !0
  }), qe.default = e;
  var t = W();
  function e(r) {
    return {
      encode: function(i) {
        return { bits: "", blob: i.toString() };
      },
      decode: function(i) {
        var a = i.bits, o = i.blob;
        return {
          value: o.substr(0, r),
          rest: { bits: a, blob: o.substr(r) }
        };
      }
    };
  }
  return (0, t.register)("fixedchar", e), qe;
}
var Pe = {}, Xt, Fa;
function tc() {
  if (Fa) return Xt;
  Fa = 1;
  function t(e, r) {
    for (var n = -1, i = e.length; ++n < i && r(e[n], n, e) !== !1; )
      ;
    return e;
  }
  return Xt = t, Xt;
}
var Ut, Ma;
function nc() {
  if (Ma) return Ut;
  Ma = 1;
  var t = mo();
  function e(r) {
    return typeof r == "function" ? r : t;
  }
  return Ut = e, Ut;
}
var $t, Da;
function ic() {
  if (Da) return $t;
  Da = 1;
  var t = tc(), e = he(), r = H(), n = nc();
  function i(a, o) {
    return typeof o == "function" && r(a) ? t(a, o) : e(a, n(o));
  }
  return $t = i, $t;
}
var Wt, ja;
function Eo() {
  return ja || (ja = 1, Wt = ic()), Wt;
}
var Kt, ka;
function ac() {
  if (ka) return Kt;
  ka = 1;
  var t = rn(), e = bo();
  function r(n, i) {
    return e(n, i, t);
  }
  return Kt = r, Kt;
}
var zt, Ba;
function oc() {
  if (Ba) return zt;
  Ba = 1;
  var t = So();
  function e(r) {
    var n = r ? r.length : 0;
    return n ? t(r) : [];
  }
  return zt = e, zt;
}
var Na;
function sc() {
  if (Na) return Pe;
  Na = 1;
  var t = Eo(), e = f(t), r = ac(), n = f(r), i = ve(), a = f(i), o = oc(), u = f(o);
  Object.defineProperty(Pe, "__esModule", {
    value: !0
  }), Pe.object = d;
  var s = Y(), c = W();
  function f(h) {
    return h && h.__esModule ? h : { default: h };
  }
  function d(h) {
    return {
      encode: function(g) {
        return (0, s.concat)((0, u.default)((0, a.default)(h, function(m, _) {
          return (0, n.default)(g, _) ? [{ bits: s.notNone }, m.encode(g[_])] : { bits: s.none };
        })));
      },
      decode: function(g) {
        var m = g.bits, _ = g.blob, S = {};
        return (0, e.default)(h, function(w, p) {
          if ((0, s.isNone)(m)) {
            m = m.substr(1);
            return;
          } else
            m = m.substr(1);
          var l = w.decode({ bits: m, blob: _ });
          m = l.rest.bits, _ = l.rest.blob, S[p] = l.value;
        }), { value: S, rest: { bits: m, blob: _ } };
      }
    };
  }
  return (0, c.register)("object", d), Pe;
}
var Se = {}, Ha;
function uc() {
  if (Ha) return Se;
  Ha = 1;
  var t = Eo(), e = o(t), r = ve(), n = o(r);
  Object.defineProperty(Se, "__esModule", {
    value: !0
  }), Se.tuple = u;
  var i = Y(), a = W();
  function o(s) {
    return s && s.__esModule ? s : { default: s };
  }
  function u(s) {
    return {
      encode: function(f) {
        return (0, i.concat)((0, n.default)(s, function(d, h) {
          return d.encode(f[h]);
        }));
      },
      decode: function(f) {
        var d = [];
        return (0, e.default)(s, function(h, q) {
          var g = h.decode(f);
          d[q] = g.value, f = g.rest;
        }), { value: d, rest: f };
      }
    };
  }
  return (0, a.register)("tuple", u), Se;
}
var we = {}, Ga;
function cc() {
  if (Ga) return we;
  Ga = 1;
  var t = ve(), e = a(t), r = /* @__PURE__ */ function() {
    function u(s, c) {
      var f = [], d = !0, h = !1, q = void 0;
      try {
        for (var g = s[Symbol.iterator](), m; !(d = (m = g.next()).done) && (f.push(m.value), !(c && f.length === c)); d = !0)
          ;
      } catch (_) {
        h = !0, q = _;
      } finally {
        try {
          !d && g.return && g.return();
        } finally {
          if (h) throw q;
        }
      }
      return f;
    }
    return function(s, c) {
      if (Array.isArray(s))
        return s;
      if (Symbol.iterator in Object(s))
        return u(s, c);
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    };
  }();
  Object.defineProperty(we, "__esModule", {
    value: !0
  }), we.array = o;
  var n = Y(), i = W();
  function a(u) {
    return u && u.__esModule ? u : { default: u };
  }
  function o(u) {
    return {
      encode: function(c) {
        return (0, n.concat)([{ blob: (0, n.toVarN)(c.length) }].concat((0, e.default)(c, u.encode)));
      },
      decode: function(c) {
        var f = c.bits, d = c.blob, h, q = (0, n.fromVarN)(d), g = r(q, 2);
        h = g[0], d = g[1];
        var m = { bits: f, blob: d }, _ = [], S, w;
        for (w = 0; w < h; w++)
          S = u.decode(m), _[w] = S.value, m = S.rest;
        return { value: _, rest: m };
      }
    };
  }
  return (0, i.register)("array", o), we;
}
var Xa;
function lc() {
  return Xa || (Xa = 1, function(t) {
    Object.defineProperty(t, "__esModule", {
      value: !0
    }), t.register = t.decode = t.encode = t.fromJson = void 0;
    var e = W();
    Object.defineProperty(t, "fromJson", {
      enumerable: !0,
      get: function() {
        return e.fromJson;
      }
    }), Object.defineProperty(t, "encode", {
      enumerable: !0,
      get: function() {
        return e.encode;
      }
    }), Object.defineProperty(t, "decode", {
      enumerable: !0,
      get: function() {
        return e.decode;
      }
    }), Object.defineProperty(t, "register", {
      enumerable: !0,
      get: function() {
        return e.register;
      }
    }), wo(), Qu(), Ju(), ec(), rc(), sc(), uc(), cc();
  }(xe)), xe;
}
var Yt = lc(), Vt = { exports: {} }, Ua;
function dc() {
  return Ua || (Ua = 1, function(t) {
    var e = function() {
      var r = String.fromCharCode, n = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=", i = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-$", a = {};
      function o(s, c) {
        if (!a[s]) {
          a[s] = {};
          for (var f = 0; f < s.length; f++)
            a[s][s.charAt(f)] = f;
        }
        return a[s][c];
      }
      var u = {
        compressToBase64: function(s) {
          if (s == null) return "";
          var c = u._compress(s, 6, function(f) {
            return n.charAt(f);
          });
          switch (c.length % 4) {
            // To produce valid Base64
            default:
            // When could this happen ?
            case 0:
              return c;
            case 1:
              return c + "===";
            case 2:
              return c + "==";
            case 3:
              return c + "=";
          }
        },
        decompressFromBase64: function(s) {
          return s == null ? "" : s == "" ? null : u._decompress(s.length, 32, function(c) {
            return o(n, s.charAt(c));
          });
        },
        compressToUTF16: function(s) {
          return s == null ? "" : u._compress(s, 15, function(c) {
            return r(c + 32);
          }) + " ";
        },
        decompressFromUTF16: function(s) {
          return s == null ? "" : s == "" ? null : u._decompress(s.length, 16384, function(c) {
            return s.charCodeAt(c) - 32;
          });
        },
        //compress into uint8array (UCS-2 big endian format)
        compressToUint8Array: function(s) {
          for (var c = u.compress(s), f = new Uint8Array(c.length * 2), d = 0, h = c.length; d < h; d++) {
            var q = c.charCodeAt(d);
            f[d * 2] = q >>> 8, f[d * 2 + 1] = q % 256;
          }
          return f;
        },
        //decompress from uint8array (UCS-2 big endian format)
        decompressFromUint8Array: function(s) {
          if (s == null)
            return u.decompress(s);
          for (var c = new Array(s.length / 2), f = 0, d = c.length; f < d; f++)
            c[f] = s[f * 2] * 256 + s[f * 2 + 1];
          var h = [];
          return c.forEach(function(q) {
            h.push(r(q));
          }), u.decompress(h.join(""));
        },
        //compress into a string that is already URI encoded
        compressToEncodedURIComponent: function(s) {
          return s == null ? "" : u._compress(s, 6, function(c) {
            return i.charAt(c);
          });
        },
        //decompress from an output of compressToEncodedURIComponent
        decompressFromEncodedURIComponent: function(s) {
          return s == null ? "" : s == "" ? null : (s = s.replace(/ /g, "+"), u._decompress(s.length, 32, function(c) {
            return o(i, s.charAt(c));
          }));
        },
        compress: function(s) {
          return u._compress(s, 16, function(c) {
            return r(c);
          });
        },
        _compress: function(s, c, f) {
          if (s == null) return "";
          var d, h, q = {}, g = {}, m = "", _ = "", S = "", w = 2, p = 3, l = 2, v = [], y = 0, b = 0, P;
          for (P = 0; P < s.length; P += 1)
            if (m = s.charAt(P), Object.prototype.hasOwnProperty.call(q, m) || (q[m] = p++, g[m] = !0), _ = S + m, Object.prototype.hasOwnProperty.call(q, _))
              S = _;
            else {
              if (Object.prototype.hasOwnProperty.call(g, S)) {
                if (S.charCodeAt(0) < 256) {
                  for (d = 0; d < l; d++)
                    y = y << 1, b == c - 1 ? (b = 0, v.push(f(y)), y = 0) : b++;
                  for (h = S.charCodeAt(0), d = 0; d < 8; d++)
                    y = y << 1 | h & 1, b == c - 1 ? (b = 0, v.push(f(y)), y = 0) : b++, h = h >> 1;
                } else {
                  for (h = 1, d = 0; d < l; d++)
                    y = y << 1 | h, b == c - 1 ? (b = 0, v.push(f(y)), y = 0) : b++, h = 0;
                  for (h = S.charCodeAt(0), d = 0; d < 16; d++)
                    y = y << 1 | h & 1, b == c - 1 ? (b = 0, v.push(f(y)), y = 0) : b++, h = h >> 1;
                }
                w--, w == 0 && (w = Math.pow(2, l), l++), delete g[S];
              } else
                for (h = q[S], d = 0; d < l; d++)
                  y = y << 1 | h & 1, b == c - 1 ? (b = 0, v.push(f(y)), y = 0) : b++, h = h >> 1;
              w--, w == 0 && (w = Math.pow(2, l), l++), q[_] = p++, S = String(m);
            }
          if (S !== "") {
            if (Object.prototype.hasOwnProperty.call(g, S)) {
              if (S.charCodeAt(0) < 256) {
                for (d = 0; d < l; d++)
                  y = y << 1, b == c - 1 ? (b = 0, v.push(f(y)), y = 0) : b++;
                for (h = S.charCodeAt(0), d = 0; d < 8; d++)
                  y = y << 1 | h & 1, b == c - 1 ? (b = 0, v.push(f(y)), y = 0) : b++, h = h >> 1;
              } else {
                for (h = 1, d = 0; d < l; d++)
                  y = y << 1 | h, b == c - 1 ? (b = 0, v.push(f(y)), y = 0) : b++, h = 0;
                for (h = S.charCodeAt(0), d = 0; d < 16; d++)
                  y = y << 1 | h & 1, b == c - 1 ? (b = 0, v.push(f(y)), y = 0) : b++, h = h >> 1;
              }
              w--, w == 0 && (w = Math.pow(2, l), l++), delete g[S];
            } else
              for (h = q[S], d = 0; d < l; d++)
                y = y << 1 | h & 1, b == c - 1 ? (b = 0, v.push(f(y)), y = 0) : b++, h = h >> 1;
            w--, w == 0 && (w = Math.pow(2, l), l++);
          }
          for (h = 2, d = 0; d < l; d++)
            y = y << 1 | h & 1, b == c - 1 ? (b = 0, v.push(f(y)), y = 0) : b++, h = h >> 1;
          for (; ; )
            if (y = y << 1, b == c - 1) {
              v.push(f(y));
              break;
            } else b++;
          return v.join("");
        },
        decompress: function(s) {
          return s == null ? "" : s == "" ? null : u._decompress(s.length, 32768, function(c) {
            return s.charCodeAt(c);
          });
        },
        _decompress: function(s, c, f) {
          var d = [], h = 4, q = 4, g = 3, m = "", _ = [], S, w, p, l, v, y, b, P = { val: f(0), position: c, index: 1 };
          for (S = 0; S < 3; S += 1)
            d[S] = S;
          for (p = 0, v = Math.pow(2, 2), y = 1; y != v; )
            l = P.val & P.position, P.position >>= 1, P.position == 0 && (P.position = c, P.val = f(P.index++)), p |= (l > 0 ? 1 : 0) * y, y <<= 1;
          switch (p) {
            case 0:
              for (p = 0, v = Math.pow(2, 8), y = 1; y != v; )
                l = P.val & P.position, P.position >>= 1, P.position == 0 && (P.position = c, P.val = f(P.index++)), p |= (l > 0 ? 1 : 0) * y, y <<= 1;
              b = r(p);
              break;
            case 1:
              for (p = 0, v = Math.pow(2, 16), y = 1; y != v; )
                l = P.val & P.position, P.position >>= 1, P.position == 0 && (P.position = c, P.val = f(P.index++)), p |= (l > 0 ? 1 : 0) * y, y <<= 1;
              b = r(p);
              break;
            case 2:
              return "";
          }
          for (d[3] = b, w = b, _.push(b); ; ) {
            if (P.index > s)
              return "";
            for (p = 0, v = Math.pow(2, g), y = 1; y != v; )
              l = P.val & P.position, P.position >>= 1, P.position == 0 && (P.position = c, P.val = f(P.index++)), p |= (l > 0 ? 1 : 0) * y, y <<= 1;
            switch (b = p) {
              case 0:
                for (p = 0, v = Math.pow(2, 8), y = 1; y != v; )
                  l = P.val & P.position, P.position >>= 1, P.position == 0 && (P.position = c, P.val = f(P.index++)), p |= (l > 0 ? 1 : 0) * y, y <<= 1;
                d[q++] = r(p), b = q - 1, h--;
                break;
              case 1:
                for (p = 0, v = Math.pow(2, 16), y = 1; y != v; )
                  l = P.val & P.position, P.position >>= 1, P.position == 0 && (P.position = c, P.val = f(P.index++)), p |= (l > 0 ? 1 : 0) * y, y <<= 1;
                d[q++] = r(p), b = q - 1, h--;
                break;
              case 2:
                return _.join("");
            }
            if (h == 0 && (h = Math.pow(2, g), g++), d[b])
              m = d[b];
            else if (b === q)
              m = w + w.charAt(0);
            else
              return null;
            _.push(m), d[q++] = w + m.charAt(0), h--, w = m, h == 0 && (h = Math.pow(2, g), g++);
          }
        }
      };
      return u;
    }();
    t != null ? t.exports = e : typeof angular < "u" && angular != null && angular.module("LZString", []).factory("LZString", function() {
      return e;
    });
  }(Vt)), Vt.exports;
}
var fc = dc();
const $a = /* @__PURE__ */ Ja(fc), pc = {
  name: "LivedataPersistentConfiguration",
  inject: ["logic"],
  props: {
    // Whether to store the config in the url
    urlSearchParam: {
      type: Boolean,
      default: !0
    },
    // Whether to store the config in the localStorage
    localStorage: {
      type: Boolean,
      default: !1
    }
  },
  computed: {
    data() {
      return this.logic.data;
    },
    // The following computed properties, prefixed by "$_",
    // are the values that are going to be stored.
    // They also have setters so that it can easily be set
    // and update the current config on load
    /* eslint camelcase: ["error", { allow: ["^\\$_"] }] */
    // Filters
    $_filters: {
      get() {
        return this.data.query.filters;
      },
      set(t) {
        this.data.query.filters = t;
      }
    },
    // Sort
    $_sort: {
      get() {
        return this.data.query.sort;
      },
      set(t) {
        this.data.query.sort = t;
      }
    },
    // Pagination offset
    $_offset: {
      get() {
        return this.data.query.offset;
      },
      set(t) {
        this.data.query.offset = t;
      }
    },
    // Pagination limit
    $_limit: {
      get() {
        return this.data.query.limit;
      },
      set(t) {
        this.data.query.limit = t;
      }
    },
    // Current layout id
    $_currentLayoutId: {
      get() {
        return this.logic.currentLayoutId.value;
      },
      set(t) {
        this.logic.currentLayoutId.value = t;
      }
    },
    // Property order
    $_propertyOrder: {
      get() {
        return this.data.query.properties;
      },
      set(t) {
        this.data.query.properties = t;
      }
    },
    // Property visibility
    $_propertyVisibility: {
      get() {
        return this.data.query.properties.reduce(
          (t, e) => this.logic.isPropertyVisible(e) ? t : t.concat(e),
          []
        );
      },
      set(t) {
        this.data.query.properties.forEach((e) => {
          this.logic.setPropertyVisible(e, !t.includes(e));
        });
      }
    },
    // Return the u-node domain used to encode properties
    encodingSpecsProperties() {
      const t = this.data.query.properties.slice().sort();
      return ["oneOf"].concat(t);
    },
    // Return the u-node domain used to encode operators
    encodingSpecsFilterOperators() {
      const t = [];
      return this.data.meta.filters.forEach((e) => {
        (e.operators || []).forEach((r) => {
          t.includes(r.id) || t.push(r.id);
        });
      }), ["oneOf"].concat(t);
    },
    // Return the u-node domain used to encode layouts
    encodingSpecsCurrentLayoutId() {
      return ["oneOf"].concat(this.logic.getLayoutIds());
    },
    // The whole specs used to encode the config
    // More detail about u-node can be found at:
    // https://github.com/ananthakumaran/u
    // The keys of the properties are the computed property names defined above,
    // so that we can retreive the computed property and use it to get and set
    // the values during encoding and decoding
    encodingSpecsV1() {
      return {
        $_filters: ["array", {
          property: this.encodingSpecsProperties,
          matchAll: ["boolean"],
          constraints: ["array", {
            operator: this.encodingSpecsFilterOperators,
            value: ["varchar"]
          }]
        }],
        $_sort: ["array", {
          property: this.encodingSpecsProperties,
          descending: ["boolean"]
        }],
        $_offset: ["integer"],
        $_limit: ["integer"],
        $_currentLayoutId: this.encodingSpecsCurrentLayoutId,
        $_propertyOrder: ["array", this.encodingSpecsProperties],
        $_propertyVisibility: ["array", this.encodingSpecsProperties]
      };
    },
    // The coders that are going to be used for encoding the config
    // It is an array so that we can specify several encoding specs.
    // Using several encoding specs can be usefull to keep backward
    // compability between two different versions of encodings.
    coders() {
      return [
        // the first parameter is the encoding version
        Yt.fromJson(1, this.encodingSpecsV1)
      ];
    },
    // Get the whole object of data that need to be saved
    // Use the encodingSpecs object and the computed properties getters
    // to map the specs keys to the values to save
    dataToSave() {
      const t = {};
      for (const e in this.encodingSpecsV1)
        t[e] = this[e];
      return t;
    },
    // The data to save fully encoded
    encodedConfig() {
      return this.encodeConfig(this.dataToSave);
    },
    // The key where to save the encoded config
    // (in the url query param and localStorage)
    saveKey() {
      return "livedata-config-" + this.data.id;
    }
  },
  watch: {
    // Watch for any changes from the data we want to save
    // We are watching for the encoded config chagnes, because
    // it means that the data to save has changed too
    // On changes, either save or delete config
    encodedConfig() {
      this.encodedConfig ? this.saveConfig(this.saveKey, this.encodedConfig) : this.deleteConfig(this.saveKey);
    }
  },
  methods: {
    // Fully encode the provided config
    // - First: encode it using u-node encode function, so that it takes
    //   much less space
    // - Second: compresse the encoded config using lz-string. The resulted
    //   string might be a bit longer, but any plain text is now hashed
    // On error, return emty string, that will delete existing config.
    encodeConfig(t) {
      try {
        const e = Yt.encode(this.coders[this.coders.length - 1], t);
        return $a.compressToEncodedURIComponent(e);
      } catch (e) {
        return console.warn(e), "";
      }
    },
    // Fully decode the provided encoded config
    // First: uncompress the encoded config using lz-string
    // Second: decode the uncompressed config using u-node
    // On error, return undefined
    decodeConfig(t) {
      if (!t)
        return;
      const e = $a.decompressFromEncodedURIComponent(t);
      if (e)
        try {
          return Yt.decode(this.coders, e);
        } catch (r) {
          console.warn(r);
        }
    },
    // Save the specified config at the specified saveKey
    // This is used to save `this.encodedConfig` at `this.saveKey`
    saveConfig(t, e) {
      if (this.urlSearchParam) {
        const r = new URL(window.location);
        r.searchParams.set(t, e), history.replaceState(null, "", r.href);
      }
      this.localStorage && window.localStorage.setItem(t, e);
    },
    // Get the encoded config saved at the specified saveKey
    getConfig(t) {
      let e = "";
      return this.urlSearchParam && (e = new URLSearchParams(window.location.search).get(t)), !e && this.localStorage && (e = window.localStorage.getItem(t)), e;
    },
    // Return whether a config can be found at the specified save key
    // either in the url or the localstorage
    // It does not verify if the config is valid
    // or if the saveKey is already used for something else
    hasConfig(t) {
      return !!(this.urlSearchParam && new URLSearchParams(window.location.search).has(t) || this.localStorage && window.localStorage.getItm(t) !== null);
    },
    // Load the given config object
    // Update the Livedata config using the computed value setters
    // defined for the properties to save
    loadConfig(t) {
      Object.keys(this.dataToSave).forEach((e) => {
        this[e] = t[e];
      });
    },
    // Delete config at the specified saveKey
    // It does not verify if the config is valid
    // or if the saveKey is already used for something else
    deleteConfig(t) {
      if (this.urlSearchParam) {
        const e = new URL(window.location);
        e.searchParams.delete(t), history.replaceState(null, "", e.href);
      }
      this.localStorage && window.localStorage.removeItem(t);
    }
  },
  // On mounted, get config if any, and load it
  mounted() {
    if (!this.hasConfig(this.saveKey))
      return;
    const t = this.decodeConfig(this.getConfig(this.saveKey));
    if (!t) {
      this.deleteConfig(t), new XWiki.widgets.Notification("Bad LiveData config given, fall back to default");
      return;
    }
    this.loadConfig(t);
  }
}, hc = { key: 0 };
function vc(t, e, r, n, i, a) {
  return a.data.id ? Q((A(), x("div", hc, null, 512)), [
    [J, !1]
  ]) : K("", !0);
}
const yc = /* @__PURE__ */ X(pc, [["render", vc]]), gc = {
  name: "LivedataFootnotes",
  inject: ["logic"],
  data() {
    return {
      footnotes: this.logic.footnotes
    };
  }
}, _c = { class: "footnotes" };
function bc(t, e, r, n, i, a) {
  return A(), x("div", _c, [
    (A(!0), x(re, null, te(i.footnotes.list(), (o) => (A(), x("div", {
      key: `footnote-${o.prefix}-${o.translationKey}`,
      class: "box infomessage footnote"
    }, [
      e[0] || (e[0] = ee(" (")),
      O("small", null, C(o.symbol), 1),
      ee(") " + C(t.$t(o.translationKey)), 1)
    ]))), 128))
  ]);
}
const mc = /* @__PURE__ */ X(gc, [["render", bc], ["__scopeId", "data-v-0055aa78"]]), qc = {
  name: "XWikiLivedata",
  inject: ["logic"],
  components: {
    LivedataAdvancedPanels: As,
    LivedataLayout: Ls,
    LivedataPersistentConfiguration: yc,
    LivedataFootnotes: mc
  },
  computed: {
    dataId() {
      return this.logic.data.id;
    },
    // The id of the layout to be displayed
    layoutId() {
      return this.logic.currentLayoutId.value;
    }
  },
  data() {
    return {
      layoutLoaded: !1,
      translationsLoaded: !1
    };
  },
  mounted() {
    this.logic.onEvent("layoutLoaded", () => {
      this.layoutLoaded = !0;
    }), this.logic.translationsLoaded().finally(() => {
      this.translationsLoaded = !0;
    });
  }
}, Pc = { class: "xwiki-livedata" }, Sc = {
  key: 3,
  class: "loading"
};
function wc(t, e, r, n, i, a) {
  const o = R("LivedataAdvancedPanels"), u = R("LivedataLayout"), s = R("LivedataFootnotes"), c = R("LivedataPersistentConfiguration");
  return A(), x("div", Pc, [
    k(o),
    i.translationsLoaded ? (A(), G(u, {
      key: 0,
      "layout-id": a.layoutId
    }, null, 8, ["layout-id"])) : K("", !0),
    i.layoutLoaded ? (A(), G(s, { key: 1 })) : K("", !0),
    a.dataId ? (A(), G(c, { key: 2 })) : K("", !0),
    i.layoutLoaded ? K("", !0) : (A(), x("div", Sc))
  ]);
}
const Ec = /* @__PURE__ */ X(qc, [["render", wc]]);
function Ac(t) {
  let e = `${XWiki.contextPath}/rest/liveData/sources/`, r, n = async function(g) {
    const m = await Do("jquery");
    let _ = o(g.source), S = {
      properties: g.properties,
      offset: g.offset,
      limit: g.limit
    };
    return S.matchAll = [], g.filters.forEach((w) => {
      w.matchAll && S.matchAll.push(w.property), S["filters." + w.property] = w.constraints.filter((p) => p.value !== void 0).map((p) => (p.operator === void 0 && (p.operator = ""), p)).map((p) => p.operator + ":" + p.value);
    }), S.sort = g.sort.map((w) => w.property), S.descending = g.sort.map((w) => w.descending), r?.abort(), r = m.getJSON(_, m.param(S, !0)), Promise.resolve(r.then(a)).finally(u.bind(null, r));
  };
  const i = function(g, m) {
    t.each(m, (_, S) => {
      _ !== "id" && (g["sourceParams." + _] = S);
    });
  }, a = function(g) {
    return {
      count: g.count,
      entries: g.entries.map((m) => m.values)
    };
  }, o = function(g) {
    let m = e + encodeURIComponent(g.id) + "/entries";
    return s(g, m);
  };
  function u(g) {
    g === r && (r = null);
  }
  function s(g, m) {
    let _ = {
      // Make sure the response is not retrieved from cache (IE11 doesn't obey the caching HTTP
      // headers).
      timestamp: (/* @__PURE__ */ new Date()).getTime(),
      namespace: `wiki:${encodeURIComponent(XWiki.currentWiki)}`
    };
    return i(_, g), `${m}?${t.param(_, !0)}`;
  }
  function c(g, m, _) {
    const S = encodeURIComponent(g.id), w = encodeURIComponent(m), p = encodeURIComponent(_), l = `${e}${S}/entries/${w}/properties/${p}`;
    return s(g, l);
  }
  function f(g, m) {
    const _ = encodeURIComponent(g.id), S = encodeURIComponent(m), w = `${e}${_}/entries/${S}`;
    return s(g, w);
  }
  const d = function(g, m) {
    return Promise.resolve(t.post(o(g), m).then((_) => _.values));
  };
  function h(g, m, _) {
    return Promise.resolve(t.ajax({
      type: "PUT",
      url: f(g, m),
      contentType: "application/json",
      data: JSON.stringify({ values: _ })
    }));
  }
  function q(g, m, _, S) {
    return Promise.resolve(t.ajax({
      type: "PUT",
      url: c(g, m, _),
      contentType: "text/plain",
      data: `${S}`
    }));
  }
  return {
    getEntries: n,
    addEntry: d,
    updateEntry: h,
    updateEntryProperty: q
  };
}
class Oc {
  constructor() {
    this._footnotes = Z([]);
  }
  /**
   * Register a new footnote. If a footnote with the same translationKey is already registered this
   * method has no effect on the list of registered footnotes.
   * @param symbol the symbol to identify the entries related to the footnote
   * @param translationKey the translation key of the footnote text
   */
  put(e, r) {
    this._footnotes.some((n) => n.translationKey === r) || this._footnotes.push({ symbol: e, translationKey: r });
  }
  reset() {
    this._footnotes.splice(0);
  }
  list() {
    return this._footnotes;
  }
}
var Zt = { exports: {} }, Wa;
function Tc() {
  return Wa || (Wa = 1, function(t) {
    var e = Object.prototype.hasOwnProperty, r = "~";
    function n() {
    }
    Object.create && (n.prototype = /* @__PURE__ */ Object.create(null), new n().__proto__ || (r = !1));
    function i(s, c, f) {
      this.fn = s, this.context = c, this.once = f || !1;
    }
    function a(s, c, f, d, h) {
      if (typeof f != "function")
        throw new TypeError("The listener must be a function");
      var q = new i(f, d || s, h), g = r ? r + c : c;
      return s._events[g] ? s._events[g].fn ? s._events[g] = [s._events[g], q] : s._events[g].push(q) : (s._events[g] = q, s._eventsCount++), s;
    }
    function o(s, c) {
      --s._eventsCount === 0 ? s._events = new n() : delete s._events[c];
    }
    function u() {
      this._events = new n(), this._eventsCount = 0;
    }
    u.prototype.eventNames = function() {
      var c = [], f, d;
      if (this._eventsCount === 0) return c;
      for (d in f = this._events)
        e.call(f, d) && c.push(r ? d.slice(1) : d);
      return Object.getOwnPropertySymbols ? c.concat(Object.getOwnPropertySymbols(f)) : c;
    }, u.prototype.listeners = function(c) {
      var f = r ? r + c : c, d = this._events[f];
      if (!d) return [];
      if (d.fn) return [d.fn];
      for (var h = 0, q = d.length, g = new Array(q); h < q; h++)
        g[h] = d[h].fn;
      return g;
    }, u.prototype.listenerCount = function(c) {
      var f = r ? r + c : c, d = this._events[f];
      return d ? d.fn ? 1 : d.length : 0;
    }, u.prototype.emit = function(c, f, d, h, q, g) {
      var m = r ? r + c : c;
      if (!this._events[m]) return !1;
      var _ = this._events[m], S = arguments.length, w, p;
      if (_.fn) {
        switch (_.once && this.removeListener(c, _.fn, void 0, !0), S) {
          case 1:
            return _.fn.call(_.context), !0;
          case 2:
            return _.fn.call(_.context, f), !0;
          case 3:
            return _.fn.call(_.context, f, d), !0;
          case 4:
            return _.fn.call(_.context, f, d, h), !0;
          case 5:
            return _.fn.call(_.context, f, d, h, q), !0;
          case 6:
            return _.fn.call(_.context, f, d, h, q, g), !0;
        }
        for (p = 1, w = new Array(S - 1); p < S; p++)
          w[p - 1] = arguments[p];
        _.fn.apply(_.context, w);
      } else {
        var l = _.length, v;
        for (p = 0; p < l; p++)
          switch (_[p].once && this.removeListener(c, _[p].fn, void 0, !0), S) {
            case 1:
              _[p].fn.call(_[p].context);
              break;
            case 2:
              _[p].fn.call(_[p].context, f);
              break;
            case 3:
              _[p].fn.call(_[p].context, f, d);
              break;
            case 4:
              _[p].fn.call(_[p].context, f, d, h);
              break;
            default:
              if (!w) for (v = 1, w = new Array(S - 1); v < S; v++)
                w[v - 1] = arguments[v];
              _[p].fn.apply(_[p].context, w);
          }
      }
      return !0;
    }, u.prototype.on = function(c, f, d) {
      return a(this, c, f, d, !1);
    }, u.prototype.once = function(c, f, d) {
      return a(this, c, f, d, !0);
    }, u.prototype.removeListener = function(c, f, d, h) {
      var q = r ? r + c : c;
      if (!this._events[q]) return this;
      if (!f)
        return o(this, q), this;
      var g = this._events[q];
      if (g.fn)
        g.fn === f && (!h || g.once) && (!d || g.context === d) && o(this, q);
      else {
        for (var m = 0, _ = [], S = g.length; m < S; m++)
          (g[m].fn !== f || h && !g[m].once || d && g[m].context !== d) && _.push(g[m]);
        _.length ? this._events[q] = _.length === 1 ? _[0] : _ : o(this, q);
      }
      return this;
    }, u.prototype.removeAllListeners = function(c) {
      var f;
      return c ? (f = r ? r + c : c, this._events[f] && o(this, f)) : (this._events = new n(), this._eventsCount = 0), this;
    }, u.prototype.off = u.prototype.removeListener, u.prototype.addListener = u.prototype.on, u.prefixed = r, u.EventEmitter = u, t.exports = u;
  }(Zt)), Zt.exports;
}
var Ic = Tc();
const Rc = /* @__PURE__ */ Ja(Ic);
function Lc(t) {
  class e {
    /**
     * Default constructor.
     * @param logic the live data logic instance
     */
    constructor(c) {
      this.eventEmitter = new Rc(), this.editStates = Z({}), this.logic = c;
    }
    /**
     * Initializes the Vue events listeners.
     */
    init() {
      this.eventEmitter.on("start-editing-entry", ({ entryId: c, propertyId: f }) => {
        const d = this.editStates[c] || {}, h = d[f] || {};
        h.editing = !0, d[f] = h, this.editStates[c] = d;
      }), this.eventEmitter.on("cancel-editing-entry", ({ entryId: c, propertyId: f }) => {
        const h = this.editStates[c][f];
        h.editing = !1;
      }), this.eventEmitter.on("save-editing-entry", ({ entryId: c, propertyId: f, content: d }) => {
        const q = this.editStates[c][f];
        q.editing = !1, q.tosave = !0, q.content = d, this.save(c);
      });
    }
    /**
     * Save the changed values of an entry server side.
     * @param entryId the entry id of the entry to save
     */
    save(c) {
      const f = this.editStates[c];
      let d = !1, h;
      for (h in f) {
        const q = f[h], g = q.editing, m = q.tosave;
        if (d = !g && m, d)
          break;
      }
      if (d && h) {
        const q = f[h].content;
        this.logic.setValues({ entryId: c, values: q }).then(() => {
          this.editStates[c] = {};
        }).catch(() => {
          new XWiki.widgets.Notification("The row save action failed.", "error");
        });
      }
    }
    isEditable() {
      for (const c in this.editStates) {
        const f = this.editStates[c];
        for (const d in f)
          if (f[d].editing)
            return !1;
      }
      return !0;
    }
    onAnyEvent(c) {
      for (let f of ["save-editing-entry", "start-editing-entry", "cancel-editing-entry"])
        this.eventEmitter.on(f, c);
    }
    startEvent(c, f) {
      this.eventEmitter.emit("start-editing-entry", {
        entryId: this.logic.getEntryId(c),
        propertyId: f
      });
    }
    cancelEvent(c, f) {
      this.eventEmitter.emit("cancel-editing-entry", {
        entryId: this.logic.getEntryId(c),
        propertyId: f
      });
    }
    saveEvent(c, f, d) {
      this.eventEmitter.emit("save-editing-entry", {
        entryId: this.logic.getEntryId(c),
        propertyId: f,
        content: d
      });
    }
  }
  function r(s, c) {
    u.startEvent(s, c);
  }
  function n(s, c) {
    u.cancelEvent(s, c);
  }
  function i(s, c, f) {
    u.saveEvent(s, c, f);
  }
  function a() {
    return u.isEditable();
  }
  function o(s) {
    u.onAnyEvent(s);
  }
  const u = new e(t);
  return u.init(), { start: r, cancel: n, save: i, isEditable: a, onAnyEvent: o };
}
const ln = function(t) {
  return JSON.parse(JSON.stringify(t));
}, Ka = function(t, e) {
  if (t != null)
    return e.find((r) => r.id === t);
}, xc = function(t, e) {
  const r = e.map((i) => dn(Ka(i.id, t), i)), n = ln(
    t.filter((i) => i.id != null && Ka(i.id, e) == null)
  );
  return r.concat(n);
}, Cc = function(t, e) {
  return e.hasOwnProperty("id") && t.id !== e.id ? ln(e) : (Object.keys(e).forEach((r) => {
    t[r] = dn(t[r], e[r]);
  }), t);
}, dn = function(t, e) {
  return t?.constructor === Object && e?.constructor === Object ? Cc(t, e) : Array.isArray(t) && Array.isArray(e) ? xc(t, e) : e == null ? t : ln(e);
};
function ce(...t) {
  return t?.reduce(dn, null);
}
const za = {
  prefix: "livedata.",
  keys: [
    "dropdownMenu.title",
    "dropdownMenu.actions",
    "dropdownMenu.layouts",
    "dropdownMenu.panels",
    "dropdownMenu.panels.properties",
    "dropdownMenu.panels.sort",
    "dropdownMenu.panels.filter",
    "selection.selectInAllPages",
    "selection.infoBar.selectedCount",
    "selection.infoBar.allSelected",
    "selection.infoBar.allSelectedBut",
    "pagination.label",
    "pagination.label.empty",
    "pagination.currentEntries",
    "pagination.pageSize",
    "pagination.selectPageSize",
    "pagination.page",
    "pagination.first",
    "pagination.previous",
    "pagination.next",
    "pagination.last",
    "action.refresh",
    "action.addEntry",
    "action.columnName.sortable.hint",
    "action.columnName.default.hint",
    "action.resizeColumn.hint",
    "panel.filter.title",
    "panel.filter.noneFilterable",
    "panel.filter.addConstraint",
    "panel.filter.addProperty",
    "panel.filter.delete",
    "panel.filter.deleteAll",
    "panel.properties.title",
    "panel.sort.title",
    "panel.sort.noneSortable",
    "panel.sort.direction.ascending",
    "panel.sort.direction.descending",
    "panel.sort.add",
    "panel.sort.delete",
    "displayer.emptyValue",
    "displayer.link.noValue",
    "displayer.boolean.true",
    "displayer.boolean.false",
    "displayer.xObjectProperty.missingDocumentName.errorMessage",
    "displayer.xObjectProperty.failedToRetrieveField.errorMessage",
    "displayer.actions.edit",
    "displayer.actions.followLink",
    "filter.boolean.label",
    "filter.date.label",
    "filter.list.label",
    "filter.list.emptyLabel",
    "filter.number.label",
    "filter.text.label",
    "footnotes.computedTitle",
    "footnotes.propertyNotViewable",
    "bottombar.noEntries",
    "error.updateEntriesFailed"
  ]
};
function Fc(t, e, r, n) {
  const i = new URLSearchParams({
    locale: e,
    prefix: r
  });
  for (let a of n)
    i.append("key", a);
  return `${t}?${i.toString()}`;
}
async function Mc(t, e, r) {
  const n = `${XWiki.contextPath}/rest/wikis/${encodeURIComponent(
    XWiki.currentWiki
  )}/localization/translations`, i = Fc(n, t, e, r), o = (await (await fetch(i, {
    headers: {
      Accept: "application/json"
    }
  })).json()).translations, u = {};
  for (let s of o)
    u[s.key] = s.rawSource;
  return u;
}
async function Dc(t, e) {
  const r = await Mc(e, za.prefix, za.keys);
  t.global.setLocaleMessage(e, r);
}
function Ya(t) {
  var e, r, n;
  return t.type.indexOf("mouse") !== -1 ? t.clientX : (n = (r = (e = t.touches) === null || e === void 0 ? void 0 : e[0]) === null || r === void 0 ? void 0 : r.clientX) !== null && n !== void 0 ? n : 0;
}
function Va(t) {
  var e, r, n;
  return t.type.indexOf("mouse") !== -1 ? t.clientY : (n = (r = (e = t.touches) === null || e === void 0 ? void 0 : e[0]) === null || r === void 0 ? void 0 : r.clientY) !== null && n !== void 0 ? n : 0;
}
(function() {
  let t = !1;
  try {
    const e = Object.defineProperty({}, "passive", {
      get: function() {
        return t = !0, !0;
      }
    });
    window.addEventListener("test", null, e);
  } catch {
  }
  return t;
})();
const jc = {
  install(t, e) {
    var r = Object.assign({}, {
      // CORE
      touchClass: "",
      namespace: "touch",
      // CLICK/TAP
      disableClick: !1,
      tapTolerance: 10,
      // px
      touchHoldTolerance: 400,
      // ms
      longTapTimeInterval: 400,
      // ms
      rollOverFrequency: 100,
      // ms
      // DRAG
      dragFrequency: 10,
      // ms
      dragOutside: !1,
      // SWIPE
      swipeTolerance: 100,
      // px
      swipeConeSize: 0.75,
      // number between 0 to 1
      // ZOOM
      zoomFrequency: 10,
      // ms
      zoomDistance: 10,
      // px
      zoomInOutDistance: 100
      // px
      // NOTE: When adding props here, update `index.d.ts` as well!!
    }, e);
    function n(p) {
      var l = this.$$touchObj, v = p.type.indexOf("touch") >= 0, y = p.type.indexOf("mouse") >= 0, b = this;
      v && (l.lastTouchStartTime = p.timeStamp), !(y && l.lastTouchStartTime && p.timeStamp - l.lastTouchStartTime < 350) && (l.touchStarted || (q(this), l.touchStarted = !0, l.touchMoved = !1, l.swipeOutBounded = !1, l.isZooming = !1, l.startX = Ya(p), l.startY = Va(p), l.currentX = 0, l.currentY = 0, l.touchStartTime = p.timeStamp, l.hasSwipe = d(l, "swipe") || d(l, "swipe.left") || d(l, "swipe.right") || d(l, "swipe.top") || d(l, "swipe.bottom"), l.hasZoom = d(l, "zoom") || d(l, "zoom.in") || d(l, "zoom.out"), d(l, "hold") && (l.touchHoldTimer = setTimeout(function() {
        l.touchHoldTimer = null, h(p, b, "hold");
      }, l.options.touchHoldTolerance)), h(p, this, "press")));
    }
    function i(p) {
      var l = this.$$touchObj;
      if (l.touchStarted == !0)
        a(p, l, !1);
      else if (d(l, "rollover") && p.clientX != null) {
        var v = p;
        const y = l.element.getBoundingClientRect();
        v.clientX >= y.left && v.clientX <= y.right && v.clientY >= y.top && v.clientY <= y.bottom && a(p, l, !0);
      }
    }
    function a(p, l = null, v = !1) {
      l == null && (l = this.$$touchObj);
      var y = Ya(p), b = Va(p), P = l.currentX != y || l.currentY != b;
      if (l.currentX = y, l.currentY = b, !v)
        if (l.touchMoved) {
          if (l.hasSwipe && !l.swipeOutBounded) {
            var I = l.options.swipeTolerance;
            Math.abs(l.startX - l.currentX) / Math.abs(l.startY - l.currentY) > l.options.swipeConeSize && Math.abs(l.startY - l.currentY) / Math.abs(l.startX - l.currentX) > l.options.swipeConeSize && (l.swipeOutBounded = Math.abs(l.startY - l.currentY) < I && Math.abs(l.startX - l.currentX) < I);
          }
        } else {
          var E = l.options.tapTolerance;
          l.touchMoved = Math.abs(l.startX - l.currentX) > E || Math.abs(l.startY - l.currentY) > E, l.touchMoved && (m(l), h(p, l.element, "drag.once"));
        }
      if (P && d(l, "rollover")) {
        var F = p.timeStamp;
        (l.touchRollTime == null || F > l.touchRollTime + l.options.rollOverFrequency) && (l.touchRollTime = F, h(p, l.element, "rollover"));
      }
      if (!v) {
        if (l.touchStarted && l.touchMoved && P && d(l, "drag")) {
          var F = p.timeStamp;
          (l.touchDragTime == null || F > l.touchDragTime + l.options.dragFrequency) && (l.touchDragTime = F, h(p, l.element, "drag"));
        }
        if (l.touchStarted && l.hasZoom) {
          var F = p.timeStamp;
          (l.touchZoomTime == null || F > l.touchZoomTime + l.options.zoomFrequency) && (l.touchZoomTime = F, o(l, p));
        }
      }
    }
    function o(p, l) {
      const v = l.changedTouches;
      if (v.length !== 2) {
        p.isZooming = !1;
        return;
      }
      const y = Math.sqrt(
        Math.pow(v[0].clientX - v[1].clientX, 2) + // horizontal distance
        Math.pow(v[0].clientY - v[1].clientY, 2)
        // vertical distance
      );
      if (!p.isZooming) {
        p.isZooming = !0, p.initialZoomDistance = y;
        return;
      }
      const b = y / p.initialZoomDistance;
      d(p, "zoom") && Math.abs(b - 1) > p.options.zoomDistance / p.initialZoomDistance && h(l, p.element, "zoom", b), (d(p, "zoom.in") || d(p, "zoom.out")) && Math.abs(y - p.initialZoomDistance) > p.options.zoomInOutDistance && (y > p.initialZoomDistance ? h(l, p.element, "zoom.in") : h(l, p.element, "zoom.out")), p.isZooming = !1;
    }
    function u() {
      var p = this.$$touchObj;
      p.touchStarted == !0 && (m(p), g(this), p.touchStarted = p.touchMoved = !1, p.startX = p.startY = 0);
    }
    function s(p) {
      var l = this.$$touchObj;
      if (l.touchStarted == !0) {
        var v = p.type.indexOf("touch") >= 0, y = p.type.indexOf("mouse") >= 0;
        v && (l.lastTouchEndTime = p.timeStamp);
        var b = v && !l.touchHoldTimer;
        if (m(l), l.touchStarted = !1, g(this), y && l.lastTouchEndTime && p.timeStamp - l.lastTouchEndTime < 350)
          return;
        if (h(p, this, "release"), l.touchMoved) {
          if (l.hasSwipe && !l.swipeOutBounded) {
            var P = l.options.swipeTolerance, E, I = Math.abs(l.startY - l.currentY), F = Math.abs(l.startX - l.currentX);
            (I > P || F > P) && (F > P ? E = l.startX > l.currentX ? "left" : "right" : E = l.startY > l.currentY ? "top" : "bottom", d(l, "swipe." + E) ? h(p, this, "swipe." + E, E) : h(p, this, "swipe", E));
          }
        } else if (d(l, "longtap") && p.timeStamp - l.touchStartTime > l.options.longTapTimeInterval)
          p.cancelable && p.preventDefault(), h(p, this, "longtap");
        else if (d(l, "hold") && b) {
          p.cancelable && p.preventDefault();
          return;
        } else
          h(p, this, "tap");
      }
    }
    function c() {
      q(this);
    }
    function f() {
      g(this);
    }
    function d(p, l) {
      var v = p.callbacks[l];
      return v != null && v.length > 0;
    }
    function h(p, l, v, y) {
      var b = l.$$touchObj, P = b.callbacks[v];
      if (P == null || P.length === 0)
        return null;
      for (var E = 0; E < P.length; E++) {
        var I = P[E];
        I.modifiers.stop && p.stopPropagation(), I.modifiers.prevent && p.preventDefault(), !(I.modifiers.self && p.target !== p.currentTarget) && typeof I.value == "function" && (y ? I.value(y, p) : I.value(p));
      }
    }
    function q(p) {
      var l = p.$$touchObj.options.touchClass;
      l && p.classList.add(l);
    }
    function g(p) {
      var l = p.$$touchObj.options.touchClass;
      l && p.classList.remove(l);
    }
    function m(p) {
      p && p.touchHoldTimer && (clearTimeout(p.touchHoldTimer), p.touchHoldTimer = null);
    }
    function _(p, l) {
      var v = p.$$touchObj || {
        element: p,
        // an object contains all callbacks registered,
        // key is event name, value is an array
        callbacks: {},
        // prevent bind twice, set to true when event bound
        hasBindTouchEvents: !1,
        // default options, would be override by v-touch-options
        options: r,
        events: {}
      };
      return l && (v.options = Object.assign({}, v.options, l)), p.$$touchObj = v, p.$$touchObj;
    }
    function S(p) {
      for (const l in p)
        if (p.hasOwnProperty(l)) {
          const [v, y] = p[l];
          v.addEventListener(l, y);
        }
    }
    function w(p) {
      for (const l in p)
        if (p.hasOwnProperty(l)) {
          const [v, y] = p[l];
          v.removeEventListener(l, y);
        }
    }
    t.directive(r.namespace, {
      beforeMount: function(p, l) {
        var v = _(p), y = l.arg || "tap";
        switch (y) {
          case "swipe":
            var b = l.modifiers;
            if (b.left || b.right || b.top || b.bottom) {
              for (var P in l.modifiers)
                if (["left", "right", "top", "bottom"].indexOf(P) >= 0) {
                  var E = "swipe." + P;
                  v.callbacks[E] = v.callbacks[E] || [], v.callbacks[E].push(l);
                }
            } else
              v.callbacks.swipe = v.callbacks.swipe || [], v.callbacks.swipe.push(l);
            break;
          case "press":
          case "drag":
            l.modifiers.disablePassive;
          default:
            v.callbacks[y] = v.callbacks[y] || [], v.callbacks[y].push(l);
        }
        v.hasBindTouchEvents || (v.options.dragOutside ? (v.events.touchstart = [p, n], v.events.touchmove = [window, i.bind(p)], v.events.touchcancel = [window, u.bind(p)], v.events.touchend = [window, s.bind(p)]) : (v.events.touchstart = [p, n], v.events.touchmove = [p, i], v.events.touchcancel = [p, u], v.events.touchend = [p, s]), v.options.disableClick || (v.options.dragOutside ? (v.events.mousedown = [p, n], v.events.mousemove = [window, i.bind(p)], v.events.mouseup = [window, s.bind(p)], v.events.mouseenter = [p, c], v.events.mouseleave = [p, f]) : (v.events.mousedown = [p, n], v.events.mousemove = [p, a], v.events.mouseup = [p, s], v.events.mouseenter = [p, c], v.events.mouseleave = [p, f])), S(v.events), v.hasBindTouchEvents = !0);
      },
      unmounted: function(p) {
        var l = p.$$touchObj;
        m(l), l && l.events && (w(l.events), l.events = {}), delete p.$$touchObj;
      }
    }), t.directive(`${r.namespace}-class`, {
      beforeMount: function(p, l) {
        _(p, {
          touchClass: l.value
        });
      }
    }), t.directive(`${r.namespace}-options`, {
      beforeMount: function(p, l) {
        _(p, l.value);
      }
    });
  }
};
class kc {
  constructor(e, r) {
    this.liveDataSource = Ac(r), this.element = e, this.data = Z(JSON.parse(e.getAttribute("data-config") || "{}")), this.contentTrusted = e.getAttribute("data-config-content-trusted") === "true", this.firstEntriesLoading = pn(!0), this.currentLayoutId = pn(""), this.changeLayout(this.data.meta.defaultLayout), this.entrySelection = Z({
      selected: [],
      deselected: [],
      isGlobal: !1
    }), this.openedPanels = Z([]), this.footnotes = new Oc(), this.panels = Z([]), e.removeAttribute("data-config");
    const n = document.createElement("div");
    this.element.appendChild(n);
    const i = this, a = document.documentElement.getAttribute("lang"), o = jo({ legacy: !1, locale: a });
    this.i18nPromise = Dc(o, a).then(() => !0).catch(() => !1), this.vueInstance = Fo(Ec).mixin({
      mounted() {
        e.classList.remove("loading"), this.$nextTick(function() {
          i.triggerEvent("instanceCreated", {});
        });
      }
    }).provide("logic", this).provide("jQuery", r).use(o).use(jc).mount(e), this.data.data.entries.length ? this.firstEntriesLoading.value = !1 : this.updateEntries().finally(() => this.firstEntriesLoading.value = !1), this.setEditBus(Lc(this)), this.translate = async (u, ...s) => (await this.translationsLoaded(), o.global.t(u, s)), this.translationsLoaded = async () => {
      await this.i18nPromise;
    }, this.translationsLoaded().finally(() => {
      this.registerPanel({
        id: "propertiesPanel",
        title: o.global.t("livedata.panel.properties.title"),
        name: o.global.t("livedata.dropdownMenu.panels.properties"),
        icon: "list-bullets",
        component: "LivedataAdvancedPanelProperties",
        order: 1e3
      }), this.registerPanel({
        id: "sortPanel",
        title: o.global.t("livedata.panel.sort.title"),
        name: o.global.t("livedata.dropdownMenu.panels.sort"),
        icon: "table_sort",
        component: "LivedataAdvancedPanelSort",
        order: 2e3
      }), this.registerPanel({
        id: "filterPanel",
        title: o.global.t("livedata.panel.filter.title"),
        name: o.global.t("livedata.dropdownMenu.panels.filter"),
        icon: "filter",
        component: "LivedataAdvancedPanelFilter",
        order: 3e3
      });
    });
  }
  /**
   * ---------------------------------------------------------------
   * EVENTS
   */
  /**
   * Send custom events
   * @param {String} eventName The name of the event, without the prefix "xwiki:livedata"
   * @param {Object} eventData The data associated with the event.
   *  The livedata object reference is automatically added
   */
  triggerEvent(e, r) {
    const n = {
      livedata: this
    };
    e = "xwiki:livedata:" + e, r = {
      bubbles: !0,
      detail: Object.assign(n, r)
    };
    const i = new CustomEvent(e, r);
    this.element.dispatchEvent(i);
  }
  /**
   * Listen for custom events
   * @param {String} eventName The name of the event, without the prefix "xwiki:livedata"
   * @param {Function} callback Function to call we the event is triggered: e => { ... }
   */
  onEvent(e, r) {
    e = "xwiki:livedata:" + e, this.element.addEventListener(e, function(n) {
      r(n);
    });
  }
  /**
   * Listen for custom events, mathching certain conditions
   * @param {String} eventName The name of the event, without the prefix "xwiki:livedata"
   * @param {Object|Function} condition The condition to execute the callback
   *  if Object, values of object properties must match e.detail properties values
   *  if Function, the function must return true. e.detail is passed as argument
   * @param {Function} callback Function to call we the event is triggered: e => { ... }
   */
  onEventWhere(e, r, n) {
    e = "xwiki:livedata:" + e, this.element.addEventListener(e, function(i) {
      if (typeof r == "object") {
        const a = (o, u) => Object.keys(o).every((s) => typeof o[s] == "object" ? a(o[s], u?.[s]) : Object.is(o[s], u?.[s]));
        if (!a(r, i.detail))
          return;
      }
      typeof r == "function" && !r(i.detail) || n(i);
    });
  }
  /**
   * ---------------------------------------------------------------
   * UTILS
   */
  /**
   * Return the list of layout ids
   * @returns {Array}
   */
  getLayoutIds() {
    return this.data.meta.layouts.map((e) => e.id);
  }
  /**
   * Return the id of the given entry
   * @param {Object} entry
   * @returns {String}
   */
  getEntryId(e) {
    const r = this.data.meta.entryDescriptor.idProperty || "id";
    if (e[r] === void 0) {
      console.warn("Entry has no id (at property [" + r + "]", e);
      return;
    }
    return e[r];
  }
  /*
    As Sets are not reactive in Vue 2.x, if we want to create
    a reactive collection of unique objects, we have to use arrays.
    So here are some handy functions to do what Sets do, but with arrays
  */
  /**
   * Return whether the array has the given item
   * @param {Array} uniqueArray An array of unique items
   * @param {Any} item
   */
  uniqueArrayHas(e, r) {
    return e.includes(r);
  }
  /**
   * Add the given item if not present in the array, or does nothing
   * @param {Array} uniqueArray An array of unique items
   * @param {Any} item
   */
  uniqueArrayAdd(e, r) {
    this.uniqueArrayHas(e, r) || e.push(r);
  }
  /**
   * Remove the given item from the array if present, or does nothing
   * @param {Array} uniqueArray An array of unique items
   * @param {Any} item
   */
  uniqueArrayRemove(e, r) {
    const n = e.indexOf(r);
    n !== -1 && e.splice(n, 1);
  }
  /**
   * Toggle the given item from the array, ensuring its uniqueness
   * @param {Array} uniqueArray An array of unique items
   * @param {Any} item
   * @param {Boolean} force Optional: true force add / false force remove
   */
  uniqueArrayToggle(e, r, n) {
    n === void 0 && (n = !this.uniqueArrayHas(e, r)), n ? this.uniqueArrayAdd(e, r) : this.uniqueArrayRemove(e, r);
  }
  /**
   * ---------------------------------------------------------------
   * DESCRIPTORS
   */
  /**
   * Returns the property descriptors of displayable properties
   * @returns {Array}
   */
  getPropertyDescriptors() {
    return this.data.query.properties.map((e) => this.getPropertyDescriptor(e));
  }
  /**
   * Return the property descriptor corresponding to a property id
   * @param {String} propertyId
   * @returns {Object}
   */
  getPropertyDescriptor(e) {
    const r = this.data.meta.propertyDescriptors.find((n) => n.id === e);
    return r || console.error("Property descriptor of property `" + e + "` does not exist"), r;
  }
  /**
   * Return the property type descriptor corresponding to a property id
   * @param {String} propertyId
   * @returns {Object}
   */
  getPropertyTypeDescriptor(e) {
    const r = this.getPropertyDescriptor(e);
    if (r)
      return this.data.meta.propertyTypes.find((n) => n.id === r.type);
  }
  /**
   * Return the layout descriptor corresponding to a layout id
   * @param {String} propertyId
   * @returns {Object}
   */
  getLayoutDescriptor(e) {
    return this.data.meta.layouts.find((r) => r.id === e);
  }
  /**
   * Get the displayer descriptor associated to a property id
   * @param {String} propertyId
   * @returns {Object}
   */
  getDisplayerDescriptor(e) {
    const r = this.getPropertyDescriptor(e), n = this.getPropertyTypeDescriptor(e), i = ce(
      {},
      n?.displayer,
      r?.displayer
    ), a = i.id || this.data.meta.defaultDisplayer, o = this.data.meta.displayers.find(
      (u) => u.id === a
    );
    return ce({}, o, i);
  }
  /**
   * Get the filter descriptor associated to a property id
   * @param {String} propertyId
   * @returns {Object}
   */
  getFilterDescriptor(e) {
    const r = this.getPropertyDescriptor(e), n = this.getPropertyTypeDescriptor(e), i = ce(
      {},
      n?.filter,
      r?.filter
    ), a = i.id || this.data.meta.defaultFilter, o = this.data.meta.filters.find((u) => u.id === a);
    return ce({}, o, i);
  }
  /**
   * ---------------------------------------------------------------
   * LAYOUT
   */
  /**
   * Fetch the entries of the current page according to the query configuration.
   * @returns the fetched entries
   */
  fetchEntries() {
    return this.triggerEvent("beforeEntryFetch"), this.liveDataSource.getEntries(this.data.query).then((e) => e).finally(() => this.triggerEvent("afterEntryFetch"));
  }
  updateEntries() {
    return this.fetchEntries().then((e) => {
      this.data.data = e;
      const r = this.getPropertyDescriptors().filter((n) => this.isPropertyVisible(n.id)).map((n) => Qa.load("displayer", this.getDisplayerDescriptor(n.id).id));
      Promise.all(r).then(() => {
        this.vueInstance.$nextTick(() => this.triggerEvent("entriesUpdated", {}));
      }), this.footnotes.reset();
    }).catch((e) => {
      e.readyState === 4 && this.translate("livedata.error.updateEntriesFailed").then((r) => new XWiki.widgets.Notification(r, "error")), e.statusText !== "abort" && console.error("Failed to fetch the entries", e);
    });
  }
  /**
   * Return whether the Livedata is editable or not
   * if entry given, return whether it is editable
   * if property given, return whether it is editable (for any entries)
   * If entry and property given, return whether specific value is editable
   * @param {Object} [parameters]
   * @param {Object} [parameters.entry] The entry object
   * @param {Number} [parameters.propertyId] The property id of the entry
   */
  isEditable({ entry: e, propertyId: r } = {}) {
    return !this.data.meta.actions.find((n) => n.id === "edit") || e && !this.isEntryEditable(e) ? !1 : !r || this.isPropertyEditable(r);
  }
  /**
   * Returns whether the given entry is editable or not.
   *
   * @param {Object} entry
   * @returns {Boolean}
   */
  isEntryEditable(e) {
    return this.isActionAllowed("edit", e);
  }
  /**
   * Returns whether a certain property is editable or not.
   *
   * @param {String} propertyId
   * @returns {Boolean}
   */
  isPropertyEditable(e) {
    const r = this.getPropertyDescriptor(e), n = this.getPropertyTypeDescriptor(e);
    return r && (r.editable !== void 0 ? r.editable : n && n.editable);
  }
  /**
   * Set the value of the given entry property
   * @param {Object} parameters
   * @param {Object} parameters.entry The entry we want to modify
   * @param {number} parameters.propertyId The property id we want to modify in the entry
   * @param {string} parameters.value The new value of entry property
   */
  setValue({ entry: e, propertyId: r, value: n }) {
    if (!this.isEditable({ entry: e, propertyId: r }))
      return;
    e[r] = n;
    const i = this.data.query.source, a = this.getEntryId(e);
    this.liveDataSource.updateEntryProperty(i, a, r, e[r]).then(() => this.updateEntries());
  }
  /**
   * Update the entry with the values object passed in parameter and s
   * @param {Object} entry the current entry
   * @param {Object} values the entry's values to update
   */
  setValues({ entryId: e, values: r }) {
    const n = this.data.query.source;
    return this.liveDataSource.updateEntry(n, e, r).then(() => this.updateEntries());
  }
  /**
   * Return whether adding new entries is enabled.
   */
  canAddEntry() {
    return this.data.meta.actions.find((e) => e.id === "addEntry");
  }
  addEntry() {
    if (!this.canAddEntry())
      return;
    const e = () => this.getEntryId(this.data.data.entries.slice(-1)[0]) + "0";
    Promise.resolve({
      /* MOCK DATA */
      doc_url: e(),
      doc_name: void 0,
      doc_date: "1585311660000",
      doc_title: void 0,
      doc_author: "Author 1",
      doc_creationDate: "1585311660000",
      doc_creator: "Creator 1",
      age: void 0,
      tags: void 0,
      country: void 0,
      other: void 0
    }).then((r) => {
      this.data.data.entries.push(r), this.data.data.count++;
    });
  }
  /**
   * ---------------------------------------------------------------
   * LAYOUT
   */
  /**
   * Load a layout, or default layout if none specified
   * @param {String} layoutId The id of the layout to load with requireJS
   * @returns {Promise}
   */
  changeLayout(e) {
    if (!this.getLayoutDescriptor(e)) {
      console.error("Layout of id `" + e + "` does not have a descriptor");
      return;
    }
    const r = this.currentLayoutId.value;
    this.currentLayoutId.value = e, this.triggerEvent("layoutChange", {
      layoutId: e,
      previousLayoutId: r
    });
  }
  /**
   * ---------------------------------------------------------------
   * PAGINATION
   */
  /**
   * Get total number of pages
   * @returns {Number}
   */
  getPageCount() {
    return Math.ceil(this.data.data.count / this.data.query.limit);
  }
  /**
   * Get the page corresponding to the specified entry (0-based index)
   * @param {Number} entryIndex The index of the entry. Uses current entry if undefined.
   * @returns {Number}
   */
  getPageIndex(e) {
    return e === void 0 && (e = this.data.query.offset), Math.floor(e / this.data.query.limit);
  }
  /**
   * Set page index (0-based index), then fetch new data
   * @param {Number} pageIndex
   * @returns {Promise}
   */
  setPageIndex(e) {
    return new Promise((r, n) => {
      if (e < 0 || e >= this.getPageCount())
        return void n();
      const i = this.getPageIndex();
      this.data.query.offset = this.getFirstIndexOfPage(e), this.triggerEvent("pageChange", {
        pageIndex: e,
        previousPageIndex: i
      }), this.updateEntries().then(r, n);
    });
  }
  /**
   * Get the first entry index of the given page index
   * @param {Number} pageIndex The page index. Uses current page if undefined.
   * @returns {Number}
   */
  getFirstIndexOfPage(e) {
    return e === void 0 && (e = this.getPageIndex()), 0 <= e && e < this.getPageCount() ? e * this.data.query.limit : -1;
  }
  /**
   * Get the last entry index of the given page index
   * @param {Number} pageIndex The page index. Uses current page if undefined.
   * @returns {Number}
   */
  getLastIndexOfPage(e) {
    return e === void 0 && (e = this.getPageIndex()), 0 <= e && e < this.getPageCount() ? Math.min(
      this.getFirstIndexOfPage(e) + this.data.query.limit,
      this.data.data.count
    ) - 1 : -1;
  }
  /**
   * Set the pagination page size, then fetch new data
   * @param {Number} pageSize
   * @returns {Promise}
   */
  setPageSize(e) {
    return new Promise((r, n) => {
      if (e < 0)
        return void n();
      const i = this.data.query.limit;
      if (e === i)
        return void r();
      this.data.query.limit = e, this.data.query.offset = 0, this.triggerEvent("pageSizeChange", {
        pageSize: e,
        previousPageSize: i
      }), this.updateEntries().then(r, n);
    });
  }
  /**
   * ---------------------------------------------------------------
   * DISPLAY
   */
  /**
   * Returns whether a certain property is visible
   * @param {String} propertyId
   * @returns {Boolean}
   */
  isPropertyVisible(e) {
    return this.getPropertyDescriptor(e).visible;
  }
  /**
   * Set whether the given property should be visible
   * @param {String} propertyId
   * @param {Boolean} visible
   */
  setPropertyVisible(e, r) {
    const n = this.getPropertyDescriptor(e);
    n.visible = r;
  }
  /**
   * Move a property to a certain index in the property order list
   * @param {String|Number} from The id or index of the property to move
   * @param {Number} toIndex
   */
  reorderProperty(e, r) {
    let n;
    if (typeof e == "number")
      n = e;
    else if (typeof e == "string")
      n = this.data.query.properties.indexOf(e);
    else
      return;
    n < 0 || r < 0 || this.data.query.properties.splice(
      r,
      0,
      this.data.query.properties.splice(n, 1)[0]
    );
  }
  /**
   * ---------------------------------------------------------------
   * SELECTION
   */
  /**
   * Return whether selecting entries is enabled. If an entry is given, return whether that entry
   * can be selected.
   *
   * @param {Object} [parameters]
   * @param {Object} [parameters.entry]
   */
  isSelectionEnabled({ entry: e } = {}) {
    return this.data.meta.selection.enabled && (!e || this.getEntryId(e));
  }
  /**
   * Return whether the entry is currently selected
   * @param {Object} entry
   * @returns {Boolean}
   */
  isEntrySelected(e) {
    const r = this.getEntryId(e);
    return this.entrySelection.isGlobal ? !this.uniqueArrayHas(this.entrySelection.deselected, r) : this.uniqueArrayHas(this.entrySelection.selected, r);
  }
  /**
   * Select the specified entries
   * @param {Object|Array} entries
   */
  selectEntries(e) {
    if (!this.isSelectionEnabled())
      return;
    (e instanceof Array ? e : [e]).forEach((n) => {
      if (!this.isSelectionEnabled({ entry: n }))
        return;
      const i = this.getEntryId(n);
      this.entrySelection.isGlobal ? this.uniqueArrayRemove(this.entrySelection.deselected, i) : this.uniqueArrayAdd(this.entrySelection.selected, i), this.triggerEvent("select", {
        entry: n
      });
    });
  }
  /**
   * Deselect the specified entries
   * @param {Object|Array} entries
   */
  deselectEntries(e) {
    if (!this.isSelectionEnabled())
      return;
    (e instanceof Array ? e : [e]).forEach((n) => {
      if (!this.isSelectionEnabled({ entry: n }))
        return;
      const i = this.getEntryId(n);
      this.entrySelection.isGlobal ? this.uniqueArrayAdd(this.entrySelection.deselected, i) : this.uniqueArrayRemove(this.entrySelection.selected, i), this.triggerEvent("deselect", {
        entry: n
      });
    });
  }
  /**
   * Toggle the selection of the specified entries
   * @param {Object|Array} entries
   * @param {Boolean} select Whether to select or not the entries. Undefined toggle current state
   */
  toggleSelectEntries(e, r) {
    if (!this.isSelectionEnabled())
      return;
    (e instanceof Array ? e : [e]).forEach((i) => {
      this.isSelectionEnabled({ entry: i }) && (r === void 0 && (r = !this.isEntrySelected(i)), r ? this.selectEntries(i) : this.deselectEntries(i));
    });
  }
  /**
   * Get number of selectable entries in page
   * @returns {Number}
   */
  selectableCountInPage() {
    return this.isSelectionEnabled() ? this.data.data.entries.filter((e) => this.isSelectionEnabled({ entry: e })).length : 0;
  }
  /**
   * Set the entry selection globally accross pages
   * @param {Boolean} global
   */
  setEntrySelectGlobal(e) {
    this.isSelectionEnabled() && (this.entrySelection.isGlobal = e, this.entrySelection.selected.splice(0), this.entrySelection.deselected.splice(0), this.triggerEvent("selectGlobal", {
      state: e
    }));
  }
  /**
   * ---------------------------------------------------------------
   * ACTIONS
   */
  /**
   * @param {String|Object} specifies the action
   * @returns {Object} the descriptor of the specified live data action
   */
  getActionDescriptor(e) {
    const r = typeof e == "string" ? { id: e } : e, n = this.data.meta.actions.find(
      (i) => i.id === r.id
    );
    return ce({}, n, r);
  }
  /**
   * @param {String|Object} specifies the action
   * @param {Object} the live data entry that is the target of the action
   * @returns {Boolean} whether the specified action is allowed to target the specified live data
   *   entry
   */
  isActionAllowed(e, r) {
    const n = this.getActionDescriptor(e);
    return !n.allowProperty || r[n.allowProperty];
  }
  /**
   * ---------------------------------------------------------------
   * SORT
   */
  /**
   * Returns whether a certain property is sortable or not
   * @param {String} propertyId
   * @returns {Boolean}
   */
  isPropertySortable(e) {
    const r = this.getPropertyDescriptor(e), n = this.getPropertyTypeDescriptor(e);
    return r && (r.sortable !== void 0 ? r.sortable : n && n.sortable);
  }
  /**
   * Returns the sortable properties from the live data query.
   *
   * @returns {Array}
   */
  getSortableProperties() {
    return this.data.query.properties.filter((e) => this.isPropertySortable(e));
  }
  /**
   * Returns the sortable properties that don't have a sort entry in the live data query.
   *
   * @returns {Array}
   */
  getUnsortedProperties() {
    return this.getSortableProperties().filter((e) => !this.getQuerySort(e));
  }
  /**
   * Get the sort query associated to a property id
   * @param {String} propertyId
   */
  getQuerySort(e) {
    return this.data.query.sort.find((r) => r.property === e);
  }
  /**
   * Update sort configuration based on parameters, then fetch new data
   * @param {String} property The property to sort according to
   * @param {String} level The sort level for the property (0 is the highest).
   *   Undefined means keep current. Negative value removes property sort.
   * @param {String} descending Specify whether the sort should be descending or not.
   *   Undefined means toggle current direction
   * @returns {Promise}
   */
  sort(e, r, n) {
    const i = new Error("Property `" + e + "` is not sortable");
    return new Promise((a, o) => {
      if (!(r < 0 || this.isPropertySortable(e)))
        return void o(i);
      const u = this.data.query.sort.findIndex(
        (c) => c.property === e
      );
      r === void 0 ? r = u !== -1 ? u : 0 : r < 0 && (r = -1), n === void 0 && (n = u !== -1 ? !this.data.query.sort[u].descending : !1);
      const s = {
        property: e,
        descending: n
      };
      r !== -1 && this.data.query.sort.splice(r, 1, s), u !== -1 && u !== r && this.data.query.sort.splice(u, 1), this.triggerEvent("sort", {
        property: e,
        level: r,
        descending: n
      }), this.updateEntries().then(a, o);
    });
  }
  /**
   * Add new sort entry, shorthand of sort:
   * If the property is already sorting, does nothing
   * @param {String} property The property to add to the sort
   * @param {String} descending Specify whether the sort should be descending or not.
   *   Undefined means toggle current direction
   * @returns {Promise}
   */
  addSort(e, r) {
    const n = new Error("Property `" + e + "` is already sorting");
    return this.data.query.sort.find(
      (a) => a.property === e
    ) ? Promise.reject(n) : this.sort(e, this.data.query.sort.length, r);
  }
  /**
   * Remove a sort entry, shorthand of sort:
   * @param {String} property The property to remove to the sort
   * @returns {Promise}
   */
  removeSort(e) {
    return this.sort(e, -1);
  }
  /**
   * Move a sort entry to a certain index in the query sort list
   * @param {String} property The property to reorder the sort
   * @param {Number} toIndex
   */
  reorderSort(e, r) {
    const n = new Error("Property `" + e + "` is not sortable");
    return new Promise((i, a) => {
      const o = this.data.query.sort.findIndex(
        (u) => u.property === e
      );
      if (o < 0 || r < 0)
        return void a(n);
      this.data.query.sort.splice(r, 0, this.data.query.sort.splice(o, 1)[0]), this.triggerEvent("sort", {
        type: "move",
        property: e,
        level: r
      }), this.updateEntries().then(i, a);
    });
  }
  /**
   * ---------------------------------------------------------------
   * FILTER
   */
  /**
   * Returns whether a certain property is filterable or not
   * @param {String} propertyId
   * @returns {Boolean}
   */
  isPropertyFilterable(e) {
    const r = this.getPropertyDescriptor(e), n = this.getPropertyTypeDescriptor(e);
    return r && (r.filterable !== void 0 ? r.filterable : n && n.filterable);
  }
  /**
   * Returns the filterable properties from the live data query.
   *
   * @returns {Array}
   */
  getFilterableProperties() {
    return this.data.query.properties.filter((e) => this.isPropertyFilterable(e));
  }
  /**
   * Returns the filterable properties that don't have constraints in the live data query.
   *
   * @returns {Array}
   */
  getUnfilteredProperties() {
    return this.getFilterableProperties().filter((e) => {
      const r = this.getQueryFilterGroup(e);
      return !r || r.constraints.length === 0;
    });
  }
  /**
   * Get the filter in the query data object associated to a property id
   * @param {String} propertyId
   * @returns {Object}
   */
  getQueryFilterGroup(e) {
    return this.data.query.filters.find((r) => r.property === e);
  }
  /**
   * Get the filters in the query data object associated to a property id
   * @param {String} propertyId
   * @returns {Array} The constraints array of the filter group, or empty array if it does not exist
   */
  getQueryFilters(e) {
    const r = this.getQueryFilterGroup(e);
    return r && r.constraints || [];
  }
  /**
   * Get the default filter operator associated to a property id
   * @param {String} propertyId
   * @returns {String}
   */
  getFilterDefaultOperator(e) {
    const r = this.getFilterDescriptor(e);
    if (!r)
      return;
    const n = r.operators;
    if (!(n instanceof Array) || n.length === 0)
      return;
    const i = r.defaultOperator, a = !!n.find(
      (o) => o.id === i
    );
    return i && a ? i : n[0].id;
  }
  /**
   * Return an object containing the new and old filter entries corresponding to parameters
   *  oldEntry: the filter entry to be modified
   *  newEntry: what this entry should be modified to
   * @param {String} property The property to filter according to
   * @param {String} index The index of the filter entry
   * @param {String} filterEntry The filter data used to update the filter configuration
   *  (see Logic.prototype.filter for more)
   * @returns {Object} {oldEntry, newEntry}
   *  with oldEntry / newEntry being {property, index, operator, value}
   */
  _computeFilterEntries(e, r, n, { filterOperator: i } = {}) {
    if (!this.isPropertyFilterable(e))
      return;
    r = r || 0, r < 0 && (r = -1), n.index < 0 && (n.index = -1);
    let a = {
      property: e,
      index: r
    };
    const u = this.getQueryFilters(e)[r] || {};
    a = Object.assign({}, u, a);
    let s = Object.fromEntries(Object.entries(n || {}).filter((h) => h[1] !== void 0));
    const c = this, f = {
      property: e,
      value: "",
      operator: c.getFilterDefaultOperator(e),
      index: 0
    };
    return s = Object.assign({}, f, a, s), i && (s.operator = i), this.getFilterDescriptor(s.property).operators.some((h) => h.id === s.operator) || (s.operator = c.getFilterDefaultOperator(s.property)), {
      oldEntry: a,
      newEntry: s
    };
  }
  /**
   * Return the filtering type, based on oldEntry and newEntry
   * @param {Object} oldEntry
   * @param {Oject} newEntry
   * @returns {String} "add" | "remove" | "move" | "modify"
   */
  _getFilteringType(e, r) {
    return this.getQueryFilterGroup(e.property) && e.index === -1 ? "add" : r.index === -1 ? "remove" : e.index !== r.index ? "move" : "modify";
  }
  /**
   * Update filter configuration based on parameters, then fetch new data
   * @param {String} property The property to filter according to
   * @param {String} index The index of the filter entry
   * @param {String} filterEntry The filter data used to update the filter configuration
   *  filterEntry = {property, operator, value}
   *  undefined values are defaulted to current values, then to default values.
   * @param {String} filterEntry.property The new property to filter according to
   * @param {String} filterEntry.index The new index the filter should go. -1 delete filter
   * @param {String} filterEntry.operator The operator of the filter.
   *  Should match the filter descriptor of the filter property
   * @param {String} filterEntry.value Value for the new filter entry
   * @param {String} filterOperator the operat to appliy, when undefined the default filter of the entry is applied
   * @param {String} skipFetch when true, no fetch is triggered and only the reactive variables are updated, this is
   *  useful in case of asynchronous operations that need to update the UI without triggering a fetch straight away.
   * @returns {Promise}
   */
  async filter(e, r, n, { filterOperator: i, skipFetch: a } = {}) {
    const o = this._computeFilterEntries(
      e,
      r,
      n,
      { filterOperator: i }
    );
    if (!o)
      throw new Error("Property `" + e + "` is not filterable");
    const u = o.oldEntry, s = o.newEntry, c = this._getFilteringType(u, s);
    u.index !== -1 && this.getQueryFilters(u.property).splice(r, 1), s.index !== -1 && (this.getQueryFilterGroup(s.property) || this.data.query.filters.push({
      property: s.property,
      // We use by default AND between filter groups (different properties) and OR inside a
      // filter group (same property)
      matchAll: !1,
      constraints: []
    }), this.getQueryFilterGroup(s.property).constraints.splice(s.index, 0, {
      operator: s.operator,
      value: s.value
    })), this.getQueryFilters(u.property).length === 0 && await this.removeAllFilters(u.property), this.data.query.offset = 0, this.triggerEvent("filter", {
      type: c,
      oldEntry: u,
      newEntry: s
    }), a !== !0 && await this.updateEntries();
  }
  /**
   * Add new filter entry, shorthand of filter:
   * @param {String} property Which property to add the filter to
   * @param {String} operator The operator of the filter. Should match the filter descriptor of the
   *   property
   * @param {String} value Default value for the new filter entry
   * @param {Number} index Index of new filter entry. Undefined means last
   * @returns {Promise}
   */
  addFilter(e, r, n, i) {
    return i === void 0 && (i = ((this.getQueryFilterGroup(e) || {}).constraints || []).length), this.filter(e, -1, {
      property: e,
      operator: r,
      value: n,
      index: i
    });
  }
  /**
   * Remove a filter entry in the configuration, then fetch new data
   * @param {String} property Property to remove the filter to
   * @param {String} index The index of the filter to remove. Undefined means last.
   * @returns {Promise}
   */
  removeFilter(e, r) {
    return this.filter(e, r, { index: -1 });
  }
  /**
   * Remove all the filters associated to a property
   * @param {String} property Property to remove the filters to
   * @returns {Promise}
   */
  removeAllFilters(e) {
    return new Promise((r, n) => {
      const i = this.data.query.filters.findIndex((o) => o.property === e);
      if (i < 0)
        return void n();
      const a = this.data.query.filters.splice(i, 1);
      this.data.query.offset = 0, this.triggerEvent("filter", {
        type: "removeAll",
        property: e,
        removedFilters: a[0].constraints
      }), this.updateEntries().then(r, n);
    });
  }
  //
  // Translations
  //
  /**
   * @returns {Promise<boolean>} the promise is resolved to true once the translations are loaded
   */
  translationsLoaded() {
    return this.i18nPromise;
  }
  //
  // Edit Bus
  //
  setEditBus(e) {
    this.editBusInstance = e;
  }
  getEditBus() {
    return this.editBusInstance;
  }
  /**
   * Registers a panel.
   *
   * The panel must have the following attributes:
   * * id: the id of the panel, must be unique among all panels, also used as suffix of the class
   * on the panel
   * * name: the name that shall be shown in the menu
   * * title: the title that shall be displayed in the title bar of the panel
   * * icon: the name of the icon for the menu and the title of the panel
   * * container: the Element that shall be attached to the extension panel's body, this should
   * contain the main UI
   * * component: the component of the panel, should be "LiveDataAdvancedPanelExtension" for
   * extension panels
   * * order: the ordering number, panels are sorted by this number in ascending order
   *
   * @param {Object} panel the panel to add
   */
  registerPanel(e) {
    const r = this.panels.findIndex((n) => n.order > e.order);
    r === -1 ? this.panels.push(e) : this.panels.splice(r, 0, e);
  }
  //
  // Content status
  //
  /**
   * @returns {boolean} when false, the content is not trusted will be sanitized whenever Vue
   *   integrated escaping is not enough. When true, the content is never sanitized
   */
  isContentTrusted() {
    return this.contentTrusted;
  }
}
const Qt = /* @__PURE__ */ new WeakMap(), Wc = function(t, e) {
  if (!Qt.has(t)) {
    const r = new kc(t, e);
    Qt.set(t, r);
  }
  return Qt.get(t);
};
export {
  Wc as init
};
//# sourceMappingURL=init-8OCbnt4r.js.map
