import { createElementBlock as l, openBlock as o, createElementVNode as s, renderSlot as b, resolveComponent as $, createVNode as v, toDisplayString as g, withModifiers as u, createTextVNode as f, Fragment as _, renderList as k, normalizeClass as y, createCommentVNode as p, markRaw as P, createBlock as w, resolveDynamicComponent as L } from "vue";
import { _ as h, X as S, c as C } from "./main-CkFK4rnR.js";
const E = {
  name: "LivedataTopbar"
}, I = { class: "livedata-topbar" }, x = { class: "livedata-topbar-left" }, D = { class: "livedata-topbar-right" };
function z(e, a, i, r, c, t) {
  return o(), l("div", I, [
    s("div", x, [
      b(e.$slots, "left")
    ]),
    s("div", D, [
      b(e.$slots, "right")
    ])
  ]);
}
const Ce = /* @__PURE__ */ h(E, [["render", z]]), B = {
  name: "LivedataDropdownMenu",
  components: {
    XWikiIcon: S
  },
  inject: ["logic"],
  computed: {
    data() {
      return this.logic.data;
    }
  },
  methods: {
    isCurrentLayout(e) {
      return this.logic.currentLayoutId.value === e;
    },
    changeLayout(e) {
      this.isCurrentLayout(e) || this.logic.changeLayout(e);
    }
  }
}, F = { class: "livedata-dropdown-menu btn-group" }, j = ["title"], M = { class: "dropdown-menu dropdown-menu-right" }, G = { class: "dropdown-header" }, A = { class: "dropdown-header" }, T = ["onClick"], X = { class: "dropdown-header" }, N = ["onClick"];
function W(e, a, i, r, c, t) {
  const d = $("XWikiIcon");
  return o(), l("div", F, [
    s("a", {
      class: "btn btn-default dropdown-toggle",
      title: e.$t("livedata.dropdownMenu.title"),
      "data-toggle": "dropdown",
      "aria-haspopup": "true",
      "aria-expanded": "false",
      role: "button"
    }, [
      v(d, { "icon-descriptor": { name: "more-vertical" } })
    ], 8, j),
    s("ul", M, [
      s("li", null, [
        s("span", G, g(e.$t("livedata.dropdownMenu.actions")), 1),
        s("ul", null, [
          s("li", null, [
            s("a", {
              href: "#",
              onClick: a[0] || (a[0] = u((n) => t.logic.updateEntries(), ["prevent"])),
              class: "livedata-action-refresh"
            }, [
              v(d, { "icon-descriptor": { name: "repeat" } }),
              f(" " + g(e.$t("livedata.action.refresh")), 1)
            ])
          ])
        ])
      ]),
      s("li", null, [
        s("span", A, g(e.$t("livedata.dropdownMenu.layouts")), 1),
        s("ul", null, [
          (o(!0), l(_, null, k(t.data.meta.layouts, (n) => (o(), l("li", {
            key: n.id,
            class: y({
              disabled: t.isCurrentLayout(n.id)
            })
          }, [
            s("a", {
              href: "#",
              onClick: u((m) => t.changeLayout(n.id), ["prevent"])
            }, [
              v(d, {
                "icon-descriptor": n.icon
              }, null, 8, ["icon-descriptor"]),
              f(" " + g(n.name), 1)
            ], 8, T)
          ], 2))), 128))
        ])
      ]),
      s("li", null, [
        s("span", X, g(e.$t("livedata.dropdownMenu.panels")), 1),
        s("ul", null, [
          (o(!0), l(_, null, k(t.logic.panels, (n) => (o(), l("li", {
            key: n.id
          }, [
            s("a", {
              href: "#",
              onClick: u((m) => t.logic.uniqueArrayToggle(t.logic.openedPanels, n.id), ["prevent"])
            }, [
              v(d, {
                "icon-descriptor": { name: n.icon }
              }, null, 8, ["icon-descriptor"]),
              f(" " + g(n.name), 1)
            ], 8, N)
          ]))), 128))
        ])
      ])
    ])
  ]);
}
const Ee = /* @__PURE__ */ h(B, [["render", W]]), O = {
  name: "LivedataPagination",
  components: { XWikiIcon: S },
  inject: ["logic"],
  computed: {
    data() {
      return this.logic.data;
    },
    // Whether current page is first page
    isFirstPage() {
      return this.logic.getPageIndex() === 0;
    },
    // Whether current page is last page
    isLastPage() {
      return this.data.data.entries.length === 0 ? !0 : this.logic.getPageIndex() === this.logic.getPageCount() - 1;
    },
    // Return the page indexes (= page number but 0-based) to be displayed
    // It follows the following algorithm:
    // - always display the current page index
    // - then adds the following in order, until matching the shown page count
    //   - first page index
    //   - last page index
    //   - page indexes around current page index, alternating before and after it
    paginationIndexes() {
      const e = this.logic.getPageCount(), a = this.data.meta.pagination.maxShownPages, i = this.logic.getPageIndex(), r = [], c = (n) => {
        n >= 0 && n < e && !r.includes(n) && r.push(n);
      };
      a >= 1 && c(i), a >= 2 && c(0), a >= 3 && c(e - 1);
      let t = 1;
      const d = Math.max(i, e - i);
      for (; r.length < a && Math.abs(t) < d; )
        c(i + t), t > 0 ? t *= -1 : t = t * -1 + 1;
      return r.sort((n, m) => n - m);
    },
    // Add a "..." string item between page indexes that are not
    // following one each other
    // So that we know where to display the ellipsis in widget
    paginationIndexesAndDots() {
      const e = [];
      return this.paginationIndexes.forEach((a, i, r) => {
        e.push(a), r[i + 1] && r[i + 1] !== a + 1 && e.push("...");
      }), e.length === 0 && e.push(0), e;
    },
    /**
     * Merges and sort the pages sizes from the pagination as well as the configured limit.
     * @returns {number[]} the list of page sizes
     */
    pageSizes() {
      const e = /* @__PURE__ */ new Set();
      this.data.meta.pagination.pageSizes.forEach((i) => e.add(i));
      const a = this.data.query.limit;
      return a && e.add(a), [...e].sort((i, r) => i - r);
    },
    showEntryRange() {
      return this.data.meta.pagination.showEntryRange;
    }
  },
  methods: {
    changePageSize(e) {
      this.logic.setPageSize(+e.target.value);
    },
    changePageIndex(e, a) {
      e && this.logic.setPageIndex(a);
    }
  }
}, R = ["aria-label"], V = {
  key: 0,
  class: "pagination-current-entries"
}, q = {
  key: 1,
  class: "pagination-page-size"
}, U = ["title"], H = ["value", "selected"], J = { class: "pagination-indexes" }, K = ["title"], Q = ["title"], Y = ["onClick"], Z = ["title"], ee = ["title"];
function te(e, a, i, r, c, t) {
  const d = $("XWikiIcon");
  return o(), l("nav", {
    class: "livedata-pagination",
    "aria-label": this.data.id ? e.$t("livedata.pagination.label", [this.data.id]) : e.$t("livedata.pagination.label.empty")
  }, [
    t.showEntryRange ? (o(), l("span", V, g(e.$t("livedata.pagination.currentEntries", [
      t.logic.getFirstIndexOfPage() + 1,
      t.logic.getLastIndexOfPage() + 1,
      t.data.data.count
    ])), 1)) : p("", !0),
    t.data.meta.pagination.showPageSizeDropdown ? (o(), l("span", q, [
      f(g(" ") + g(e.$t("livedata.pagination.pageSize")) + " ", 1),
      s("select", {
        title: e.$t("livedata.pagination.selectPageSize"),
        onChange: a[0] || (a[0] = (...n) => t.changePageSize && t.changePageSize(...n))
      }, [
        (o(!0), l(_, null, k(t.pageSizes, (n) => (o(), l("option", {
          key: n,
          value: n,
          selected: n === t.data.query.limit
        }, g(n), 9, H))), 128))
      ], 40, U)
    ])) : p("", !0),
    s("span", J, [
      f(g(e.$t("livedata.pagination.page")) + " ", 1),
      t.data.meta.pagination.showFirstLast ? (o(), l("a", {
        key: 0,
        class: y(["page-nav", {
          disabled: t.isFirstPage
        }]),
        title: e.$t("livedata.pagination.first"),
        href: "#",
        onClick: a[1] || (a[1] = u((n) => t.changePageIndex(!t.isFirstPage, 0), ["prevent"]))
      }, [
        v(d, { "icon-descriptor": { name: "fast-backward" } })
      ], 10, K)) : p("", !0),
      t.data.meta.pagination.showNextPrevious ? (o(), l("a", {
        key: 1,
        class: y(["page-nav", {
          disabled: t.isFirstPage
        }]),
        title: e.$t("livedata.pagination.previous"),
        href: "#",
        onClick: a[2] || (a[2] = u((n) => t.changePageIndex(!t.isFirstPage, t.logic.getPageIndex() - 1), ["prevent"]))
      }, [
        v(d, { "icon-descriptor": { name: "step-backward" } })
      ], 10, Q)) : p("", !0),
      (o(!0), l(_, null, k(t.paginationIndexesAndDots, (n, m) => (o(), l(_, null, [
        n === "..." ? (o(), l("span", {
          key: "..." + m
        }, "...")) : (o(), l("a", {
          key: n,
          class: y({
            "page-nav": !0,
            current: n === t.logic.getPageIndex()
          }),
          href: "#",
          onClick: u((Pe) => t.changePageIndex(!0, n), ["prevent"])
        }, g(n + 1), 11, Y))
      ], 64))), 256)),
      t.data.meta.pagination.showNextPrevious ? (o(), l("a", {
        key: 2,
        class: y(["page-nav", {
          disabled: t.isLastPage
        }]),
        title: e.$t("livedata.pagination.next"),
        href: "#",
        onClick: a[3] || (a[3] = u((n) => t.changePageIndex(!t.isLastPage, t.logic.getPageIndex() + 1), ["prevent"]))
      }, [
        v(d, { "icon-descriptor": { name: "step-forward" } })
      ], 10, Z)) : p("", !0),
      t.data.meta.pagination.showFirstLast ? (o(), l("a", {
        key: 3,
        class: y(["page-nav", {
          disabled: t.isLastPage
        }]),
        title: e.$t("livedata.pagination.last"),
        href: "#",
        onClick: a[4] || (a[4] = u((n) => t.changePageIndex(!t.isLastPage, t.logic.getPageCount() - 1), ["prevent"]))
      }, [
        v(d, { "icon-descriptor": { name: "fast-forward" } })
      ], 10, ee)) : p("", !0)
    ])
  ], 8, R);
}
const Ie = /* @__PURE__ */ h(O, [["render", te]]), ae = {
  name: "LivedataEntrySelectorInfoBar",
  inject: ["logic"],
  computed: {
    data() {
      return this.logic.data;
    },
    // The number of selected entries to be displayed
    selectedCount() {
      return this.logic.entrySelection.isGlobal ? this.data.data.count - this.logic.entrySelection.deselected.length : this.logic.entrySelection.selected.length;
    }
  }
}, ne = {
  key: 0,
  class: "livedata-entry-selector-info-bar"
}, ie = { key: 0 }, se = { key: 1 }, oe = { key: 2 };
function le(e, a, i, r, c, t) {
  return t.selectedCount > 0 ? (o(), l("div", ne, [
    t.logic.entrySelection.isGlobal ? t.logic.entrySelection.isGlobal && !t.logic.entrySelection.deselected.length ? (o(), l("span", se, g(e.$t("livedata.selection.infoBar.allSelected")), 1)) : (o(), l("span", oe, g(e.$t("livedata.selection.infoBar.allSelectedBut", [t.logic.entrySelection.deselected.length])), 1)) : (o(), l("span", ie, g(e.$t("livedata.selection.infoBar.selectedCount", [t.selectedCount])), 1))
  ])) : p("", !0);
}
const xe = /* @__PURE__ */ h(ae, [["render", le]]), re = {
  name: "LivedataEntrySelectorAll",
  inject: ["logic"],
  computed: {
    data() {
      return this.logic.data;
    },
    entrySelection() {
      return this.logic.entrySelection;
    },
    // Whether the button is checked or not
    // It is checked if all the page entries are selected,
    // or if global mode is on
    checked() {
      const a = this.data.data.entries.filter((r) => this.logic.isSelectionEnabled({ entry: r })).every((r) => this.logic.entrySelection.selected.includes(this.logic.getEntryId(r))), i = this.entrySelection.isGlobal && this.entrySelection.deselected.length === 0;
      return a || i;
    },
    // Whether the button is indeterminate
    // It is in indeterminate state if at least one but not all
    // the page entries are selected
    indeterminate() {
      const e = this.logic.entrySelection.deselected.length > 0, a = this.logic.entrySelection.selected.length > 0;
      return e || a && !this.checked;
    }
  },
  watch: {
    // As the indeterminate state of a checkbox has to be trigger
    // by javascript (cannot be set in html),
    // we need to watch when the inderterminate state changes
    // to update the checkbox state
    indeterminate() {
      this.$refs.checkbox.indeterminate = this.indeterminate;
    }
  },
  methods: {
    // Event handler for when the user click on the checkbox
    toggle() {
      this.entrySelection.isGlobal ? this.checked ? this.logic.setEntrySelectGlobal(!1) : this.logic.setEntrySelectGlobal(!0) : this.checked ? this.logic.deselectEntries(this.logic.entrySelection.selected) : this.logic.selectEntries(this.data.data.entries);
    }
  }
}, de = { class: "livedata-entry-selector-all dropdown" }, ce = {
  class: "btn dropdown-toggle",
  type: "button",
  "data-toggle": "dropdown",
  "aria-haspopup": "true",
  "aria-expanded": "true"
}, ge = ["checked"], ue = { class: "dropdown-menu" };
function he(e, a, i, r, c, t) {
  return o(), l("div", de, [
    s("button", ce, [
      s("span", {
        class: "livedata-entry-selector-all-checkbox",
        onClick: a[2] || (a[2] = u((d) => e.$refs.checkbox.click(), ["stop", "self"]))
      }, [
        s("input", {
          ref: "checkbox",
          type: "checkbox",
          checked: t.checked,
          onClick: a[0] || (a[0] = u(() => {
          }, ["stop"])),
          onChange: a[1] || (a[1] = (...d) => t.toggle && t.toggle(...d))
        }, null, 40, ge)
      ]),
      a[4] || (a[4] = s("span", { class: "caret" }, null, -1))
    ]),
    s("ul", ue, [
      s("li", null, [
        s("a", {
          href: "#",
          onClick: a[3] || (a[3] = u((d) => t.logic.setEntrySelectGlobal(!0), ["prevent"]))
        }, g(e.$t("livedata.selection.selectInAllPages")), 1)
      ])
    ])
  ]);
}
const De = /* @__PURE__ */ h(re, [["render", he]]), pe = {
  name: "LivedataEntrySelector",
  inject: ["logic"],
  props: {
    entry: Object
  },
  computed: {
    data() {
      return this.logic.data;
    },
    // Whether the selector property is currently selected
    selected() {
      return this.logic.isEntrySelected(this.entry);
    }
  }
}, ve = ["checked"];
function ye(e, a, i, r, c, t) {
  return o(), l("div", {
    class: "livedata-entry-selector",
    onClick: a[1] || (a[1] = u((d) => e.$refs.checkbox.click(), ["self"]))
  }, [
    s("input", {
      ref: "checkbox",
      type: "checkbox",
      checked: t.selected,
      onChange: a[0] || (a[0] = (d) => t.logic.toggleSelectEntries(i.entry))
    }, null, 40, ve)
  ]);
}
const ze = /* @__PURE__ */ h(pe, [["render", ye]]), me = {
  name: "LivedataDisplayer",
  inject: ["logic"],
  data() {
    return {
      displayerComponent: null
    };
  },
  // The two props defining the Displayer
  props: {
    propertyId: String,
    entry: Object
  },
  computed: {
    data() {
      return this.logic.data;
    },
    // The displayer id of the Displayer component to load,
    // corresponding to the property id
    displayerId() {
      return this.logic.getDisplayerDescriptor(this.propertyId).id;
    }
  },
  methods: {
    // Capitalize the given string
    capitalize(e) {
      return e ??= "", e[0].toUpperCase() + e.slice(1);
    }
  },
  // On mounted, try to load the Filter corresponding to the passed props,
  // or the default one as fallback
  async mounted() {
    const e = await C.load("displayer", this.displayerId);
    this.displayerComponent = P(e);
  }
};
function fe(e, a, i, r, c, t) {
  return c.displayerComponent ? (o(), w(L(c.displayerComponent), {
    key: 0,
    class: "livedata-displayer",
    "data-livedata-property-id": i.propertyId,
    "property-id": i.propertyId,
    entry: i.entry
  }, null, 8, ["data-livedata-property-id", "property-id", "entry"])) : p("", !0);
}
const Be = /* @__PURE__ */ h(me, [["render", fe]]), _e = {
  name: "layout-loader",
  inject: ["logic"],
  data() {
    return {
      loadingData: !1,
      loadingLayout: !1,
      visible: !1,
      delay: 200
    };
  },
  computed: {
    loading() {
      return this.loadingData || this.logic.firstEntriesLoading.value || this.loadingLayout;
    }
  },
  methods: {
    watchLoading(e, a, i) {
      let r;
      this.logic.onEvent(a, () => {
        clearTimeout(r), this[e] = !0, r = setTimeout(() => {
          this.visible = !0;
        }, this.delay);
      }), this.logic.onEvent(i, () => {
        clearTimeout(r), this[e] = !1, this.visible = this.loading;
      });
    }
  },
  mounted() {
    this.watchLoading("loadingData", "beforeEntryFetch", "afterEntryFetch"), this.watchLoading("loadingLayout", "layoutChange", "layoutLoaded");
  }
};
function ke(e, a, i, r, c, t) {
  return o(), l("div", {
    class: y([{ "layout-loader": !0, waiting: t.loading, visible: c.visible }])
  }, a[0] || (a[0] = [
    s("div", { class: "loader-fill" }, null, -1)
  ]), 2);
}
const Fe = /* @__PURE__ */ h(_e, [["render", ke]]), be = {
  name: "LivedataBottombar"
}, $e = { class: "livedata-bottombar" };
function Se(e, a, i, r, c, t) {
  return o(), l("div", $e, [
    b(e.$slots, "default")
  ]);
}
const je = /* @__PURE__ */ h(be, [["render", Se]]);
export {
  De as L,
  Be as a,
  ze as b,
  Fe as c,
  xe as d,
  Ie as e,
  Ee as f,
  Ce as g,
  je as h
};
//# sourceMappingURL=LivedataBottombar-DdNCbIDm.js.map
